
#line 1 "ragel/i18n/el.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "ragel/i18n/el.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 12, 21, 22, 23, 24, 25, 
	26, 27, 28, 30, 32, 43, 44, 45, 
	47, 49, 54, 59, 64, 69, 73, 77, 
	79, 80, 81, 82, 83, 84, 85, 86, 
	87, 88, 89, 90, 91, 92, 93, 94, 
	99, 106, 111, 115, 121, 124, 126, 132, 
	143, 144, 145, 146, 147, 148, 149, 151, 
	152, 153, 154, 155, 156, 157, 158, 159, 
	160, 161, 162, 163, 164, 165, 166, 167, 
	168, 169, 170, 171, 172, 173, 174, 175, 
	176, 177, 178, 179, 180, 181, 182, 183, 
	184, 185, 186, 194, 200, 202, 204, 206, 
	208, 210, 212, 214, 216, 218, 220, 222, 
	224, 226, 228, 230, 232, 234, 236, 238, 
	249, 251, 253, 255, 257, 259, 261, 263, 
	265, 267, 269, 271, 273, 275, 277, 279, 
	281, 283, 286, 288, 290, 292, 294, 296, 
	298, 300, 302, 304, 306, 308, 310, 312, 
	314, 316, 318, 320, 322, 324, 326, 328, 
	330, 332, 334, 336, 338, 340, 342, 344, 
	346, 348, 350, 352, 354, 356, 358, 360, 
	362, 364, 366, 368, 370, 372, 374, 376, 
	378, 380, 382, 384, 386, 388, 390, 392, 
	394, 396, 398, 400, 402, 405, 407, 409, 
	411, 413, 415, 417, 419, 421, 423, 425, 
	427, 429, 431, 433, 435, 437, 439, 441, 
	443, 445, 447, 449, 451, 453, 455, 457, 
	459, 461, 462, 463, 464, 465, 466, 467, 
	468, 469, 470, 471, 472, 473, 474, 475, 
	476, 477, 478, 479, 480, 481, 482, 484, 
	485, 486, 487, 488, 489, 490, 491, 492, 
	493, 494, 495, 496, 497, 498, 499, 500, 
	501, 502, 503, 504, 505, 506, 507, 514, 
	517, 519, 521, 523, 525, 527, 529, 531, 
	533, 535, 537, 539, 541, 543, 545, 547, 
	549, 551, 553, 555, 557, 559, 561, 563, 
	565, 567, 569, 571, 573, 575, 577, 579, 
	581, 583, 585, 587, 588, 589, 590, 591, 
	592, 593, 594, 595, 596, 597, 598, 599, 
	600, 601, 602, 603, 604, 605, 606, 607, 
	608, 609, 610, 611, 612, 613, 614, 615, 
	616, 617, 618, 619, 620, 621, 630, 638, 
	640, 642, 644, 646, 648, 650, 652, 654, 
	656, 658, 660, 662, 664, 667, 669, 671, 
	673, 675, 677, 679, 681, 683, 685, 687, 
	689, 691, 693, 695, 697, 699, 701, 703, 
	705, 707, 709, 711, 713, 715, 717, 719, 
	721, 723, 725, 727, 729, 731, 733, 735, 
	737, 739, 741, 743, 745, 747, 749, 751, 
	753, 755, 757, 759, 761, 763, 765, 767, 
	769, 771, 773, 775, 777, 779, 781, 783, 
	785, 787, 789, 791, 793, 795, 797, 799, 
	801, 803, 805, 807, 809, 811, 813, 815, 
	817, 819, 821, 823, 825, 827, 829, 831, 
	833, 835, 837, 838, 839, 840, 841, 842, 
	843, 844, 845, 846, 847, 848, 850, 851, 
	852, 853, 862, 872, 874, 876, 878, 880, 
	882, 884, 886, 888, 890, 892, 894, 896, 
	898, 901, 903, 905, 907, 909, 911, 913, 
	915, 917, 919, 921, 923, 925, 927, 929, 
	931, 933, 935, 937, 939, 941, 943, 945, 
	947, 949, 951, 953, 955, 957, 959, 961, 
	963, 965, 967, 969, 971, 973, 975, 977, 
	979, 981, 983, 985, 987, 989, 991, 993, 
	995, 997, 999, 1001, 1003, 1005, 1007, 1009, 
	1011, 1013, 1015, 1017, 1019, 1021, 1023, 1025, 
	1027, 1029, 1031, 1033, 1035, 1037, 1039, 1041, 
	1043, 1045, 1047, 1049, 1051, 1053, 1055, 1057, 
	1059, 1061, 1063, 1065, 1067, 1069, 1071, 1073, 
	1075, 1077, 1079, 1081, 1083, 1085, 1087, 1089, 
	1091, 1093, 1095, 1097, 1099, 1101, 1103, 1105, 
	1107, 1109, 1111, 1113, 1115, 1117, 1119, 1121, 
	1123, 1125, 1127, 1129, 1131, 1133, 1135, 1137, 
	1139, 1141, 1143, 1145, 1147, 1149, 1151, 1153, 
	1155, 1157, 1159, 1161, 1162, 1163, 1164, 1165, 
	1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 
	1174, 1175, 1176, 1177, 1178, 1179, 1180, 1181, 
	1182, 1183, 1184, 1193, 1202, 1204, 1206, 1208, 
	1210, 1212, 1214, 1216, 1218, 1220, 1222, 1224, 
	1226, 1228, 1231, 1233, 1235, 1237, 1239, 1241, 
	1243, 1245, 1247, 1249, 1251, 1253, 1255, 1257, 
	1259, 1261, 1263, 1265, 1267, 1269, 1271, 1273, 
	1275, 1277, 1279, 1281, 1283, 1285, 1287, 1289, 
	1291, 1293, 1295, 1297, 1299, 1301, 1303, 1305, 
	1307, 1309, 1311, 1313, 1315, 1317, 1319, 1321, 
	1323, 1325, 1327, 1329, 1331, 1333, 1335, 1337, 
	1339, 1341, 1343, 1345, 1347, 1349, 1351, 1353, 
	1355, 1357, 1359, 1361, 1363, 1365, 1367, 1369, 
	1371, 1373, 1375, 1377, 1379, 1381, 1383, 1385, 
	1387, 1389, 1391, 1393, 1395, 1397, 1399, 1401, 
	1403, 1405, 1407, 1409, 1411, 1413, 1415, 1417, 
	1419, 1421, 1423, 1425, 1427, 1429, 1431, 1433, 
	1435, 1437, 1439, 1441, 1443, 1445, 1447, 1449, 
	1451, 1453, 1455, 1457, 1459, 1461, 1463, 1465, 
	1467, 1468, 1469
};

static const char _lexer_trans_keys[] = {
	-50, -17, 10, 32, 34, 35, 37, 42, 
	64, 124, 9, 13, -116, -111, -108, -102, 
	-101, -96, -93, -92, -91, -49, -124, -50, 
	-79, -50, -67, 32, 10, 13, 10, 13, 
	-50, 10, 32, 34, 35, 37, 42, 64, 
	124, 9, 13, 34, 34, 10, 13, 10, 
	13, 10, 32, 34, 9, 13, 10, 32, 
	34, 9, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 9, 
	13, 10, 32, 9, 13, 10, 13, 10, 
	95, 70, 69, 65, 84, 85, 82, 69, 
	95, 69, 78, 68, 95, 37, 13, 32, 
	64, 9, 10, 9, 10, 13, 32, 64, 
	11, 12, 10, 32, 64, 9, 13, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, -50, 10, 32, 34, 
	35, 37, 42, 64, 124, 9, 13, -50, 
	-69, -50, -69, -50, -84, -50, -49, -75, 
	-50, -76, -50, -65, -50, -68, -50, -83, 
	-50, -67, -50, -65, -49, -123, -123, -50, 
	-67, -50, -79, -49, -124, -49, -116, -49, 
	-124, -50, -73, -49, -124, -50, -79, 58, 
	10, 10, -50, 10, 32, 35, 37, 64, 
	9, 13, -108, -101, -96, -93, -91, 10, 
	-49, 10, -123, 10, -50, 10, -67, 10, 
	-50, 10, -79, 10, -49, 10, -124, 10, 
	-49, 10, -116, 10, -49, 10, -124, 10, 
	-50, 10, -73, 10, -49, 10, -124, 10, 
	-50, 10, -79, 10, 10, 58, -50, 10, 
	32, 34, 35, 37, 42, 64, 124, 9, 
	13, -50, 10, -75, 10, -50, 10, -71, 
	10, -49, 10, -124, 10, -50, 10, -65, 
	10, -49, 10, -123, 10, -49, 10, -127, 
	10, -50, 10, -77, 10, -50, 10, -81, 
	10, -50, 10, -79, -75, 10, -49, 10, 
	-127, 10, -50, 10, -79, 10, -50, 10, 
	-76, 10, -50, 10, -75, 10, -50, 10, 
	-81, 10, -50, 10, -77, 10, -50, 10, 
	-68, 10, -50, 10, -79, 10, -49, 10, 
	-127, 10, -50, 10, -71, 10, -50, 10, 
	-77, 10, -49, 10, -127, 10, -50, 10, 
	-79, 10, -49, 10, -122, 10, -50, 10, 
	-82, 10, 10, 32, -50, 10, -93, 10, 
	-50, 10, -75, 10, -50, 10, -67, 10, 
	-50, 10, -79, 10, -49, 10, -127, 10, 
	-50, 10, -81, 10, -50, 10, -65, 10, 
	-49, 10, -123, 10, -50, 10, -75, 10, 
	-50, 10, -67, 10, -50, 10, -84, 10, 
	-49, 10, -127, 10, -50, 10, -71, 10, 
	-50, 10, -79, -65, 10, -49, 10, -128, 
	10, -49, 10, -116, 10, -50, 10, -78, 
	10, -50, 10, -79, 10, -50, 10, -72, 
	10, -49, 10, -127, 10, -50, 10, -65, 
	10, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, -50, -79, -50, 
	-71, -50, -75, -50, -71, -49, -124, -50, 
	-65, -49, -123, -49, -127, -50, -77, -50, 
	-81, -50, -79, -75, -49, -127, -50, -79, 
	-50, -76, -50, -75, -50, -81, -50, -77, 
	-50, -68, -50, -79, -49, -124, -50, -79, 
	58, 10, 10, -50, 10, 32, 35, 124, 
	9, 13, -108, -101, 10, -49, 10, -123, 
	10, -50, 10, -67, 10, -50, 10, -79, 
	10, -49, 10, -124, 10, -49, 10, -116, 
	10, -49, 10, -124, 10, -50, 10, -73, 
	10, -49, 10, -124, 10, -50, 10, -79, 
	10, 10, 58, -50, 10, -75, 10, -50, 
	10, -71, 10, -49, 10, -124, 10, -50, 
	10, -65, 10, -49, 10, -123, 10, -49, 
	10, -127, 10, -50, 10, -77, 10, -50, 
	10, -81, 10, -49, -127, -50, -71, -50, 
	-77, -49, -127, -50, -79, -49, -122, -50, 
	-82, 32, -50, -93, -50, -75, -50, -67, 
	-50, -79, -49, -127, -50, -81, -50, -65, 
	-49, -123, 58, 10, 10, -50, 10, 32, 
	35, 37, 42, 64, 9, 13, -116, -111, 
	-108, -102, -101, -93, -92, 10, -49, 10, 
	-124, 10, -50, 10, -79, 10, -50, 10, 
	-67, 10, 10, 32, -50, 10, -69, 10, 
	-50, 10, -69, 10, -50, 10, -84, 10, 
	-50, -49, 10, -75, 10, -50, 10, -76, 
	10, -50, 10, -65, 10, -50, 10, -68, 
	10, -50, 10, -83, 10, -50, 10, -67, 
	10, -50, 10, -65, 10, -49, 10, -123, 
	10, -123, 10, -50, 10, -67, 10, -50, 
	10, -79, 10, -49, 10, -124, 10, -49, 
	10, -116, 10, -49, 10, -124, 10, -50, 
	10, -73, 10, -49, 10, -124, 10, -50, 
	10, -79, 10, 10, 58, -50, 10, -79, 
	10, -50, 10, -71, 10, -50, 10, -75, 
	10, -50, 10, -71, 10, -49, 10, -124, 
	10, -50, 10, -65, 10, -49, 10, -123, 
	10, -49, 10, -127, 10, -50, 10, -77, 
	10, -50, 10, -81, 10, -50, 10, -75, 
	10, -50, 10, -67, 10, -50, 10, -84, 
	10, -49, 10, -127, 10, -50, 10, -71, 
	10, -50, 10, -65, 10, -49, 10, -116, 
	10, -49, 10, -124, 10, -50, 10, -75, 
	10, 10, 95, 10, 70, 10, 69, 10, 
	65, 10, 84, 10, 85, 10, 82, 10, 
	69, 10, 95, 10, 69, 10, 78, 10, 
	68, 10, 95, 10, 37, -50, -75, -50, 
	-67, -50, -84, -49, -127, -50, -71, -50, 
	-79, -65, 58, 10, 10, -50, 10, 32, 
	35, 37, 42, 64, 9, 13, -116, -111, 
	-108, -102, -101, -96, -93, -92, -91, 10, 
	-49, 10, -124, 10, -50, 10, -79, 10, 
	-50, 10, -67, 10, 10, 32, -50, 10, 
	-69, 10, -50, 10, -69, 10, -50, 10, 
	-84, 10, -50, -49, 10, -75, 10, -50, 
	10, -76, 10, -50, 10, -65, 10, -50, 
	10, -68, 10, -50, 10, -83, 10, -50, 
	10, -67, 10, -50, 10, -65, 10, -49, 
	10, -123, 10, -123, 10, -50, 10, -67, 
	10, -50, 10, -79, 10, -49, 10, -124, 
	10, -49, 10, -116, 10, -49, 10, -124, 
	10, -50, 10, -73, 10, -49, 10, -124, 
	10, -50, 10, -79, 10, 10, 58, -50, 
	10, -79, 10, -50, 10, -71, 10, -50, 
	10, -75, 10, -50, 10, -71, 10, -49, 
	10, -124, 10, -50, 10, -65, 10, -49, 
	10, -123, 10, -49, 10, -127, 10, -50, 
	10, -77, 10, -50, 10, -81, 10, -50, 
	10, -75, 10, -49, 10, -127, 10, -50, 
	10, -71, 10, -50, 10, -77, 10, -49, 
	10, -127, 10, -50, 10, -79, 10, -49, 
	10, -122, 10, -50, 10, -82, 10, 10, 
	32, -50, 10, -93, 10, -50, 10, -75, 
	10, -50, 10, -67, 10, -50, 10, -79, 
	10, -49, 10, -127, 10, -50, 10, -81, 
	10, -50, 10, -65, 10, -49, 10, -123, 
	10, -50, 10, -75, 10, -50, 10, -67, 
	10, -50, 10, -84, 10, -49, 10, -127, 
	10, -50, 10, -71, 10, -50, 10, -65, 
	10, -49, 10, -116, 10, -49, 10, -124, 
	10, -50, 10, -75, 10, -49, 10, -128, 
	10, -49, 10, -116, 10, -50, 10, -78, 
	10, -50, 10, -79, 10, -50, 10, -72, 
	10, -49, 10, -127, 10, 10, 95, 10, 
	70, 10, 69, 10, 65, 10, 84, 10, 
	85, 10, 82, 10, 69, 10, 95, 10, 
	69, 10, 78, 10, 68, 10, 95, 10, 
	37, -49, -116, -49, -124, -50, -75, -49, 
	-128, -49, -116, -50, -78, -50, -79, -50, 
	-72, -49, -127, -50, -65, 58, 10, 10, 
	-50, 10, 32, 35, 37, 42, 64, 9, 
	13, -116, -111, -108, -102, -101, -96, -93, 
	-92, 10, -49, 10, -124, 10, -50, 10, 
	-79, 10, -50, 10, -67, 10, 10, 32, 
	-50, 10, -69, 10, -50, 10, -69, 10, 
	-50, 10, -84, 10, -50, -49, 10, -75, 
	10, -50, 10, -76, 10, -50, 10, -65, 
	10, -50, 10, -68, 10, -50, 10, -83, 
	10, -50, 10, -67, 10, -50, 10, -65, 
	10, -49, 10, -123, 10, -123, 10, -50, 
	10, -67, 10, -50, 10, -79, 10, -49, 
	10, -124, 10, -49, 10, -116, 10, -49, 
	10, -124, 10, -50, 10, -73, 10, -49, 
	10, -124, 10, -50, 10, -79, 10, 10, 
	58, -50, 10, -79, 10, -50, 10, -71, 
	10, -50, 10, -75, 10, -50, 10, -71, 
	10, -49, 10, -124, 10, -50, 10, -65, 
	10, -49, 10, -123, 10, -49, 10, -127, 
	10, -50, 10, -77, 10, -50, 10, -81, 
	10, -50, 10, -75, 10, -49, 10, -127, 
	10, -50, 10, -71, 10, -50, 10, -77, 
	10, -49, 10, -127, 10, -50, 10, -79, 
	10, -49, 10, -122, 10, -50, 10, -82, 
	10, 10, 32, -50, 10, -93, 10, -50, 
	10, -75, 10, -50, 10, -67, 10, -50, 
	10, -79, 10, -49, 10, -127, 10, -50, 
	10, -81, 10, -50, 10, -65, 10, -49, 
	10, -123, 10, -50, 10, -75, 10, -50, 
	10, -67, 10, -50, 10, -84, 10, -49, 
	10, -127, 10, -50, 10, -71, 10, -50, 
	10, -65, 10, -49, 10, -116, 10, -49, 
	10, -124, 10, -50, 10, -75, 10, 10, 
	95, 10, 70, 10, 69, 10, 65, 10, 
	84, 10, 85, 10, 82, 10, 69, 10, 
	95, 10, 69, 10, 78, 10, 68, 10, 
	95, 10, 37, -69, -65, 0
};

static const char _lexer_single_lengths[] = {
	0, 10, 9, 1, 1, 1, 1, 1, 
	1, 1, 2, 2, 9, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 3, 
	5, 3, 2, 4, 3, 2, 4, 9, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 6, 6, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 9, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 5, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 7, 8, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 2, 1, 1, 
	1, 7, 10, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	3, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 7, 9, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	1, 1, 1, 1, 0, 0, 1, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 1, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 12, 22, 24, 26, 28, 30, 
	32, 34, 36, 39, 42, 53, 55, 57, 
	60, 63, 68, 73, 78, 83, 87, 91, 
	94, 96, 98, 100, 102, 104, 106, 108, 
	110, 112, 114, 116, 118, 120, 122, 124, 
	129, 136, 141, 145, 151, 155, 158, 164, 
	175, 177, 179, 181, 183, 185, 187, 190, 
	192, 194, 196, 198, 200, 202, 204, 206, 
	208, 210, 212, 214, 216, 218, 220, 222, 
	224, 226, 228, 230, 232, 234, 236, 238, 
	240, 242, 244, 246, 248, 250, 252, 254, 
	256, 258, 260, 268, 275, 278, 281, 284, 
	287, 290, 293, 296, 299, 302, 305, 308, 
	311, 314, 317, 320, 323, 326, 329, 332, 
	343, 346, 349, 352, 355, 358, 361, 364, 
	367, 370, 373, 376, 379, 382, 385, 388, 
	391, 394, 398, 401, 404, 407, 410, 413, 
	416, 419, 422, 425, 428, 431, 434, 437, 
	440, 443, 446, 449, 452, 455, 458, 461, 
	464, 467, 470, 473, 476, 479, 482, 485, 
	488, 491, 494, 497, 500, 503, 506, 509, 
	512, 515, 518, 521, 524, 527, 530, 533, 
	536, 539, 542, 545, 548, 551, 554, 557, 
	560, 563, 566, 569, 572, 576, 579, 582, 
	585, 588, 591, 594, 597, 600, 603, 606, 
	609, 612, 615, 618, 621, 624, 627, 630, 
	633, 636, 639, 642, 645, 648, 651, 654, 
	657, 660, 662, 664, 666, 668, 670, 672, 
	674, 676, 678, 680, 682, 684, 686, 688, 
	690, 692, 694, 696, 698, 700, 702, 705, 
	707, 709, 711, 713, 715, 717, 719, 721, 
	723, 725, 727, 729, 731, 733, 735, 737, 
	739, 741, 743, 745, 747, 749, 751, 758, 
	762, 765, 768, 771, 774, 777, 780, 783, 
	786, 789, 792, 795, 798, 801, 804, 807, 
	810, 813, 816, 819, 822, 825, 828, 831, 
	834, 837, 840, 843, 846, 849, 852, 855, 
	858, 861, 864, 867, 869, 871, 873, 875, 
	877, 879, 881, 883, 885, 887, 889, 891, 
	893, 895, 897, 899, 901, 903, 905, 907, 
	909, 911, 913, 915, 917, 919, 921, 923, 
	925, 927, 929, 931, 933, 935, 944, 953, 
	956, 959, 962, 965, 968, 971, 974, 977, 
	980, 983, 986, 989, 992, 996, 999, 1002, 
	1005, 1008, 1011, 1014, 1017, 1020, 1023, 1026, 
	1029, 1032, 1035, 1038, 1041, 1044, 1047, 1050, 
	1053, 1056, 1059, 1062, 1065, 1068, 1071, 1074, 
	1077, 1080, 1083, 1086, 1089, 1092, 1095, 1098, 
	1101, 1104, 1107, 1110, 1113, 1116, 1119, 1122, 
	1125, 1128, 1131, 1134, 1137, 1140, 1143, 1146, 
	1149, 1152, 1155, 1158, 1161, 1164, 1167, 1170, 
	1173, 1176, 1179, 1182, 1185, 1188, 1191, 1194, 
	1197, 1200, 1203, 1206, 1209, 1212, 1215, 1218, 
	1221, 1224, 1227, 1230, 1233, 1236, 1239, 1242, 
	1245, 1248, 1251, 1253, 1255, 1257, 1259, 1261, 
	1263, 1265, 1267, 1269, 1271, 1273, 1276, 1278, 
	1280, 1282, 1291, 1302, 1305, 1308, 1311, 1314, 
	1317, 1320, 1323, 1326, 1329, 1332, 1335, 1338, 
	1341, 1345, 1348, 1351, 1354, 1357, 1360, 1363, 
	1366, 1369, 1372, 1375, 1378, 1381, 1384, 1387, 
	1390, 1393, 1396, 1399, 1402, 1405, 1408, 1411, 
	1414, 1417, 1420, 1423, 1426, 1429, 1432, 1435, 
	1438, 1441, 1444, 1447, 1450, 1453, 1456, 1459, 
	1462, 1465, 1468, 1471, 1474, 1477, 1480, 1483, 
	1486, 1489, 1492, 1495, 1498, 1501, 1504, 1507, 
	1510, 1513, 1516, 1519, 1522, 1525, 1528, 1531, 
	1534, 1537, 1540, 1543, 1546, 1549, 1552, 1555, 
	1558, 1561, 1564, 1567, 1570, 1573, 1576, 1579, 
	1582, 1585, 1588, 1591, 1594, 1597, 1600, 1603, 
	1606, 1609, 1612, 1615, 1618, 1621, 1624, 1627, 
	1630, 1633, 1636, 1639, 1642, 1645, 1648, 1651, 
	1654, 1657, 1660, 1663, 1666, 1669, 1672, 1675, 
	1678, 1681, 1684, 1687, 1690, 1693, 1696, 1699, 
	1702, 1705, 1708, 1711, 1714, 1717, 1720, 1723, 
	1726, 1729, 1732, 1735, 1737, 1739, 1741, 1743, 
	1745, 1747, 1749, 1751, 1753, 1755, 1757, 1759, 
	1761, 1763, 1765, 1767, 1769, 1771, 1773, 1775, 
	1777, 1779, 1781, 1790, 1800, 1803, 1806, 1809, 
	1812, 1815, 1818, 1821, 1824, 1827, 1830, 1833, 
	1836, 1839, 1843, 1846, 1849, 1852, 1855, 1858, 
	1861, 1864, 1867, 1870, 1873, 1876, 1879, 1882, 
	1885, 1888, 1891, 1894, 1897, 1900, 1903, 1906, 
	1909, 1912, 1915, 1918, 1921, 1924, 1927, 1930, 
	1933, 1936, 1939, 1942, 1945, 1948, 1951, 1954, 
	1957, 1960, 1963, 1966, 1969, 1972, 1975, 1978, 
	1981, 1984, 1987, 1990, 1993, 1996, 1999, 2002, 
	2005, 2008, 2011, 2014, 2017, 2020, 2023, 2026, 
	2029, 2032, 2035, 2038, 2041, 2044, 2047, 2050, 
	2053, 2056, 2059, 2062, 2065, 2068, 2071, 2074, 
	2077, 2080, 2083, 2086, 2089, 2092, 2095, 2098, 
	2101, 2104, 2107, 2110, 2113, 2116, 2119, 2122, 
	2125, 2128, 2131, 2134, 2137, 2140, 2143, 2146, 
	2149, 2152, 2155, 2158, 2161, 2164, 2167, 2170, 
	2173, 2176, 2179, 2182, 2185, 2188, 2191, 2194, 
	2197, 2199, 2201
};

static const short _lexer_trans_targs[] = {
	2, 752, 12, 12, 13, 23, 25, 9, 
	39, 42, 12, 0, 3, 48, 54, 217, 
	221, 237, 434, 595, 601, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 12, 24, 11, 12, 
	24, 11, 2, 12, 12, 13, 23, 25, 
	9, 39, 42, 12, 0, 14, 0, 15, 
	0, 17, 16, 16, 17, 16, 16, 18, 
	18, 19, 18, 18, 18, 18, 19, 18, 
	18, 18, 18, 20, 18, 18, 18, 18, 
	21, 18, 18, 12, 22, 22, 0, 12, 
	22, 22, 0, 12, 24, 23, 12, 0, 
	26, 0, 27, 0, 28, 0, 29, 0, 
	30, 0, 31, 0, 32, 0, 33, 0, 
	34, 0, 35, 0, 36, 0, 37, 0, 
	38, 0, 754, 0, 0, 0, 0, 0, 
	40, 41, 12, 41, 41, 39, 40, 40, 
	12, 41, 39, 41, 0, 42, 43, 42, 
	0, 47, 46, 45, 43, 46, 44, 0, 
	45, 43, 44, 0, 45, 44, 47, 46, 
	45, 43, 46, 44, 2, 47, 47, 13, 
	23, 25, 9, 39, 42, 47, 0, 49, 
	0, 50, 0, 51, 0, 52, 0, 53, 
	0, 9, 0, 55, 70, 0, 56, 0, 
	57, 0, 58, 0, 59, 0, 60, 0, 
	61, 0, 62, 0, 63, 0, 64, 0, 
	65, 0, 66, 0, 67, 0, 68, 0, 
	69, 0, 9, 0, 71, 0, 72, 0, 
	73, 0, 74, 0, 75, 0, 76, 0, 
	77, 0, 78, 0, 79, 0, 80, 0, 
	81, 0, 82, 0, 83, 0, 84, 0, 
	85, 0, 86, 0, 87, 0, 88, 0, 
	90, 89, 90, 89, 91, 90, 90, 12, 
	203, 12, 90, 89, 92, 112, 128, 177, 
	189, 90, 89, 93, 90, 89, 94, 90, 
	89, 95, 90, 89, 96, 90, 89, 97, 
	90, 89, 98, 90, 89, 99, 90, 89, 
	100, 90, 89, 101, 90, 89, 102, 90, 
	89, 103, 90, 89, 104, 90, 89, 105, 
	90, 89, 106, 90, 89, 107, 90, 89, 
	108, 90, 89, 109, 90, 89, 110, 90, 
	89, 90, 111, 89, 2, 12, 12, 13, 
	23, 25, 9, 39, 42, 12, 0, 113, 
	90, 89, 114, 90, 89, 115, 90, 89, 
	116, 90, 89, 117, 90, 89, 118, 90, 
	89, 119, 90, 89, 120, 90, 89, 121, 
	90, 89, 122, 90, 89, 123, 90, 89, 
	124, 90, 89, 125, 90, 89, 126, 90, 
	89, 127, 90, 89, 108, 90, 89, 129, 
	90, 89, 130, 146, 90, 89, 131, 90, 
	89, 132, 90, 89, 133, 90, 89, 134, 
	90, 89, 135, 90, 89, 136, 90, 89, 
	137, 90, 89, 138, 90, 89, 139, 90, 
	89, 140, 90, 89, 141, 90, 89, 142, 
	90, 89, 143, 90, 89, 144, 90, 89, 
	145, 90, 89, 106, 90, 89, 147, 90, 
	89, 148, 90, 89, 149, 90, 89, 150, 
	90, 89, 151, 90, 89, 152, 90, 89, 
	153, 90, 89, 154, 90, 89, 155, 90, 
	89, 156, 90, 89, 157, 90, 89, 158, 
	90, 89, 159, 90, 89, 160, 90, 89, 
	90, 161, 89, 162, 90, 89, 163, 90, 
	89, 164, 90, 89, 165, 90, 89, 166, 
	90, 89, 167, 90, 89, 168, 90, 89, 
	169, 90, 89, 170, 90, 89, 171, 90, 
	89, 172, 90, 89, 173, 90, 89, 174, 
	90, 89, 175, 90, 89, 176, 90, 89, 
	110, 90, 89, 178, 90, 89, 179, 90, 
	89, 180, 90, 89, 181, 90, 89, 182, 
	90, 89, 183, 90, 89, 184, 90, 89, 
	185, 90, 89, 186, 90, 89, 187, 90, 
	89, 188, 90, 89, 110, 110, 90, 89, 
	190, 90, 89, 191, 90, 89, 192, 90, 
	89, 193, 90, 89, 194, 90, 89, 195, 
	90, 89, 196, 90, 89, 197, 90, 89, 
	198, 90, 89, 199, 90, 89, 200, 90, 
	89, 201, 90, 89, 202, 90, 89, 110, 
	90, 89, 90, 204, 89, 90, 205, 89, 
	90, 206, 89, 90, 207, 89, 90, 208, 
	89, 90, 209, 89, 90, 210, 89, 90, 
	211, 89, 90, 212, 89, 90, 213, 89, 
	90, 214, 89, 90, 215, 89, 90, 216, 
	89, 90, 12, 89, 218, 0, 219, 0, 
	220, 0, 9, 0, 222, 0, 223, 0, 
	224, 0, 225, 0, 226, 0, 227, 0, 
	228, 0, 229, 0, 230, 0, 231, 0, 
	232, 0, 233, 0, 234, 0, 235, 0, 
	236, 0, 85, 0, 238, 0, 239, 299, 
	0, 240, 0, 241, 0, 242, 0, 243, 
	0, 244, 0, 245, 0, 246, 0, 247, 
	0, 248, 0, 249, 0, 250, 0, 251, 
	0, 252, 0, 253, 0, 254, 0, 255, 
	0, 256, 0, 257, 0, 258, 0, 259, 
	0, 260, 0, 262, 261, 262, 261, 263, 
	262, 262, 12, 12, 262, 261, 264, 283, 
	262, 261, 265, 262, 261, 266, 262, 261, 
	267, 262, 261, 268, 262, 261, 269, 262, 
	261, 270, 262, 261, 271, 262, 261, 272, 
	262, 261, 273, 262, 261, 274, 262, 261, 
	275, 262, 261, 276, 262, 261, 277, 262, 
	261, 278, 262, 261, 279, 262, 261, 280, 
	262, 261, 281, 262, 261, 282, 262, 261, 
	262, 111, 261, 284, 262, 261, 285, 262, 
	261, 286, 262, 261, 287, 262, 261, 288, 
	262, 261, 289, 262, 261, 290, 262, 261, 
	291, 262, 261, 292, 262, 261, 293, 262, 
	261, 294, 262, 261, 295, 262, 261, 296, 
	262, 261, 297, 262, 261, 298, 262, 261, 
	280, 262, 261, 300, 0, 301, 0, 302, 
	0, 303, 0, 304, 0, 305, 0, 306, 
	0, 307, 0, 308, 0, 309, 0, 310, 
	0, 311, 0, 312, 0, 313, 0, 314, 
	0, 315, 0, 316, 0, 317, 0, 318, 
	0, 319, 0, 320, 0, 321, 0, 322, 
	0, 323, 0, 324, 0, 325, 0, 326, 
	0, 327, 0, 328, 0, 329, 0, 330, 
	0, 331, 0, 333, 332, 333, 332, 334, 
	333, 333, 12, 420, 341, 12, 333, 332, 
	335, 342, 348, 382, 386, 402, 414, 333, 
	332, 336, 333, 332, 337, 333, 332, 338, 
	333, 332, 339, 333, 332, 340, 333, 332, 
	341, 333, 332, 333, 111, 332, 343, 333, 
	332, 344, 333, 332, 345, 333, 332, 346, 
	333, 332, 347, 333, 332, 341, 333, 332, 
	349, 364, 333, 332, 350, 333, 332, 351, 
	333, 332, 352, 333, 332, 353, 333, 332, 
	354, 333, 332, 355, 333, 332, 356, 333, 
	332, 357, 333, 332, 358, 333, 332, 359, 
	333, 332, 360, 333, 332, 361, 333, 332, 
	362, 333, 332, 363, 333, 332, 341, 333, 
	332, 365, 333, 332, 366, 333, 332, 367, 
	333, 332, 368, 333, 332, 369, 333, 332, 
	370, 333, 332, 371, 333, 332, 372, 333, 
	332, 373, 333, 332, 374, 333, 332, 375, 
	333, 332, 376, 333, 332, 377, 333, 332, 
	378, 333, 332, 379, 333, 332, 380, 333, 
	332, 381, 333, 332, 333, 111, 332, 383, 
	333, 332, 384, 333, 332, 385, 333, 332, 
	341, 333, 332, 387, 333, 332, 388, 333, 
	332, 389, 333, 332, 390, 333, 332, 391, 
	333, 332, 392, 333, 332, 393, 333, 332, 
	394, 333, 332, 395, 333, 332, 396, 333, 
	332, 397, 333, 332, 398, 333, 332, 399, 
	333, 332, 400, 333, 332, 401, 333, 332, 
	379, 333, 332, 403, 333, 332, 404, 333, 
	332, 405, 333, 332, 406, 333, 332, 407, 
	333, 332, 408, 333, 332, 409, 333, 332, 
	410, 333, 332, 411, 333, 332, 412, 333, 
	332, 413, 333, 332, 381, 333, 332, 415, 
	333, 332, 416, 333, 332, 417, 333, 332, 
	418, 333, 332, 419, 333, 332, 341, 333, 
	332, 333, 421, 332, 333, 422, 332, 333, 
	423, 332, 333, 424, 332, 333, 425, 332, 
	333, 426, 332, 333, 427, 332, 333, 428, 
	332, 333, 429, 332, 333, 430, 332, 333, 
	431, 332, 333, 432, 332, 333, 433, 332, 
	333, 12, 332, 435, 0, 436, 0, 437, 
	0, 438, 0, 439, 0, 440, 0, 441, 
	0, 442, 0, 443, 0, 444, 0, 445, 
	0, 259, 446, 0, 447, 0, 449, 448, 
	449, 448, 450, 449, 449, 12, 581, 457, 
	12, 449, 448, 451, 458, 464, 498, 502, 
	518, 551, 563, 569, 449, 448, 452, 449, 
	448, 453, 449, 448, 454, 449, 448, 455, 
	449, 448, 456, 449, 448, 457, 449, 448, 
	449, 111, 448, 459, 449, 448, 460, 449, 
	448, 461, 449, 448, 462, 449, 448, 463, 
	449, 448, 457, 449, 448, 465, 480, 449, 
	448, 466, 449, 448, 467, 449, 448, 468, 
	449, 448, 469, 449, 448, 470, 449, 448, 
	471, 449, 448, 472, 449, 448, 473, 449, 
	448, 474, 449, 448, 475, 449, 448, 476, 
	449, 448, 477, 449, 448, 478, 449, 448, 
	479, 449, 448, 457, 449, 448, 481, 449, 
	448, 482, 449, 448, 483, 449, 448, 484, 
	449, 448, 485, 449, 448, 486, 449, 448, 
	487, 449, 448, 488, 449, 448, 489, 449, 
	448, 490, 449, 448, 491, 449, 448, 492, 
	449, 448, 493, 449, 448, 494, 449, 448, 
	495, 449, 448, 496, 449, 448, 497, 449, 
	448, 449, 111, 448, 499, 449, 448, 500, 
	449, 448, 501, 449, 448, 457, 449, 448, 
	503, 449, 448, 504, 449, 448, 505, 449, 
	448, 506, 449, 448, 507, 449, 448, 508, 
	449, 448, 509, 449, 448, 510, 449, 448, 
	511, 449, 448, 512, 449, 448, 513, 449, 
	448, 514, 449, 448, 515, 449, 448, 516, 
	449, 448, 517, 449, 448, 495, 449, 448, 
	519, 449, 448, 520, 449, 448, 521, 449, 
	448, 522, 449, 448, 523, 449, 448, 524, 
	449, 448, 525, 449, 448, 526, 449, 448, 
	527, 449, 448, 528, 449, 448, 529, 449, 
	448, 530, 449, 448, 531, 449, 448, 532, 
	449, 448, 533, 449, 448, 534, 449, 448, 
	449, 535, 448, 536, 449, 448, 537, 449, 
	448, 538, 449, 448, 539, 449, 448, 540, 
	449, 448, 541, 449, 448, 542, 449, 448, 
	543, 449, 448, 544, 449, 448, 545, 449, 
	448, 546, 449, 448, 547, 449, 448, 548, 
	449, 448, 549, 449, 448, 550, 449, 448, 
	497, 449, 448, 552, 449, 448, 553, 449, 
	448, 554, 449, 448, 555, 449, 448, 556, 
	449, 448, 557, 449, 448, 558, 449, 448, 
	559, 449, 448, 560, 449, 448, 561, 449, 
	448, 562, 449, 448, 497, 449, 448, 564, 
	449, 448, 565, 449, 448, 566, 449, 448, 
	567, 449, 448, 568, 449, 448, 457, 449, 
	448, 570, 449, 448, 571, 449, 448, 572, 
	449, 448, 573, 449, 448, 574, 449, 448, 
	575, 449, 448, 576, 449, 448, 577, 449, 
	448, 578, 449, 448, 579, 449, 448, 580, 
	449, 448, 561, 449, 448, 449, 582, 448, 
	449, 583, 448, 449, 584, 448, 449, 585, 
	448, 449, 586, 448, 449, 587, 448, 449, 
	588, 448, 449, 589, 448, 449, 590, 448, 
	449, 591, 448, 449, 592, 448, 449, 593, 
	448, 449, 594, 448, 449, 12, 448, 596, 
	0, 597, 0, 598, 0, 599, 0, 600, 
	0, 9, 0, 602, 0, 603, 0, 604, 
	0, 605, 0, 606, 0, 607, 0, 608, 
	0, 609, 0, 610, 0, 611, 0, 612, 
	0, 613, 0, 614, 0, 615, 0, 616, 
	0, 618, 617, 618, 617, 619, 618, 618, 
	12, 738, 626, 12, 618, 617, 620, 627, 
	633, 667, 671, 687, 720, 732, 618, 617, 
	621, 618, 617, 622, 618, 617, 623, 618, 
	617, 624, 618, 617, 625, 618, 617, 626, 
	618, 617, 618, 111, 617, 628, 618, 617, 
	629, 618, 617, 630, 618, 617, 631, 618, 
	617, 632, 618, 617, 626, 618, 617, 634, 
	649, 618, 617, 635, 618, 617, 636, 618, 
	617, 637, 618, 617, 638, 618, 617, 639, 
	618, 617, 640, 618, 617, 641, 618, 617, 
	642, 618, 617, 643, 618, 617, 644, 618, 
	617, 645, 618, 617, 646, 618, 617, 647, 
	618, 617, 648, 618, 617, 626, 618, 617, 
	650, 618, 617, 651, 618, 617, 652, 618, 
	617, 653, 618, 617, 654, 618, 617, 655, 
	618, 617, 656, 618, 617, 657, 618, 617, 
	658, 618, 617, 659, 618, 617, 660, 618, 
	617, 661, 618, 617, 662, 618, 617, 663, 
	618, 617, 664, 618, 617, 665, 618, 617, 
	666, 618, 617, 618, 111, 617, 668, 618, 
	617, 669, 618, 617, 670, 618, 617, 626, 
	618, 617, 672, 618, 617, 673, 618, 617, 
	674, 618, 617, 675, 618, 617, 676, 618, 
	617, 677, 618, 617, 678, 618, 617, 679, 
	618, 617, 680, 618, 617, 681, 618, 617, 
	682, 618, 617, 683, 618, 617, 684, 618, 
	617, 685, 618, 617, 686, 618, 617, 664, 
	618, 617, 688, 618, 617, 689, 618, 617, 
	690, 618, 617, 691, 618, 617, 692, 618, 
	617, 693, 618, 617, 694, 618, 617, 695, 
	618, 617, 696, 618, 617, 697, 618, 617, 
	698, 618, 617, 699, 618, 617, 700, 618, 
	617, 701, 618, 617, 702, 618, 617, 703, 
	618, 617, 618, 704, 617, 705, 618, 617, 
	706, 618, 617, 707, 618, 617, 708, 618, 
	617, 709, 618, 617, 710, 618, 617, 711, 
	618, 617, 712, 618, 617, 713, 618, 617, 
	714, 618, 617, 715, 618, 617, 716, 618, 
	617, 717, 618, 617, 718, 618, 617, 719, 
	618, 617, 666, 618, 617, 721, 618, 617, 
	722, 618, 617, 723, 618, 617, 724, 618, 
	617, 725, 618, 617, 726, 618, 617, 727, 
	618, 617, 728, 618, 617, 729, 618, 617, 
	730, 618, 617, 731, 618, 617, 666, 618, 
	617, 733, 618, 617, 734, 618, 617, 735, 
	618, 617, 736, 618, 617, 737, 618, 617, 
	626, 618, 617, 618, 739, 617, 618, 740, 
	617, 618, 741, 617, 618, 742, 617, 618, 
	743, 617, 618, 744, 617, 618, 745, 617, 
	618, 746, 617, 618, 747, 617, 618, 748, 
	617, 618, 749, 617, 618, 750, 617, 618, 
	751, 617, 618, 12, 617, 753, 0, 12, 
	0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	29, 0, 54, 0, 5, 1, 0, 29, 
	1, 35, 0, 43, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 149, 126, 57, 110, 
	23, 0, 29, 54, 0, 5, 1, 0, 
	29, 1, 35, 0, 43, 0, 43, 0, 
	43, 139, 48, 9, 106, 11, 0, 134, 
	45, 45, 45, 3, 122, 33, 33, 33, 
	0, 122, 33, 33, 33, 0, 122, 33, 
	0, 33, 0, 102, 7, 7, 43, 54, 
	0, 0, 43, 114, 25, 0, 54, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 43, 43, 43, 43, 
	0, 27, 118, 27, 27, 51, 27, 0, 
	54, 0, 1, 0, 43, 0, 0, 0, 
	43, 54, 37, 37, 87, 37, 37, 43, 
	0, 39, 0, 43, 0, 0, 54, 0, 
	0, 39, 0, 0, 96, 54, 0, 93, 
	90, 41, 96, 90, 99, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 84, 54, 0, 69, 
	33, 69, 0, 0, 0, 0, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 13, 0, 63, 130, 31, 60, 
	57, 31, 63, 57, 66, 31, 43, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 13, 0, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 81, 81, 0, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 21, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 144, 57, 54, 0, 84, 
	54, 0, 78, 33, 84, 78, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 19, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 19, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 19, 0, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0, 43, 0, 43, 144, 57, 
	54, 0, 84, 54, 0, 75, 33, 84, 
	75, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 17, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 17, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 17, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 144, 57, 54, 0, 84, 54, 0, 
	72, 33, 84, 72, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 15, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 15, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 15, 0, 0, 43, 0, 
	43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 754;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "ragel/i18n/el.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  /* Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters */
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1523 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
	{
	cs = lexer_start;
	}

#line 425 "ragel/i18n/el.c.rl"
    
#line 1530 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (unsigned int)(_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += (unsigned int)((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "ragel/i18n/el.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "ragel/i18n/el.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "ragel/i18n/el.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "ragel/i18n/el.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "ragel/i18n/el.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "ragel/i18n/el.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "ragel/i18n/el.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "ragel/i18n/el.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "ragel/i18n/el.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "ragel/i18n/el.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "ragel/i18n/el.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "ragel/i18n/el.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "ragel/i18n/el.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "ragel/i18n/el.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "ragel/i18n/el.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "ragel/i18n/el.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "ragel/i18n/el.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "ragel/i18n/el.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "ragel/i18n/el.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "ragel/i18n/el.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1820 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "ragel/i18n/el.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      /* Allocate as a ruby string so that it gets cleaned up by GC */
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; /* terminate new string at first newline found */
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); /* Re-initialize so we can scan again with the same lexer */
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1883 "ext/gherkin_lexer_el/gherkin_lexer_el.c"
		}
	}
	}

	_out: {}
	}

#line 426 "ragel/i18n/el.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    /* Reset lexer by re-initializing the whole thing */
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_el()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "El", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

