#!/bin/bash
#
# RC sample administration - protect /etc/passwd, /etc/group, /etc/shadow
# ATTENTION: You should grant read rights to PASSWDTYPE for all new roles,
#            otherwise many programs might not work correctly
#            You should grant AUTHROLE SEARCH and CHDIR on all home dirs,
#            otherwise /bin/login cannot chdir to the user's home dir
#            (adjust HOMEAREATYPE to let this script do it for you).
#
# Adjust these lines
COPYORIGINROLE=2
AUTHPROGS="/bin/login /usr/sbin/sshd"
AUTHCHANGEPROGS="/bin/passwd /usr/bin/passwd /sbin/YaST"
HOMEAREATYPE=`rc_get_item list_used_fd_types | grep 'Home_Area' | cut -f 1 -d ' '`

# No more changes below
#
# Redo security check
if test "`attr_get_file_dir FILE /bin/login rc_type_fd`" != "65"
then echo "/bin/login already has a rc_type_fd set, exiting!" ; exit
fi
#
echo ""
PASSWDTYPE=`rc_get_item list_unused_fd_type_nr | head -n 1`
SHADOWTYPE=`rc_get_item list_unused_fd_type_nr | head -n 2 | tail -n 1`
#
AUTHROLE=`rc_get_item list_unused_role_nr | head -n 1`
AUTHCHANGEROLE=`rc_get_item list_unused_role_nr | head -n 2 | tail -n 1`
#
echo ""
GENERALTYPE=0
GENERALUSERROLE=0
ROLEADMINROLE=1
SYSADMINROLE=2
USEDROLES="`rc_get_item list_used_role_nr`"
#
echo ""
echo Create new types $PASSWDTYPE \"Passwd-Type\" and $SHADOWTYPE \"Shadow-Type\"
rc_set_item TYPE $PASSWDTYPE type_fd_name "Passwd-Type"
rc_set_item TYPE $SHADOWTYPE type_fd_name "Shadow-Type"
#
echo ""
echo Create new roles $AUTHROLE \"Auth Role\" and $AUTHCHANGEROLE \"Auth Change\"
echo \(Copy from role $COPYORIGINROLE and set name\)
rc_copy_role $COPYORIGINROLE $AUTHROLE
rc_set_item ROLE $AUTHROLE name "Auth Role"
rc_copy_role $COPYORIGINROLE $AUTHCHANGEROLE
rc_set_item ROLE $AUTHCHANGEROLE name "Auth Change"
rc_set_item ROLE $AUTHCHANGEROLE def_fd_create_type $SHADOWTYPE
#
echo ""
echo Give \"Auth Role\" read rights to \"Passwd Type\" $PASSWDTYPE and
echo \"Shadow Type\" $SHADOWTYPE 
rc_set_item ROLE $AUTHROLE type_comp_fd $PASSWDTYPE R 1
rc_set_item ROLE $AUTHROLE type_comp_fd $SHADOWTYPE R 1
#
echo ""
if test -n $HOMEAREATYPE
then \
  echo Give \"Auth Role\" SEARCH, CHDIR, READ and READ_OPEN rights to \"Home Area\" $HOMEAREATYPE
  for i in SEARCH CHDIR READ READ_OPEN
  do rc_set_item ROLE $AUTHROLE type_comp_fd $HOMEAREATYPE $i 1
  done
else
  echo No \"Home Area\" type found - skipping
fi
#
echo ""
echo Give \"Auth Change\" APPEND_OPEN, CREATE and WRITE right to
echo \"General Type\" $GENERALTYPE to create files in /etc and log errors
for i in APPEND_OPEN CREATE WRITE
  do rc_set_item ROLE $AUTHCHANGEROLE type_comp_fd $GENERALTYPE $i 1
done
#
echo ""
echo Give \"Auth Change\" read and write-open rights to \"Passwd Type\" $PASSWDTYPE
echo and \"Shadow Type\" $SHADOWTYPE 
rc_set_item ROLE $AUTHCHANGEROLE type_comp_fd $PASSWDTYPE RW 1
rc_set_item ROLE $AUTHCHANGEROLE type_comp_fd $SHADOWTYPE RW 1
#
echo ""
echo Give all existing roles \($USEDROLES\)
echo read rights to \"Passwd Type\" $PASSWDTYPE and
echo EXECUTE/SEARCH on  \"Shadow Type\" $SHADOWTYPE
for i in $USEDROLES
do \
  rc_set_item ROLE $i type_comp_fd $PASSWDTYPE R 1
  rc_set_item ROLE $i type_comp_fd $SHADOWTYPE EXECUTE 1
  rc_set_item ROLE $i type_comp_fd $SHADOWTYPE SEARCH 1
done
#
echo ""
echo Give \"Role Admin\" attribute rights on \"Passwd Type\" $PASSWDTYPE and
echo \"Shadow Type\" $SHADOWTYPE
rc_set_item ROLE $ROLEADMINROLE type_comp_fd $PASSWDTYPE SE 1
rc_set_item ROLE $ROLEADMINROLE type_comp_fd $SHADOWTYPE SE 1
#
echo ""
echo Give \"System Admin\" CREATE on  \"Shadow Type\" $SHADOWTYPE
rc_set_item ROLE $SYSADMINROLE type_comp_fd $SHADOWTYPE CREATE 1
#
echo ""
echo Set types for /etc/passwd, /etc/group, /etc/shadow, /etc/.pwd.lock, /etc/shadow-
attr_set_file_dir FILE /etc/passwd rc_type_fd $PASSWDTYPE
attr_set_file_dir FILE /etc/group rc_type_fd $PASSWDTYPE
attr_set_file_dir FILE /etc/shadow rc_type_fd $SHADOWTYPE
attr_set_file_dir FILE /etc/shadow- rc_type_fd $SHADOWTYPE
attr_set_file_dir FILE /etc/.pwd.lock rc_type_fd $SHADOWTYPE
#
echo ""
echo Set all authorising programs \($AUTHPROGS\) to type $PASSWDTYPE
for i in $AUTHPROGS
do \
  attr_set_file_dir FILE $i rc_type_fd $PASSWDTYPE
done
#
echo ""
echo Give all authorising programs \($AUTHPROGS\) rc_force_role $AUTHROLE
for i in $AUTHPROGS
do \
  attr_set_file_dir FILE $i rc_force_role $AUTHROLE
done
#
echo ""
echo Set all authorisation changing programs \($AUTHCHANGEPROGS\) to type $SHADOWTYPE
for i in $AUTHCHANGEPROGS
do \
  attr_set_file_dir FILE $i rc_type_fd $SHADOWTYPE
done
#
echo ""
echo Give all authorisation changing programs \($AUTHCHANGEPROGS\)
echo rc_force_role $AUTHCHANGEROLE
for i in $AUTHCHANGEPROGS
do \
  attr_set_file_dir FILE $i rc_force_role $AUTHCHANGEROLE
done
#
echo ""
echo Give /bin/sh rc_force_role inherit_process '(65)' to make yast work
attr_set_file_dir FILE /bin/sh rc_force_role 65
#
echo ""
echo Ready!
