#### Python package 'rviz' initialization.
#
# The actual implementations are defined in C++ and wrapped by
# shiboken or sip.  This wrapper finds which binding is available and
# presents it as package rviz.

import sys
import roslib; roslib.load_manifest('rviz')

# Can use the following setattr() call to force one binding or the other.
# setattr(sys, 'SELECT_QT_BINDING', 'pyside')

from python_qt_binding import QT_BINDING

if QT_BINDING == 'pyside':

    # Import the shared library generated by the shiboken binding-generator.
    # This depends on rviz/manifest.xml listing ${prefix}/lib in the python path.
    import librviz_shiboken

    # Expose the contained rviz namespace directly
    sys.modules['rviz'] = librviz_shiboken.rviz

elif QT_BINDING == 'pyqt':

    # Import the shared library generated by the sip binding-generator.
    # This depends on rviz/manifest.xml listing ${prefix}/lib in the python path.
    import librviz_sip

    # Expose the contained rviz namespace directly
    sys.modules['rviz'] = librviz_sip.rviz

else:
    raise ImportError('Qt binding name "%s" is unknown.' % QT_BINDING)
