//helloworld.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2012-2014
 *
 *  This file is part of roard a part of RoarAudio,
 *  a cross-platform sound system for both, home and professional use.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  as published by the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include <roaraudio.h>

// A simple function printing our message.
static int hw_init (struct roar_dl_librarypara * para) {
 const char * text = "Hello world!";
 struct roar_keyval * cur;
 size_t i;

 if ( para != NULL && para->argv != NULL ) {
  for (i = 0; i < para->argc; i++) {
   cur = &(para->argv[i]);
   if ( cur->key != NULL && !strcmp(cur->key, "text") ) {
    if ( cur->value != NULL ) {
     text = cur->value;
    } else if ( (i+1) < para->argc && para->argv[i+1].key == NULL ) {
     text = para->argv[i+1].value;
     i++;
    }
   }
  }
 }

 roar_vio_printf(roar_stdout, "%s\n", text);

 return 0;
}

// This struct contains the AppSched pointers.
static struct roar_dl_appsched sched = {
 .init   = hw_init,
 .free   = NULL,
 .update = NULL,
 .tick   = NULL,
 .wait   = NULL
};

// This is the plugin control block.
ROAR_DL_PLUGIN_START(helloworld) {
 // Here we set the name and vendor of our plugin.
 // If you have no Vendor ID you need to use ROAR_DL_PLUGIN_META_PRODUCT_NV().
 ROAR_DL_PLUGIN_META_PRODUCT_NIV("helloworld", ROAR_VID_ROARAUDIO, ROAR_VNAME_ROARAUDIO);

 // This sets the version of your plugin.
 ROAR_DL_PLUGIN_META_VERSION(ROAR_VERSION_STRING);

 // This sets the license of your plugin.
 // If there is no tag for the license you use you can just
 // use ROAR_DL_PLUGIN_META_LICENSE().
 ROAR_DL_PLUGIN_META_LICENSE_TAG(GPLv3_0);

 // This sets the author and contact infos.
 // There are several other macros to do this with other parameters.
 // See ROAR_DL_PLUGIN_META_CONTACT*() in the header or documentation.
 ROAR_DL_PLUGIN_META_CONTACT_FLNE("Philipp", "Schafft", "ph3-der-loewe", "lion@lion.leolix.org");

 // This sets the description for your plugin.
 ROAR_DL_PLUGIN_META_DESC("This plugin prints the string \"Hello world!\".");

 // Here the AppSched block from above is registered.
 ROAR_DL_PLUGIN_REG_APPSCHED(&sched);

// This is the end of the control block.
} ROAR_DL_PLUGIN_END

//ll
