#include "rheolef.h"
#include "rheolef/uzawa_abtb.h"
using namespace rheolef;
using namespace std;

Float g(const point& x) { return 1-x[0]*x[0]; }

int main(int argc, char**argv) {
  geo  omega (argv[1]);
  cerr << "mesh " << omega.name () << endl
       << "coordinate system " << omega.coordinate_system() << endl;
 
  space Xh (omega, "P2", "vector");
  space Qh (omega, "P1");
  space Th (omega, "P1d", "tensor");
  Xh[0].block("left"); Xh.block("right");
  Xh.block("bottom");  Xh[0].block("top");
  field uh (Xh);
  field ph (Qh, 0.);
  uh["right"] = 0;
  space W_bottom (omega, omega["bottom"], "P2");
  space W_top    (omega, omega["top"],    "P2");
  uh[1]["bottom"] = interpolate (W_bottom,  g);
  uh[0]["left"] = uh[0]["bottom"] = uh[0]["top"] = 0;
  form a (Xh, Xh, "2D_D");
  form b (Xh, Qh, "div"); b = -b;
  int   max_iter  = 50;
  Float tol       = 1e-12;
  Float r         = 1e+7;
  form ar = a + r*trans(b)*b;
  ssk<Float> fact = ldlt(ar.uu);
  uzawa_abtb (ar.uu, fact, b.uu, uh.u, ph.u, -(ar.ub*uh.b), -(b.ub*uh.b), r, max_iter, tol);

  cout << catchmark("u")  << uh
       << catchmark("p")  << ph;
 
  field pi_h_u (Xh, 0.);
  pi_h_u[1] = interpolate (space(Xh[1]), g);
  Float err = abs (uh-pi_h_u).max();
  cerr << "error = " << err << endl;
  Float tol2 = 1e-7;
  return err < tol2 ? 0 : 1;
}
