set terminal pslatex color auxfile
set output "p-laplacian-square-r2.tex"

set logscale y
set size square 0.7
set xtics (0,500)
set ytics (\
        "[r]{$10^{-15}$}" 1e-15, \
        "[r]{$10^{-10}$}" 1e-10, \
        "[r]{$10^{-5}$}" 1e-5, \
        "[r]{$10^{0}$}" 1 )
set xlabel "[c]{$n$}"
set  label "[r]{\\Large $\\|r_h\\|_{-1,h}$}" at graph -0.05,0.5

plot [0:500][1e-15:1] \
  "p-laplacian-square-p=1.1.gdat" title "[r]{$p=1.10$}" w l, \
  "p-laplacian-square-p=1.2.gdat" title "[r]{$p=1.20$}" w l, \
  "p-laplacian-square-p=1.5.gdat" title "[r]{$p=1.50$}" w l

#pause -1 "<retour>"

