#include "rheolef.h"
using namespace rheolef;
using namespace std;
#include "harten.icc"
int main(int argc, char**argv) {
  environment rheolef (argc, argv);
  geo omega (argv[1]);
  space Xh (omega, argv[2]);
  size_t nmax = (argc > 3) ? atoi(argv[3]) : 1000;
  Float tf    = (argc > 4) ? atof(argv[4]) : 2.5;
  Float a     = (argc > 5) ? atof(argv[5]) : 1;
  Float b     = (argc > 6) ? atof(argv[6]) : 0.5;
  Float c     = (argc > 7) ? atof(argv[7]) : 0;
  branch even("t","u");
  for (size_t n = 0; n <= nmax; ++n) {
    Float t = n*tf/nmax;
    field pi_h_u = interpolate (Xh, harten(t,a,b,c));
    dout << even(t,pi_h_u);
  }
}
