# Announce: Rakudo Perl 6 compiler, Release #124 (2018.06)

On behalf of the Rakudo development team, I’m very happy to announce the
June 2018 release of Rakudo Perl 6 #124. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2018 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <https://rakudo.org/files/rakudo>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<https://rakudo.org/files/star>.

The changes in this release are outlined below:

New in 2018.06:
  + Fixes:
    + Fixed numeric values in Signal enum [aa622a95][852c1bd3][f2b50378]
        [774ec5a0][189c5a8a][b19cc4bd][c661c03c][5603771f][bfcfa5da]
        [7e5a862e][cd8d0445]
    + Fixed long class names being cut off in X::TypeCheck message [a79de429]
    + Many improvements to POD parsing [75430ac9][cb66dfcc][6f1b1cb6]
        [e1e7e4c6][cc28ce37][e776ded7][54aa17c6]
    + Fixed code execution in elided duplicate argument pair values
        [fc57f9f0][73297600]
    + Fixed `use isms <Perl5>` for `rand` [d1d31fd5]
    + Fixed miscompilation of chain ops [c10b1eec]
    + Fixed home path when setting up repositories [91b211ac][d06e70c3]
    + [JVM] Implemented canStore in RakudoContainerSpec [704b893c]
  + Additions:
    + Made `is DEPRECATED` work on attributes with auto-generated
        accessors [7e3aa2f2]
    + Added `:api<something>` in preparation for full zef / ecosystem
        support [affc218f]
    + Added .perl method to Distributions [18f9de61]
  + Removals:
    + Removed backwards compatibility with installers using the
        old Distribution class [2acbe7fc]
    + Moved pack/unpack support to lib/experimental.pm6 [9472fdfd][edc6ac6b]
    + Renamed `use p5isms` to more general `use isms <Perl5>` [4109ce36]
        [c80ea2f2][56dbd735][148d7c56][95aa77c9]
  + Efficiency:
    + Streamlined creation of HyperWorkBatchIterator [20bf96f9]
    + Made .minpairs/.maxpairs about 25% faster [788cda94]
    + Privatized a lot of methods for (now) better performance
        [c940a0ed][ec5e51c8][7284a30f][c49bbc93][0ac5c4ff][09a9bbc0]
        [caafcb38][0c265d49][48864774][0e835805][5621b262]
    + Added spesh plugin support [192083f6]
    + Made private method calls 6.6x faster (spesh plugin) [51ff83c7]
    + Made qualified method calls 12x faster (spesh plugin) [f6f43d58]
  + Internal:
    + Moved &DEPRECATED to Rakudo::Deprecations.DEPRECATED [472f6e48]
        [89a4cf0d][afbbf8f8][2fa08d5e][874ead51]
    + Turned Hash.BIND-KEY into multis [1c1acbc2]
    + Various NQP ↔ Perl 6 fixes [e4ecf5e5][23af3491][7bc6e46f][cbb5ee5f]


The following people contributed to this release:

Elizabeth Mattijsen, Will "Coke" Coleda, Jonathan Worthington,
Aleks-Daniel Jakimenko-Aleksejev, Zoffix Znet, Jeremy Studer,
Rafael Schipiura, 陈梓立, Tom Browder, Samantha McVey, Christian Bartolomäus,
Juan Julián Merelo Guervós, Stefan Seifert, Christian Sánchez, Daniel Green,
Ben Davies, Nick Logan, Luca Ferrari, Claudio Ramirez, Paweł Murias,
Bruce Gray, Tison, Ronald Schmidt, Timo Paulssen, Rob Hoelz, Luis F. Uceta,
dmaestro, Jonas Kramer, Moritz Lenz, Jan-Olof Hendig, KlappeZuAffeTot,
Jack Kuan, Brad Gilbert, İsmail Arılık

as well as Bart Wiegmans

If you would like to contribute or find out more information, visit
<https://perl6.org>, <https://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#125), is tentatively scheduled for 2018-07-21.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
