#define _GNU_SOURCE
#include <grp.h>
#include <stdio.h>
#include <string.h>
#define BUFLEN 4096

int main() {
     struct group gr, *grp;
     char buf[BUFLEN];
     int i, cnt;

     cnt = 0;

     setgrent();
     while (1) {
           i = getgrent_r(&gr, buf, BUFLEN, &grp);
           if (i) {
                 printf("status: %d\n", i);
                 break;
           }
           int num_members = 0;
           char** mem_ptr = grp->gr_mem;
           while (mem_ptr && *mem_ptr) {num_members++; mem_ptr++;}
           printf("\ncnt %d: name %s gid (%d) : num_members %d\n", cnt, grp->gr_name, grp->gr_gid, num_members);
           for (i = 0; i < num_members; i++)
             printf("%s ", grp->gr_mem[i]);
           if (num_members) printf("\n");
           cnt++;
     }
     endgrent();
     return 0;
}

