% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_ranks.R
\name{wm_ranks}
\alias{wm_ranks}
\alias{wm_ranks_id}
\alias{wm_ranks_name}
\title{Get taxonomic ranks by their identifier}
\usage{
wm_ranks_id(rank_id, id = NULL, offset = 1, ...)

wm_ranks_name(rank_name, id = NULL, offset = 1, ...)
}
\arguments{
\item{rank_id}{(numeric/integer) a rank identifier. length==1}

\item{id}{an AphiaID. length==1}

\item{offset}{(integer) record to start at. default: 1}

\item{...}{named curl options. see \code{curl::curl_options}}

\item{rank_name}{(character) a rank name. length==1}
}
\value{
A tibble/data.frame
}
\description{
Get taxonomic ranks by their identifier
}
\examples{
\dontrun{
wm_ranks_id(220)
wm_ranks_id(180)
wm_ranks_id(180, id = 4)

wm_ranks_name("genus")
wm_ranks_name("genus", id = 4)
}
}
