% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{wk_set_z}
\alias{wk_set_z}
\alias{wk_set_m}
\alias{wk_drop_z}
\alias{wk_drop_m}
\alias{wk_trans_set}
\title{Set coordinate values}
\usage{
wk_set_z(handleable, z, ...)

wk_set_m(handleable, m, ...)

wk_drop_z(handleable, ...)

wk_drop_m(handleable, ...)

wk_trans_set(value, use_z = NA, use_m = NA)
}
\arguments{
\item{handleable}{A geometry vector (e.g., \code{\link[=wkb]{wkb()}}, \code{\link[=wkt]{wkt()}}, \code{\link[=xy]{xy()}},
\code{\link[=rct]{rct()}}, or \code{\link[sf:sfc]{sf::st_sfc()}}) for which \code{\link[=wk_handle]{wk_handle()}} is defined.}

\item{z, m}{A vector of Z or M values applied feature-wise and recycled
along \code{handleable}. Use \code{NA} to keep the existing value of a given
feature.}

\item{...}{Passed to the \code{\link[=wk_handle]{wk_handle()}} method.}

\item{value}{An \code{\link[=xy]{xy()}}, \code{\link[=xyz]{xyz()}}, \code{\link[=xym]{xym()}}, or \code{\link[=xyzm]{xyzm()}} of coordinates
used to replace values in the input. Use \code{NA} to keep the existing
value.}

\item{use_z, use_m}{Used to declare the output type. Use \code{TRUE} to
ensure the output has that dimension, \code{FALSE} to ensure it does not,
and \code{NA} to leave the dimension unchanged.}
}
\description{
Set coordinate values
}
\examples{
wk_set_z(wkt("POINT (0 1)"), 2)
wk_set_m(wkt("POINT (0 1)"), 2)
wk_drop_z(wkt("POINT ZM (0 1 2 3)"))
wk_drop_m(wkt("POINT ZM (0 1 2 3)"))

}
