% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-ordinal.R
\name{label_ordinal}
\alias{label_ordinal}
\alias{ordinal_english}
\alias{ordinal_french}
\alias{ordinal_spanish}
\title{Label ordinal numbers (1st, 2nd, 3rd, etc)}
\usage{
label_ordinal(
  prefix = "",
  suffix = "",
  big.mark = " ",
  rules = ordinal_english(),
  ...
)

ordinal_english()

ordinal_french(gender = c("masculin", "feminin"), plural = FALSE)

ordinal_spanish()
}
\arguments{
\item{prefix, suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{rules}{Named list of regular expressions, matched in order.
Name gives suffix, and value specifies which numbers to match.}

\item{...}{
  Arguments passed on to \code{\link[=number]{number}}
  \describe{
    \item{\code{accuracy}}{A number to round to. Use (e.g.) \code{0.01} to show 2 decimal
places of precision. If \code{NULL}, the default, uses a heuristic that should
ensure breaks have the minimum number of digits needed to show the
difference between adjacent values.

Applied to rescaled data.}
    \item{\code{scale}}{A scaling factor: \code{x} will be multiplied by \code{scale} before
formatting. This is useful if the underlying data is very small or very
large.}
    \item{\code{decimal.mark}}{The character to be used to indicate the numeric
decimal point.}
    \item{\code{style_positive}}{A string that determines the style of positive numbers:
\itemize{
\item \code{"none"} (the default): no change, e.g. \code{1}.
\item \code{"plus"}: preceded by \code{+}, e.g. \code{+1}.
\item \code{"space"}: preceded by a Unicode "figure space", i.e., a space equally
as wide as a number or \code{+}. Compared to \code{"none"}, adding a figure space
can ensure numbers remain properly aligned when they are left- or
right-justified.
}}
    \item{\code{style_negative}}{A string that determines the style of negative numbers:
\itemize{
\item \code{"hyphen"} (the default): preceded by a standard hypen \code{-}, e.g. \code{-1}.
\item \code{"minus"}, uses a proper Unicode minus symbol. This is a typographical
nicety that ensures \code{-} aligns with the horizontal bar of the
the horizontal bar of \code{+}.
\item \code{"parens"}, wrapped in parentheses, e.g. \code{(1)}.
}}
    \item{\code{scale_cut}}{Named numeric vector that allows you to rescale large
(or small) numbers and add a prefix. Built-in helpers include:
\itemize{
\item \code{cut_short_scale()}: [10^3, 10^6) = K, [10^6, 10^9) = M, [10^9, 10^12) = B, [10^12, Inf) = T.
\item \code{cut_long_scale()}: [10^3, 10^6) = K, [10^6, 10^12) = M, [10^12, 10^18) = B, [10^18, Inf) = T.
\item \code{cut_si(unit)}: uses standard SI units.
}

If you supply a vector \code{c(a = 100, b = 1000)}, absolute values in the
range \verb{[0, 100)} will not be rescaled, absolute values in the range \verb{[100, 1000)}
will be divided by 100 and given the suffix "a", and absolute values in
the range \verb{[1000, Inf)} will be divided by 1000 and given the suffix "b".
If the division creates an irrational value (or one with many digits), the
cut value below will be tried to see if it improves the look of the final
label.}
    \item{\code{trim}}{Logical, if \code{FALSE}, values are right-justified to a common
width (see \code{\link[base:format]{base::format()}}).}
  }}

\item{gender}{Masculin or feminin gender for French ordinal.}

\item{plural}{Plural or singular for French ordinal.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
Round values to integers and then display as ordinal values (e.g. 1st, 2nd,
3rd). Built-in rules are provided for English, French, and Spanish.
}
\examples{
demo_continuous(c(1, 5))
demo_continuous(c(1, 5), labels = label_ordinal())
demo_continuous(c(1, 5), labels = label_ordinal(rules = ordinal_french()))

# The rules are just a set of regular expressions that are applied in turn
ordinal_french()
ordinal_english()

# Note that ordinal rounds values, so you may need to adjust the breaks too
demo_continuous(c(1, 10))
demo_continuous(c(1, 10), labels = label_ordinal())
demo_continuous(c(1, 10),
  labels = label_ordinal(),
  breaks = breaks_width(2)
)
}
\seealso{
Other labels for continuous scales: 
\code{\link{label_bytes}()},
\code{\link{label_currency}()},
\code{\link{label_number_auto}()},
\code{\link{label_number_si}()},
\code{\link{label_parse}()},
\code{\link{label_percent}()},
\code{\link{label_pvalue}()},
\code{\link{label_scientific}()}
}
\concept{labels for continuous scales}
