% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/formatter.r
\name{unit_format}
\alias{unit_format}
\title{Add units to the labels}
\usage{
unit_format(unit = "m", scale = 1, sep = " ", ...)
}
\arguments{
\item{unit}{The units to append}

\item{scale}{A scaling factor. Useful if the underlying data is on another scale}

\item{sep}{The separator between the number and the label}

\item{...}{Arguments passed on to \code{\link{format}}}
}
\description{
Add units to the labels
}
\examples{
# labels in kilometer when the raw data are in meter
km <- unit_format(unit = "km", scale = 1e-3, digits = 2)
km(runif(10) * 1e3)

# labels in hectares, raw data in square meters
ha <- unit_format(unit = "ha", scale = 1e-4)
km(runif(10) * 1e5)
}
\seealso{
\code{\link{comma}}
}

