% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sass_cache.R
\name{sass_cache_get_dir}
\alias{sass_cache_get_dir}
\alias{sass_cache_set_dir}
\title{Get and set the cache object registered for a specific directory}
\usage{
sass_cache_get_dir(dir, create = FALSE)

sass_cache_set_dir(dir, cache)
}
\arguments{
\item{dir}{A directory. An error will be thrown if the directory does not
exist.}

\item{create}{If \code{TRUE}, then if the cache directory doesn't exist, or if
there is not a registered cache object for the directory, create them as
needed.}

\item{cache}{A \code{\link[=sass_file_cache]{sass_file_cache()}} object, or \code{NULL} if you don't want to
unset the cache for a directory.}
}
\description{
Get and set the cache object registered for a specific directory
}
\details{
If \code{sass_cache_get_dir()} is called for a given directory, before
\code{sass_cache_set_dir()} has been called for that directory, then it will
return \code{NULL}.

After \code{sass_cache_set_dir()} is called for a directory, any future calls to
\code{sass_cache_get_dir()} with that directory will return that specific cache
object. This can be useful if you customize parameters for the cache object,
like maximum size or age.
}
\seealso{
\code{\link[=sass_cache_get]{sass_cache_get()}}, \code{\link[=sass_file_cache]{sass_file_cache()}}, \code{\link[=sass]{sass()}}
}
\keyword{internal}
