% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/read_excel.R
\name{read_excel}
\alias{read_excel}
\title{Read xls and xlsx files.}
\usage{
read_excel(path, sheet = 1, col_names = TRUE, col_types = NULL, na = "",
  skip = 0)
}
\arguments{
\item{path}{Path to the xls/xlsx file}

\item{sheet}{Sheet to read. Either a string (the name of a sheet), or
an integer (the position of the sheet). Defaults to the first sheet.}

\item{col_names}{Either \code{TRUE} to use the first row as column names,
\code{FALSE} to number columns sequentially from \code{X1} to \code{Xn},
or a character vector giving a name for each column.}

\item{col_types}{Either \code{NULL} to guess from the spreadsheet or a
character vector containing "blank", "numeric", "date" or "text".}

\item{na}{Missing value. By default readxl converts blank cells to missing
data. Set this value if you have used a sentinel value for missing values.}

\item{skip}{Number of rows to skip before reading any data.}
}
\description{
Read xls and xlsx files.
}
\examples{
datasets <- system.file("extdata/datasets.xlsx", package = "readxl")
read_excel(datasets)

# Specific sheet either by position or by name
read_excel(datasets, 2)
read_excel(datasets, "mtcars")
}

