% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system.R
\name{ps_loadavg}
\alias{ps_loadavg}
\title{Return the average system load over the last 1, 5 and 15 minutes as a
tuple. The “load” represents the processes which are in a runnable
state, either using the CPU or waiting to use the CPU (e.g. waiting for
disk I/O). On Windows this is emulated by using a Windows API that
spawns a thread which keeps running in background and updates results
every 5 seconds, mimicking the UNIX behavior. Thus, on Windows, the
first time this is called and for the next 5 seconds it will return a
meaningless (0.0, 0.0, 0.0) vector. The numbers returned only make sense
if related to the number of CPU cores installed on the system. So, for
instance, a value of 3.14 on a system with 10 logical CPUs means that
the system load was 31.4\% percent over the last N minutes.}
\usage{
ps_loadavg()
}
\value{
Numeric vector of length 3.
}
\description{
Return the average system load over the last 1, 5 and 15 minutes as a
tuple. The “load” represents the processes which are in a runnable
state, either using the CPU or waiting to use the CPU (e.g. waiting for
disk I/O). On Windows this is emulated by using a Windows API that
spawns a thread which keeps running in background and updates results
every 5 seconds, mimicking the UNIX behavior. Thus, on Windows, the
first time this is called and for the next 5 seconds it will return a
meaningless (0.0, 0.0, 0.0) vector. The numbers returned only make sense
if related to the number of CPU cores installed on the system. So, for
instance, a value of 3.14 on a system with 10 logical CPUs means that
the system load was 31.4\% percent over the last N minutes.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ps_loadavg()
\dontshow{\}) # examplesIf}
}
