% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.phyDat.R
\name{read.phyDat}
\alias{read.phyDat}
\alias{write.phyDat}
\title{Import and export sequence alignments}
\usage{
read.phyDat(file, format = "phylip", type = "DNA", ...)

write.phyDat(x, file, format = "phylip", colsep = "", nbcol = -1, ...)
}
\arguments{
\item{file}{a file name specified by either a variable of mode character, or
a double-quoted string.}

\item{format}{File format of the sequence alignment (see details).  Several
popular formats are supported: "phylip", "interleaved", "sequential",
"clustal", "fasta" or "nexus", or any unambiguous abbreviation of these.}

\item{type}{Type of sequences ("DNA", "AA", "CODON" or "USER").}

\item{...}{further arguments passed to or from other methods.}

\item{x}{An object of class \code{phyDat}.}

\item{colsep}{a character used to separate the columns (a single space by
default).}

\item{nbcol}{a numeric specifying the number of columns per row (-1 by
default); may be negative implying that the nucleotides are printed on a
single line.}
}
\value{
\code{read.phyDat} returns an object of class phyDat,
\code{write.phyDat} write an alignment to a file.
}
\description{
These functions read and write sequence alignments.
}
\details{
\code{write.phyDat} calls the function \code{\link[ape]{write.dna}} or
\code{\link[ape]{write.nexus.data}} and \code{read.phyDat} calls the function
\code{\link[ape]{read.dna}}, \code{read.aa} or \code{read.nexus.data}, so see
for more details over there.

You may import data directly with \code{\link[ape]{read.dna}} or
\code{\link[ape]{read.nexus.data}} and convert the data to class phyDat.
}
\examples{
fdir <- system.file("extdata/trees", package = "phangorn")
primates <- read.phyDat(file.path(fdir, "primates.dna"),
                        format = "interleaved")
}
\references{
% Anonymous. FASTA format description. %
\url{https://www.ncbi.nlm.nih.gov/blast/fasta.shtml} Felsenstein, J. (1993)
Phylip (Phylogeny Inference Package) version 3.5c. Department of Genetics,
University of Washington.
\url{https://evolution.genetics.washington.edu/phylip/phylip.html}
}
\seealso{
\code{\link[ape]{read.dna}}, \code{\link[ape]{read.GenBank}},
\code{\link[phangorn]{phyDat}}, \code{\link[seqinr]{read.alignment}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{IO}
