% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-conversion.R
\name{knit2pandoc}
\alias{knit2pandoc}
\title{Convert various input files to various output files using \code{knit()} and
Pandoc}
\usage{
knit2pandoc(input, output = NULL, tangle = FALSE, text = NULL, quiet = FALSE, 
    envir = parent.frame(), encoding = getOption("encoding"), to = "html", 
    pandoc_wrapper = NULL, ...)
}
\arguments{
\item{input}{path of the input file}

\item{output}{path of the output file for \code{knit()}; if \code{NULL}, this
function will try to guess and it will be under the current working
directory}

\item{tangle}{whether to tangle the R code from the input file (like
\code{\link[utils]{Stangle}})}

\item{text}{a character vector as an alternative way to provide the input
file}

\item{quiet}{whether to suppress the progress bar and messages}

\item{envir}{the environment in which the code chunks are to be evaluated
(for example, \code{\link{parent.frame}()}, \code{\link{new.env}()}, or
\code{\link{globalenv}()})}

\item{encoding}{the encoding of the input file; see \code{\link{file}}}

\item{to}{a character string describing the Pandoc output format to use}

\item{pandoc_wrapper}{an R function used to call Pandoc; by default, if
\pkg{rmarkdown} installed uses
\code{rmarkdown::\link[rmarkdown]{pandoc_convert}()} else
\code{\link{pandoc}()}.}

\item{...}{options to be passed to the \code{pandoc_wrapper} function}
}
\value{
Returns the output of the \code{pandoc_wrapper} function.
}
\description{
Knits the input file and compiles to an output format using Pandoc.
}
\author{
Trevor L. Davis
}
