% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haven.R
\name{read_dta}
\alias{read_dta}
\alias{read_stata}
\alias{write_dta}
\title{Read and write Stata DTA files.}
\usage{
read_dta(file, encoding = NULL)

read_stata(file, encoding = NULL)

write_dta(data, path, version = 14)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path).}

\item{encoding}{The character encoding used for the file. This defaults to
the encoding specified in the file, or UTF-8. But older versions of Stata
(13 and earlier) did not store the encoding used, and you'll need to
specify manually. A commonly used value is "windows-1252".}

\item{data}{Data frame to write.}

\item{path}{Path to a file where the data will be written.}

\item{version}{File version to use. Supports versions 8-14.}
}
\value{
A tibble, data frame variant with nice defaults.

  Variable labels are stored in the "label" attribute of each variable.
  It is not printed on the console, but the RStudio viewer will show it.
}
\description{
Currently haven can read and write logical, integer, numeric, character
and factors. See \code{\link{labelled}} for how labelled variables in
Stata are handled in R.
}
\examples{
path <- system.file("examples", "iris.dta", package = "haven")
read_dta(path)

tmp <- tempfile(fileext = ".dta")
write_dta(mtcars, tmp)
read_dta(tmp)
read_stata(tmp)
}
