#include <gsl/gsl_sf_gegenbauer.h>
#include <gsl/gsl_errno.h>

/* function names generated by removing  "gsl_sf" from the beginning
   of the name.  Thus gsl_sf_gegenpoly_1_e goes to gegenpoly_1_e. */

void gegenpoly_1_e(double *lambda, double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_gegenpoly_1_e(lambda[i], x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}
  
void gegenpoly_2_e(double *lambda, double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_gegenpoly_2_e(lambda[i], x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void gegenpoly_3_e(double *lambda, double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_gegenpoly_3_e(lambda[i], x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void gegenpoly_n_e(int *n, double *lambda, double *x, int *len, double *val, double *err, int *status)
{
	int i;
	gsl_sf_result result;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_gegenpoly_n_e(*n, lambda[i], x[i], &result) ;
		val[i] = result.val;
		err[i] = result.err;
	}
}  

void gegenpoly_array(int *nmax, double *lambda, double *x, int *len, double *out, int *status)
{
	int i;
	gsl_set_error_handler_off();
  
	for(i = 0; i< *len ; i++){
		status[i] = gsl_sf_gegenpoly_array(*nmax, lambda[i], x[i], out+i*(*nmax+1) ) ;
	}
}  
