% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bundle_r_package.r
\docType{methods}
\name{bundle_r_package}
\alias{bundle_r_package}
\alias{bundle_r_package,git_repository-method}
\title{Bundle bare repo of package}
\usage{
bundle_r_package(repo)

\S4method{bundle_r_package}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository with package to bundle.}
}
\value{
Invisible bundled S4 \code{\linkS4class{git_repository}}
object
}
\description{
Clone the package git repository as a bare repository to
\code{pkg/inst/pkg.git}
}
\examples{
\dontrun{
## Initialize repository
path <- tempfile()
dir.create(path)
path <- file.path(path, "git2r")
repo <- clone("https://github.com/ropensci/git2r.git", path)

## Bundle bare repository in package
bundle_r_package(repo)

## Build and install bundled package
wd <- setwd(dirname(path))
system(sprintf("R CMD build \%s", path))
pkg <- list.files(".", pattern = "[.]tar[.]gz$")
system(sprintf("R CMD INSTALL \%s", pkg))
setwd(wd)

## Reload package
detach("package:git2r", unload = TRUE)
library(git2r)

## Summarize last five commits of bundled repo
repo <- repository(system.file("git2r.git", package = "git2r"))
invisible(lapply(commits(repo, n = 5), summary))

## Plot content of bundled repo
plot(repo)
}
}
\keyword{methods}
