% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-textbox.R
\name{geom_textbox}
\alias{geom_textbox}
\title{Draw boxes containing text}
\usage{
geom_textbox(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  nudge_x = 0,
  nudge_y = 0,
  box.padding = unit(c(5.5, 5.5, 5.5, 5.5), "pt"),
  box.margin = unit(c(0, 0, 0, 0), "pt"),
  box.r = unit(5.5, "pt"),
  width = unit(2, "inch"),
  minwidth = NULL,
  maxwidth = NULL,
  height = NULL,
  minheight = NULL,
  maxheight = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function. Cannot be jointy specified with
\code{nudge_x} or \code{nudge_y}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustment to nudge text boxes by.
Useful for offsetting text from points, particularly on discrete scales.
Cannot be jointly specified with \code{position}.}

\item{box.padding}{Unit vector of length four specifying the padding
inside the text box.}

\item{box.margin}{Unit vector of length four specifying the margin
outside the text box.}

\item{box.r}{Unit vector of length one specifying the radius of the
box.}

\item{width, height}{Unit values specifying the width and height of
the text box (including margins!). If \code{height = NULL} (the default),
the height is chosen automatically to accommodate all the text.}

\item{minwidth, maxwidth, minheight, maxheight}{Unit values specifying
the minimum and maximum values for \code{width} and \code{height}, respectively.
If set to \code{NULL}, are not enforced.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggplot2 layer that can be added to a plot created with
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Draw boxes of defined width and height containing word-wrapped text. Multiple
boxes can be drawn at once. Most styling parameters can be used as aesthetics
and can be applied separately to each text box drawn. The exception is styling
parameters that are specified as grid units (e.g., \code{box.padding} or \code{box.r}),
which can only be specified for all text boxes at once. See examples for details.
}
\section{Aesthetics}{


\code{geom_textbox()} understands the following aesthetics (required
aesthetics are in bold; select aesthetics are annotated):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \strong{\code{label}}
\item \code{alpha}
\item \code{box.colour} Color of box outline. Overrides \code{colour}.
\item \code{box.size} Width of box outline.
\item \code{colour} Default color of box text and box outline.
\item \code{family}
\item \code{fontface}
\item \code{fill} Default fill color of box background.
\item \code{group}
\item \code{halign} Horizontal alignment of text inside box.
\item \code{hjust} Horizontal alignment of box.
\item \code{lineheight}
\item \code{orientation} One of \code{"upright"}, \code{"left-rotated"},
\code{"right-rotated"}, \code{"inverted"}.
\item \code{size} Default font size of box text.
\item \code{text.colour} Color of box text. Overrides \code{colour}.
\item \code{valign} Vertical alignment of text inside box.
\item \code{vjust} Vertical alignment of box.
}
}

\examples{
library(ggplot2)

df <- data.frame(
  label = rep("Lorem ipsum dolor **sit amet,** consectetur adipiscing elit,
    sed do *eiusmod tempor incididunt* ut labore et dolore magna
    aliqua.", 2),
  x = c(0, .6),
  y = c(1, .6),
  hjust = c(0, 0),
  vjust = c(1, 0),
  orientation = c("upright", "right-rotated"),
  color = c("black", "blue"),
  fill = c("cornsilk", "white")
)

ggplot(df) +
  aes(
    x, y, label = label, color = color, fill = fill,
    hjust = hjust, vjust = vjust,
    orientation = orientation
  ) +
  geom_textbox(width = unit(0.4, "npc")) +
  geom_point(color = "black", size = 2) +
  scale_discrete_identity(aesthetics = c("color", "fill", "orientation")) +
  xlim(0, 1) + ylim(0, 1)
}
\seealso{
\code{\link[=geom_richtext]{geom_richtext()}}, \code{\link[=element_textbox]{element_textbox()}}
}
