% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend_api-11.ClusterFutureBackend-class.R,
%   R/backend_api-11.MulticoreFutureBackend-class.R, R/core_api-resolved.R
\name{resolved.ClusterFuture}
\alias{resolved.ClusterFuture}
\alias{resolved.MulticoreFuture}
\alias{resolved}
\alias{resolved.default}
\alias{resolved.list}
\alias{resolved.environment}
\alias{resolved.Future}
\title{Check whether a future is resolved or not}
\usage{
\method{resolved}{ClusterFuture}(x, timeout = NULL, ...)

\method{resolved}{MulticoreFuture}(x, timeout = NULL, ...)

resolved(x, ...)

\method{resolved}{default}(x, ...)

\method{resolved}{list}(x, ...)

\method{resolved}{environment}(x, ...)

\method{resolved}{Future}(x, ...)
}
\arguments{
\item{x}{A \link{Future}, a list, or an environment (which also
includes \link[listenv:listenv]{list environment}).}

\item{timeout}{(numeric) The maximum time (in seconds) for polling the worker
for a response. If no response is available within this time limit, FALSE is
returned assuming the future is still being processed.
If NULL, the value defaults to \code{getOption("future.<type>.resolved.timeout")},
then \code{getOption("future.resolved.timeout")}, and finally 0.01 (seconds),
where \verb{<type>} corresponds to the type of future, e.g. \code{cluster} and \code{multicore}.}

\item{\ldots}{Not used.}
}
\value{
A logical vector of the same length and dimensions as \code{x}.
Each element is TRUE unless the corresponding element is a
non-resolved future in case it is FALSE.
It never signals an error.

The default method always returns TRUE.
}
\description{
Check whether a future is resolved or not
}
\details{
\code{resolved()} attempts to launch a lazy future, if there is an available
worker, otherwise not.

\code{resolved()} methods must always return \code{TRUE} or \code{FALSE} values, must
always launch lazy futures, and must never block indefinitely. This is
because it should always be possible to poll futures until they are
resolved using \code{resolved()}, e.g.
\code{while (!all(resolved(futures))) Sys.sleep(5)}.

Each future backend must implement a \code{resolved()} method. It should return
either TRUE or FALSE, or throw a \link{FutureError} (which indicate a
significant, often unrecoverable infrastructure problem, or an interrupt).
}
\section{Behavior of cluster and multisession futures}{

If all worker slots are occupied, \code{resolved()} for \code{ClusterFuture} and
\code{MultisessionFuture} will attempt to free one up by checking whether
one of the futures is \emph{resolved}. If there is one, then its result is
collected in order to free up one worker slot.

\code{resolved()} for \code{ClusterFuture} may receive immediate condition objects, rather
than a \link{FutureResult}, when polling the worker for results. In such cases, the
condition object is collected and another poll it performed. Up to 100 immediate
conditions may be collected this way per \code{resolved()} call, before considering
the future non-resolved and FALSE being returned.
}

\section{Behavior of multicore futures}{

\code{resolved()} for \code{MulticoreFuture} may receive immediate condition objects, rather than a
\link{FutureResult}, when polling the worker for results. In such cases, \emph{all} such condition
objects are collected, before considering the future non-resolved and FALSE being returned.
}

