% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nchar.R
\name{nchar_sgr}
\alias{nchar_sgr}
\alias{nzchar_sgr}
\title{Control Sequence Aware Version of nchar}
\usage{
nchar_sgr(
  x,
  type = "chars",
  allowNA = FALSE,
  keepNA = NA,
  warn = getOption("fansi.warn", TRUE)
)

nzchar_sgr(x, keepNA = NA, warn = getOption("fansi.warn", TRUE))
}
\arguments{
\item{x}{a character vector or object that can be coerced to such.}

\item{type}{character(1L) partial matching
\code{c("chars", "width", "graphemes")}.  See \code{\link[base:nchar]{?nchar}}, as well
as the corresponding documentation sections on this page.}

\item{allowNA}{logical: should \code{NA} be returned for invalid
    multibyte strings or \code{"bytes"}-encoded strings (rather than
    throwing an error)?}

\item{keepNA}{logical: should \code{NA} be returned when
  \code{x} is \code{\link[base]{NA}}?  If false, \code{nchar()} returns
  \code{2}, as that is the number of printing characters used when
  strings are written to output, and \code{nzchar()} is \code{TRUE}.  The
  default for \code{nchar()}, \code{NA}, means to use \code{keepNA = TRUE}
  unless \code{type} is \code{"width"}.}

\item{warn}{TRUE (default) or FALSE, whether to warn when potentially
problematic \emph{Control Sequences} are encountered.  These could cause the
assumptions \code{fansi} makes about how strings are rendered on your display
to be incorrect, for example by moving the cursor (see \code{\link[=fansi]{?fansi}}).
At most one warning will be issued per element in each input vector.  Will
also warn about some badly encoded UTF-8 strings, but a lack of UTF-8
warnings is not a guarantee of correct encoding (use \code{\link{validUTF8}} for
that).}
}
\value{
Like \code{\link[base:nchar]{base::nchar}}, with \emph{Control Sequences} excluded.
}
\description{
These functions are deprecated in favor of the \code{\link{nchar_ctl}} and
\code{\link{nzchar_ctl}}.
}
\keyword{internal}
