% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_sample.R
\name{dist_sample}
\alias{dist_sample}
\title{Sampling distribution}
\usage{
dist_sample(x)
}
\arguments{
\item{x}{A list of sampled values.}
}
\description{
\lifecycle{stable}
}
\examples{
# Univariate numeric samples
dist <- dist_sample(x = list(rnorm(100), rnorm(100, 10)))

dist
mean(dist)
variance(dist)
skewness(dist)
generate(dist, 10)

density(dist, 1)

# Multivariate numeric samples
dist <- dist_sample(x = list(cbind(rnorm(100), rnorm(100, 10))))

dist
mean(dist)
variance(dist)
skewness(dist)
generate(dist, 10)

density(dist, 1)

}
