% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_ard_columns.R
\name{rename_ard_columns}
\alias{rename_ard_columns}
\title{Rename ARD Variables}
\usage{
rename_ard_columns(
  x,
  columns = c(all_ard_groups("names"), all_ard_variables("names")),
  fill = "{colname}",
  unlist = NULL
)
}
\arguments{
\item{x}{(\code{data.frame})\cr
an ARD data frame of class 'card'}

\item{columns}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to rename, e.g. selecting columns \code{c('group1', 'group2', 'variable')}
will rename \code{'group1_level'} to the name of the variable found in \code{'group1'}.
When, for example, the \code{'group1_level'} does not exist, the values of the
new column are filled with the values in the \code{fill} argument.
Default is \code{c(all_ard_groups("names"), all_ard_variables("names"))}.}

\item{fill}{(scalar/glue)\cr
a scalar to fill column values when the variable does not have levels.
If a character is passed, then it is processed with \code{glue::glue()}
where the \code{colname} element is available to inject into the string,
e.g. \code{'Overall {colname}'} may resolve to \code{'Overall AGE'} for an AGE column.
Default is \code{'{colname}'}.}

\item{unlist}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
data frame
}
\description{
Rename the grouping and variable columns to their original column names.
}
\examples{
# Example 1 ----------------------------------
ADSL |>
  ard_categorical(by = ARM, variables = AGEGR1) |>
  apply_fmt_fn() |>
  rename_ard_columns() |>
  unlist_ard_columns()

# Example 2 ----------------------------------
ADSL |>
  ard_continuous(by = ARM, variables = AGE) |>
  apply_fmt_fn() |>
  rename_ard_columns(fill = "Overall {colname}") |>
  unlist_ard_columns()
}
