% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{TCGAanalyze_Filtering}
\alias{TCGAanalyze_Filtering}
\title{Filtering mRNA transcripts and miRNA selecting a threshold.}
\usage{
TCGAanalyze_Filtering(
  tabDF,
  method,
  qnt.cut = 0.25,
  var.func = IQR,
  var.cutoff = 0.75,
  eta = 0.05,
  foldChange = 1
)
}
\arguments{
\item{tabDF}{is a dataframe or numeric matrix, each row represents a gene,
each column represents a sample come from TCGAPrepare}

\item{method}{is method of filtering such as 'quantile', 'varFilter', 'filter1', 'filter2'}

\item{qnt.cut}{is threshold selected as mean for filtering}

\item{var.func}{is function used as the per-feature filtering statistic.
See genefilter documentation}

\item{var.cutoff}{is a numeric value. See genefilter documentation}

\item{eta}{is a parameter for filter1. default eta = 0.05.}

\item{foldChange}{is a parameter for filter2. default foldChange = 1.}
}
\value{
A filtered dataframe or numeric matrix where each row represents a gene,
each column represents a sample
}
\description{
TCGAanalyze_Filtering allows user to filter mRNA transcripts and miRNA,
   samples, higher than the threshold defined quantile mean across all samples.
}
\examples{
dataNorm <- TCGAbiolinks::TCGAanalyze_Normalization(dataBRCA, geneInfo)
dataNorm <- TCGAanalyze_Normalization(tabDF = dataBRCA,
geneInfo = geneInfo,
method = "geneLength")
dataFilt <- TCGAanalyze_Filtering(tabDF = dataNorm, method = "quantile", qnt.cut = 0.25)
}
