% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fstats.R
\name{fstats}
\alias{fstats}
\title{A function for quickly calculating f statistics for use in sva}
\usage{
fstats(dat, mod, mod0)
}
\arguments{
\item{dat}{The transformed data matrix with the variables in rows and samples in columns}

\item{mod}{The model matrix being used to fit the data}

\item{mod0}{The null model being compared when fitting the data}
}
\value{
fstats A vector of F-statistics one for each row of dat.
}
\description{
This function does simple linear algebra to calculate f-statistics
for each row of a data matrix comparing the nested models
defined by the design matrices for the alternative (mod) and and null (mod0) cases.
The columns of mod0 must be a subset of the columns of mod.
}
\examples{
library(bladderbatch)
data(bladderdata)
dat <- bladderEset[1:50,]

pheno = pData(dat)
edata = exprs(dat)
mod = model.matrix(~as.factor(cancer), data=pheno)
mod0 = model.matrix(~1,data=pheno)

fs <- fstats(edata, mod, mod0)

}
