#' Toolkit for Compound-Protein Interaction in Drug Discovery
#'
#' Rcpi offers a molecular informatics toolkit with a
#' comprehensive integration of bioinformatics and
#' cheminformatics tools for drug discovery.
#'
#' The package vignette can be opened with \code{vignette('Rcpi')}.
#'
#' \tabular{ll}{
#' Package: \tab Rcpi\cr
#' Type: \tab Package\cr
#' License: \tab Artistic-2.0}
#'
#' @name Rcpi-package
#' @aliases Rcpi
#' @docType package
#'
#' @note
#' Bug reports and feature requests should be sent to
#' \url{https://github.com/nanxstats/Rcpi/issues}.
#'
#' @import foreach doParallel Biostrings GOSemSim ChemmineR fmcsR
#' @importFrom methods as
#' @importFrom stats cmdscale dist factanal na.omit prcomp predict sd
#' @importFrom utils capture.output combn read.csv
#'
NULL
