% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_contribution.R
\name{plot_contribution}
\alias{plot_contribution}
\title{Plot signature contribution barplot}
\usage{
plot_contribution(
  contribution,
  signatures = NA,
  index = NA,
  coord_flip = FALSE,
  mode = c("relative", "absolute"),
  palette = NA
)
}
\arguments{
\item{contribution}{Signature contribution matrix}

\item{signatures}{Signature matrix.
Necessary when plotting NMF results in "absolute" mode.
It's not necessary in relative mode or when visualizing signature refitting results}

\item{index}{optional sample subset parameter}

\item{coord_flip}{Flip X and Y coordinates, default = FALSE}

\item{mode}{"relative" or "absolute"; to plot the relative contribution or
absolute number of mutations, default = "relative"}

\item{palette}{A color palette like c("#FF0000", "#00FF00", "9999CC") that
will be used as colors in the plot.  By default, ggplot2's colors are used
to generate a palette.}
}
\value{
Stacked barplot with contribution of each signature for each sample
}
\description{
Plot contribution of signatures. Can be used on both the results of a NMF
and on the results of signature refitting.
}
\examples{

## Extracting signatures can be computationally intensive, so
## we use pre-computed data generated with the following command:
# nmf_res <- extract_signatures(mut_mat, rank = 2)

nmf_res <- readRDS(system.file("states/nmf_res_data.rds",
  package = "MutationalPatterns"
))

## Optionally set column and row names.
colnames(nmf_res$signatures) <- c("Signature A", "Signature B")
rownames(nmf_res$contribution) <- c("Signature A", "Signature B")

## Plot the relative contribution
plot_contribution(nmf_res$contribution)

## Plot the absolute contribution.
## When plotting absolute NMF results, the signatures need to be included.
plot_contribution(nmf_res$contribution,
  nmf_res$signature,
  mode = "absolute"
)


## Only plot a subset of samples
plot_contribution(nmf_res$contribution,
  nmf_res$signature,
  mode = "absolute",
  index = c(1, 2)
)
## Flip the coordinates
plot_contribution(nmf_res$contribution,
  nmf_res$signature,
  mode = "absolute",
  coord_flip = TRUE
)

## You can also use the results of signature refitting.
## Here we load some data as an example
fit_res <- readRDS(system.file("states/snv_refit.rds",
  package = "MutationalPatterns"
))
plot_contribution(fit_res$contribution)

## Or again in absolute mode
plot_contribution(fit_res$contribution,
  mode = "absolute"
)
}
\seealso{
\code{\link{extract_signatures}},
\code{\link{mut_matrix}}
}
