% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute}
\alias{impute}
\title{Impute missing values from a fitted MOFA model}
\usage{
impute(object, views = "all", factors = "all", type = c("inRange",
  "response", "link"))
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{views}{character vector with the view names, or numeric vector with view indexes.}

\item{factors}{character vector with the factor names, or numeric vector with the factor indexes.}

\item{type}{type of prediction returned, either: 
\itemize{
 \item{\strong{response}:}{ gives the response vector, the mean for Gaussian and Poisson,
  and success probabilities for Bernoulli.}
 \item{\strong{link}:}{ gives the linear predictions.}
 \item{\strong{inRange}:}{ rounds the fitted values of integer-valued distributions
  (Poisson and Bernoulli) to the next integer.
 This is the default option.}
}}
}
\value{
a \code{\link{MOFAmodel}} object with imputed data in the \code{ImputedData} slot
}
\description{
This function uses the latent factors and the loadings inferred
 in order to impute missing values.
}
\details{
Matrix factorization models generate a denoised and condensed low-dimensional representation 
of the data which capture the main sources of heterogeneity of the data. 
Such representation can be used to do predictions via the equation \code{Y = WZ}. \cr
This method fills the \code{ImputedData} slot by replacing the missing values 
in the training data with the model predictions.\cr
For more details see the Methods section of the MOFA article.
}
\examples{
# Load CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
# impute missing data in all views using all factors
MOFA_CLL <- impute(MOFA_CLL)

# Load scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
# impute missing data in the RNA view using Factor 1
MOFA_scMT <- impute(MOFA_scMT, views="RNA expression", factors="LF1")
}
