% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitTimeSeries.R
\name{plotTimeSeries}
\alias{plotTimeSeries}
\title{Plot difference function for particular bacteria}
\usage{
plotTimeSeries(
  res,
  C = 0,
  xlab = "Time",
  ylab = "Difference in abundance",
  main = "SS difference function prediction",
  ...
)
}
\arguments{
\item{res}{Output of fitTimeSeries function}

\item{C}{Value for which difference function has to be larger or smaller than (default 0).}

\item{xlab}{X-label.}

\item{ylab}{Y-label.}

\item{main}{Main label.}

\item{...}{Extra plotting arguments.}
}
\value{
Plot of difference in abundance for significant features.
}
\description{
Plot the difference in abundance for significant features.
}
\examples{

data(mouseData)
res = fitTimeSeries(obj=mouseData,feature="Actinobacteria",
   class="status",id="mouseID",time="relativeTime",lvl='class',B=10)
plotTimeSeries(res)

}
\seealso{
\code{\link{fitTimeSeries}}
}
