% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MRcoefs.R
\name{MRcoefs}
\alias{MRcoefs}
\title{Table of top-ranked features from fitZig or fitFeatureModel}
\usage{
MRcoefs(obj, by = 2, coef = NULL, number = 10, taxa = obj$taxa,
  uniqueNames = FALSE, adjustMethod = "fdr", group = 0, eff = 0,
  numberEff = FALSE, counts = 0, file = NULL)
}
\arguments{
\item{obj}{Output of fitFeatureModel or fitZig.}

\item{by}{Column number or column name specifying which coefficient or
contrast of the linear model is of interest.}

\item{coef}{Column number(s) or column name(s) specifying which coefficient
or contrast of the linear model to display.}

\item{number}{The number of bacterial features to pick out.}

\item{taxa}{Taxa list.}

\item{uniqueNames}{Number the various taxa.}

\item{adjustMethod}{Method to adjust p-values by. Default is "FDR". Options
include "holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr",
"none". See \code{\link{p.adjust}} for more details.}

\item{group}{One of five choices, 0,1,2,3,4. 0: the sort is ordered by a
decreasing absolute value coefficient fit. 1: the sort is ordered by the raw
coefficient fit in decreasing order. 2: the sort is ordered by the raw
coefficient fit in increasing order. 3: the sort is ordered by the p-value
of the coefficient fit in increasing order. 4: no sorting.}

\item{eff}{Filter features to have at least a "eff" quantile or number of effective samples.}

\item{numberEff}{Boolean, whether eff should represent quantile (default/FALSE) or number.}

\item{counts}{Filter features to have at least 'counts' counts.}

\item{file}{Name of output file, including location, to save the table.}
}
\value{
Table of the top-ranked features determined by the linear fit's
coefficient.
}
\description{
Extract a table of the top-ranked features from a linear model fit. This
function will be updated soon to provide better flexibility similar to
limma's topTable.
}
\examples{

data(lungData)
k = grep("Extraction.Control",pData(lungData)$SampleType)
lungTrim = lungData[,-k]
lungTrim=filterData(lungTrim,present=30)
lungTrim=cumNorm(lungTrim,p=0.5)
smokingStatus = pData(lungTrim)$SmokingStatus
mod = model.matrix(~smokingStatus)
fit = fitZig(obj = lungTrim,mod=mod)
head(MRcoefs(fit))
####
fit = fitFeatureModel(obj = lungTrim,mod=mod)
head(MRcoefs(fit))

}
\seealso{
\code{\link{fitZig}} \code{\link{fitFeatureModel}} \code{\link{MRtable}} \code{\link{MRfulltable}}
}
