\name{switchPlot}
\alias{switchPlot}
\title{
Isoform Switch Analysis Plot
}
\description{
This function enables a full analysis of a specific gene containing an isoform switch (with functional consequences) by creating a composite plot visualizing 1) The isoform structure along with the concatenated annotations (including transcript classification, ORF, Coding Potential, NMD sensitivity, annotated protein domains as well as annotated signal peptides) 2) gene and isoform expression and 3) isoform usage - including the result of the isoform switch test.
}
\usage{

switchPlot(
    ### Core arguments
    switchAnalyzeRlist,
    gene = NULL,
    isoform_id = NULL,
    condition1,
    condition2,

    ### Advanced arguments
    IFcutoff = 0.05,
    dIFcutoff = 0.1,
    alphas = c(0.05, 0.001),
    rescaleTranscripts = TRUE,
    plotTopology = TRUE,
    reverseMinus = TRUE,
    addErrorbars = TRUE,
    logYaxis = FALSE,
    localTheme = theme_bw(base_size = 8),
    additionalArguments = list()
)

}

\arguments{
  \item{switchAnalyzeRlist}{
A \code{switchAnalyzeRlist} object containing all the analysis to be induced (e.g. if protein domains should be visualized they should be annotated in the \code{switchAnalyzeRlist} object (via \link{analyzePFAM}))
}

  \item{gene}{
Either the gene_id or the gene name of the gene to plot, alternatively one can use the \code{isoform_id} argument to supply a vector of isoform_ids.
}

  \item{isoform_id}{
Vector of id indicating which isoforms (from the same gene) to plot, alternatively one can use the \code{gene_id} argument to plot all isoforms of a gene.
}

  \item{condition1}{
First condition of the comparison to analyze. Must match 'condition_1' in the 'isoformFeatures' entry of the \code{switchAnalyzeRlist}. Only needed if more than one comparison is analyzed.
}

  \item{condition2}{
Second condition of the comparison to analyze. Must match 'condition_2' in the 'isoformFeatures' entry of the \code{switchAnalyzeRlist}. Only needed if more than one comparison is analyzed.
}

\item{IFcutoff}{
The cutoff used for the minimum contribution to gene expression (in at least one condition) for an isoforms must have to be plotted (measured as Isoform Fraction (IF) values). Default is 0.05 (which removes isoforms with minor contribution).
}

\item{dIFcutoff}{
The dIF cutoff used to add usage to the transcript plot. Default is 0.1.
}

\item{alphas}{A numeric vector of length two giving the significance levels represented in plots. The numbers indicate the q-value cutoff for significant (*) and highly significant (***) respectively. Default 0.05 and 0.001 which should be interpret as q<0.05 and q<0.001 respectively). If q-values are higher than this they will be annotated as 'ns' (not significant).}

  \item{rescaleTranscripts}{
A Logical indicating whether all the isoforms should be resealed to the square root of their original sizes. This feature is implemented because introns usually are much larger than exons making it difficult to see structural changes. This is very useful for structural visualization but the scaling might distort actual intron and exon sizes. Default is TRUE.
}

  \item{plotTopology}{
A Logical indicating whether topology should be plotted as squares above the transcripts. Default is TRUE.
}

  \item{reverseMinus}{
A logic indicating whether isoforms on minus strand should be inverted so they are visualized as going from left to right instead of right to left. (Only affects minus strand isoforms). Default is TRUE
}

  \item{addErrorbars}{
A logic indicating whether error bars should be added to the expression plots to show uncertainty in estimates (recommended). By default the error-bars indicate 95\% confidence intervals, see ?switchPlotGeneExp for more information and additional options (that can be passed via \code{additionalArguments}. Default is TRUE.
}

\item{logYaxis}{
A logical indicating whether the y-axis of gene and isoform expression sub-plots should be log10 transformed. Default is FALSE.
}
  \item{localTheme}{
General ggplo2 theme with which the plot is made, see \code{?ggplot2::theme} for more info. Default is theme_bw().
}
  \item{additionalArguments}{
A named list arguments passed to the functions \code{switchPlotTranscript}, \code{switchPlotGeneExp}, \code{switchPlotIsoExp}, and \code{switchPlotIsoUsage} which each creates a subset of the Isoform Switch Analysis Plot. This enable further customization of the plots. The name of the list entries must correspond to the corresponding argument in the sub-function.
}
}

\details{
The isoform switch analysis plot is a plot contains all the information necessary to judge the importance of a gene with isoform switching, and contains information about from expression levels, switch size as well as the annotation of the isoform differences.

The gene expression, isoform expression and isoform usage plots are generated by \code{switchPlotGeneExp}, \code{switchPlotIsoExp} and \code{switchPlotIsoUsage} respectively. The plot of the transcript structure along with all the annotation is done with \code{switchPlotTranscript}. The 'Increased/decreased/unchanged usage is determined by the \code{dIFcutoff} and \code{alphas} arguments (since we require it to be  both significant (< min(alphas)) and changing (abs(dIF) > dIFcutoff) before being annotated as changing.

Changes in isoform usage are measure as the difference in isoform fraction (dIF) values, where isoform fraction (IF) values are calculated as <isoform_exp> / <gene_exp>. In the transcript structure the annotation of "increased/decrease/unchanged usage" simply indicate if |dIF| > dIFcutoff.
\cr

The switchPlot contains regions "Not Annotated" if regions were not analyzed due to the limitations on EBI's website (else EBI will not accept the files). Specifically this is controlled with the "removeLongAAseq" argument of \link{extractSequence}.
}

\value{
A isoform switch analysis plot
}
\references{
Vitting-Seerup et al. The Landscape of Isoform Switches in Human Cancers. Mol. Cancer Res. (2017).
}
\author{
Kristoffer Vitting-Seerup
}
\seealso{
\code{\link{switchPlotTranscript}}\cr
\code{\link{switchPlotGeneExp}}\cr
\code{\link{switchPlotIsoExp}}\cr
\code{\link{switchPlotIsoUsage}}\cr
\code{\link{switchPlotTopSwitches}}
}
\examples{
### Prepare for plotting
data("exampleSwitchListAnalyzed")

mostSwitchingGene <- extractTopSwitches(
    exampleSwitchListAnalyzed,
    filterForConsequences = TRUE,
    n = 1
)

### Make isoform Switch Analysis Plot
switchPlot(
    switchAnalyzeRlist = exampleSwitchListAnalyzed,
    gene = mostSwitchingGene$gene_id,
    condition1 = mostSwitchingGene$condition_1,
    condition2 = mostSwitchingGene$condition_2
)
}
