### R code from vignette source 'GenomicFeatures.Rnw'

###################################################
### code chunk number 1: loadGenomicFeatures
###################################################
library("GenomicFeatures")


###################################################
### code chunk number 2: loadDb
###################################################
samplefile <- system.file("extdata", "UCSC_knownGene_sample.sqlite",
                          package="GenomicFeatures")
txdb <- loadDb(samplefile)
txdb


###################################################
### code chunk number 3: loadPackage
###################################################
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene #shorthand (for convenience)
txdb


###################################################
### code chunk number 4: seqlevels
###################################################
head(seqlevels(txdb))


###################################################
### code chunk number 5: seqlevels2
###################################################
seqlevels(txdb, force=TRUE) <- c("chr1")


###################################################
### code chunk number 6: seqlevels3
###################################################
txdb <- restoreSeqlevels(txdb)


###################################################
### code chunk number 7: seqlevels4
###################################################
seqlevels(txdb, force=TRUE) <- c("chr15")


###################################################
### code chunk number 8: selectExample
###################################################
keys <- c("100033416", "100033417", "100033420")
columns(txdb)
keytypes(txdb)
select(txdb, keys = keys, columns="TXNAME", keytype="GENEID")


###################################################
### code chunk number 9: selectExercise
###################################################
columns(txdb)
cols <- c("TXNAME", "TXSTRAND", "TXCHROM")
select(txdb, keys=keys, columns=cols, keytype="GENEID")


###################################################
### code chunk number 10: transcripts1
###################################################
GR <- transcripts(txdb)
GR[1:3]


###################################################
### code chunk number 11: transcripts2
###################################################
GR <- transcripts(txdb, vals <- list(tx_chrom = "chr15", tx_strand = "+"))
length(GR)
unique(strand(GR))


###################################################
### code chunk number 12: exonsExer1
###################################################
EX <- exons(txdb)
EX[1:4]
length(EX)
length(GR)


###################################################
### code chunk number 13: transcriptsBy
###################################################
GRList <- transcriptsBy(txdb, by = "gene")
length(GRList)
names(GRList)[10:13]
GRList[11:12]


###################################################
### code chunk number 14: exonsBy
###################################################
GRList <- exonsBy(txdb, by = "tx")
length(GRList)
names(GRList)[10:13]
GRList[[12]]


###################################################
### code chunk number 15: internalID
###################################################
GRList <- exonsBy(txdb, by = "tx")
tx_ids <- names(GRList)
head(select(txdb, keys=tx_ids, columns="TXNAME", keytype="TXID"))


###################################################
### code chunk number 16: introns-UTRs
###################################################
length(intronsByTranscript(txdb))
length(fiveUTRsByTranscript(txdb))
length(threeUTRsByTranscript(txdb))


###################################################
### code chunk number 17: extract
###################################################
library(BSgenome.Hsapiens.UCSC.hg19)
tx_seqs1 <- extractTranscriptsFromGenome(Hsapiens, 
                                         TxDb.Hsapiens.UCSC.hg19.knownGene)


###################################################
### code chunk number 18: translate
###################################################
translate(tx_seqs1)


###################################################
### code chunk number 19: betterTranslation
###################################################
cds_seqs <- extractTranscriptsFromGenome(Hsapiens, cdsBy(txdb, by="tx"))
translate(cds_seqs)


###################################################
### code chunk number 20: supportedUCSCtables
###################################################
supportedUCSCtables()[1:4, ]


###################################################
### code chunk number 21: makeTranscriptDbFromUCSC (eval = FALSE)
###################################################
## mm9KG <- makeTranscriptDbFromUCSC(genome = "mm9", tablename = "knownGene")


###################################################
### code chunk number 22: discoverChromNames
###################################################
head(getChromInfoFromUCSC("hg19"))


###################################################
### code chunk number 23: makeTranscriptDbFromBiomart (eval = FALSE)
###################################################
## mmusculusEnsembl <-
##    makeTranscriptDbFromBiomart(biomart = "ensembl",
##                               dataset = "mmusculus_gene_ensembl")


###################################################
### code chunk number 24: saveFeatures 1 (eval = FALSE)
###################################################
## saveDb(mm9KG, file="fileName.sqlite")


###################################################
### code chunk number 25: loadFeatures-1 (eval = FALSE)
###################################################
## mm9KG <- loadDb("fileName.sqlite")


###################################################
### code chunk number 26: SessionInfo
###################################################
sessionInfo()


