context("nbinomWald")
test_that("nbinomWald throws various errors and works with edge cases",{
  dds <- makeExampleDESeqDataSet(n=100, m=4)
  expect_error(nbinomWaldTest(dds))
  expect_error(nbinomLRT(dds))
  dds <- estimateSizeFactors(dds)
  dds <- estimateDispersions(dds)
  mm <- model.matrix(~ condition, colData(dds))
  mm0 <- model.matrix(~ 1, colData(dds))
  expect_error(nbinomWaldTest(dds, betaPrior=TRUE, modelMatrix=mm))
  expect_error(nbinomLRT(dds, betaPrior=TRUE, full=mm, reduced=mm0))
  expect_error(nbinomWaldTest(dds, betaPrior=FALSE, modelMatrixType="expanded"))
  expect_error(nbinomLRT(dds, betaPrior=FALSE, modelMatrixType="expanded"))
  dds2 <- estimateMLEForBetaPriorVar(dds)
  estimateBetaPriorVar(dds2, betaPriorMethod="quantile")
  dds <- nbinomWaldTest(dds, modelMatrixType="standard")
  covarianceMatrix(dds, 1)

  # changing 'df'
  dds <- makeExampleDESeqDataSet(n=100, m=4)
  counts(dds)[1:4,] <- rep(0L, 16)
  dds <- estimateSizeFactors(dds)
  dds <- estimateDispersions(dds)
  dds <- nbinomWaldTest(dds)
  round(head(results(dds)$pvalue,8),3)
  dds <- nbinomWaldTest(dds, useT=TRUE, df=rep(1,100))
  round(head(results(dds)$pvalue,8),3)
  
  # try nbinom after no fitted dispersions
  dds <- makeExampleDESeqDataSet(n=100, m=4)
  dds <- estimateSizeFactors(dds)
  dds <- estimateDispersionsGeneEst(dds)
  dispersions(dds) <- mcols(dds)$dispGeneEst
  dds <- nbinomWaldTest(dds)
})
