% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{counts}
\alias{counts}
\alias{counts,DESeqDataSet-method}
\alias{counts<-,DESeqDataSet,matrix-method}
\alias{counts}
\title{Accessors for the 'counts' slot of a DESeqDataSet object.}
\usage{
\S4method{counts}{DESeqDataSet}(object, normalized = FALSE,
  replaced = FALSE)

\S4method{counts}{DESeqDataSet,matrix}(object) <- value
}
\arguments{
\item{object}{a \code{DESeqDataSet} object.}

\item{normalized}{logical indicating whether or not to divide the counts by
the size factors or normalization factors before returning
(normalization factors always preempt size factors)}

\item{replaced}{after a \code{DESeq} call, this argument will return the counts
with outliers replaced instead of the original counts, and optionally \code{normalized}.
The replaced counts are stored by \code{DESeq} in \code{assays(object)[['replaceCounts']]}.}

\item{value}{an integer matrix}
}
\description{
The counts slot holds the count data as a matrix of non-negative integer
count values, one row for each observational unit (gene or the like), and one
column for each sample.
}
\examples{

dds <- makeExampleDESeqDataSet(m=4)
head(counts(dds))

dds <- estimateSizeFactors(dds) # run this or DESeq() first
head(counts(dds, normalized=TRUE))

}
\seealso{
\code{\link{sizeFactors}}, \code{\link{normalizationFactors}}
}
\author{
Simon Anders
}
