/*
 * This file is part of the WebKit open source project.
 * This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#import "config.h"

#if ENABLE(Condition1) || ENABLE(Condition2)

#import "DOMInternal.h"

#import "DOMTestInterface.h"

#import "DOMBlobInternal.h"
#import "DOMCSSRuleInternal.h"
#import "DOMCSSValueInternal.h"
#import "DOMEventInternal.h"
#import "DOMNodeInternal.h"
#import "DOMStyleSheetInternal.h"
#import "DOMTestInterfaceInternal.h"
#import "DOMTestObjInternal.h"
#import "ExceptionHandlers.h"
#import "JSMainThreadExecState.h"
#import "KURL.h"
#import "Node.h"
#import "TestInterface.h"
#import "TestObj.h"
#import "TestSupplemental.h"
#import "ThreadCheck.h"
#import "WebCoreObjCExtras.h"
#import "WebScriptObjectPrivate.h"
#import <wtf/GetPtr.h>

#define IMPL reinterpret_cast<WebCore::TestInterface*>(_internal)

@implementation DOMTestInterface

- (void)dealloc
{
    if (WebCoreObjCScheduleDeallocateOnMainThread([DOMTestInterface class], self))
        return;

    if (_internal)
        IMPL->deref();
    [super dealloc];
}

- (void)finalize
{
    if (_internal)
        IMPL->deref();
    [super finalize];
}

#if ENABLE(Condition11) || ENABLE(Condition12)
- (NSString *)supplementalStr1
{
    WebCore::JSMainThreadNullState state;
    return TestSupplemental::supplementalStr1(IMPL);
}
#endif

#if ENABLE(Condition11) || ENABLE(Condition12)
- (NSString *)supplementalStr2
{
    WebCore::JSMainThreadNullState state;
    return TestSupplemental::supplementalStr2(IMPL);
}

- (void)setSupplementalStr2:(NSString *)newSupplementalStr2
{
    WebCore::JSMainThreadNullState state;
    TestSupplemental::setSupplementalStr2(IMPL, newSupplementalStr2);
}
#endif

#if ENABLE(Condition11) || ENABLE(Condition12)
- (NSString *)supplementalStr3
{
    WebCore::JSMainThreadNullState state;
    return TestSupplemental::supplementalStr3(IMPL);
}

- (void)setSupplementalStr3:(NSString *)newSupplementalStr3
{
    WebCore::JSMainThreadNullState state;
    TestSupplemental::setSupplementalStr3(IMPL, newSupplementalStr3);
}
#endif

#if ENABLE(Condition11) || ENABLE(Condition12)
- (DOMNode *)supplementalNode
{
    WebCore::JSMainThreadNullState state;
    return kit(WTF::getPtr(TestSupplemental::supplementalNode(IMPL)));
}

- (void)setSupplementalNode:(DOMNode *)newSupplementalNode
{
    WebCore::JSMainThreadNullState state;
    ASSERT(newSupplementalNode);

    TestSupplemental::setSupplementalNode(IMPL, core(newSupplementalNode));
}
#endif


#if ENABLE(Condition11) || ENABLE(Condition12)
- (void)supplementalMethod1
{
    WebCore::JSMainThreadNullState state;
    TestSupplemental::supplementalMethod1(IMPL);
}

#endif


#if ENABLE(Condition11) || ENABLE(Condition12)
- (DOMTestObj *)supplementalMethod2:(NSString *)strArg objArg:(DOMTestObj *)objArg
{
    WebCore::JSMainThreadNullState state;
    WebCore::ExceptionCode ec = 0;
    DOMTestObj *result = kit(WTF::getPtr(TestSupplemental::supplementalMethod2(IMPL, strArg, core(objArg), ec)));
    WebCore::raiseOnDOMError(ec);
    return result;
}

#endif


#if ENABLE(Condition11) || ENABLE(Condition12)
- (void)supplementalMethod3
{
    WebCore::JSMainThreadNullState state;
    TestSupplemental::supplementalMethod3(IMPL);
}

#endif


#if ENABLE(Condition11) || ENABLE(Condition12)
- (void)supplementalMethod4
{
    WebCore::JSMainThreadNullState state;
    TestSupplemental::supplementalMethod4(IMPL);
}

#endif

@end

WebCore::TestInterface* core(DOMTestInterface *wrapper)
{
    return wrapper ? reinterpret_cast<WebCore::TestInterface*>(wrapper->_internal) : 0;
}

DOMTestInterface *kit(WebCore::TestInterface* value)
{
    { DOM_ASSERT_MAIN_THREAD(); WebCoreThreadViolationCheckRoundOne(); };
    if (!value)
        return nil;
    if (DOMTestInterface *wrapper = getDOMWrapper(value))
        return [[wrapper retain] autorelease];
    DOMTestInterface *wrapper = [[DOMTestInterface alloc] _init];
    wrapper->_internal = reinterpret_cast<DOMObjectInternal*>(value);
    value->ref();
    addDOMWrapper(wrapper, value);
    return [wrapper autorelease];
}

#endif // ENABLE(Condition1) || ENABLE(Condition2)
