# - Try to find QZion
# Once done this will define
#
#  QZION_INCLUDE_DIRS - the QZion include directory
#  QZION_LIBRARIES - Link these to use QZion
#  QZION_CFLAGS_OTHER - Compiler switches required for using QZion
#

# use pkg-config to get the directories and then use these values
# in the FIND_PATH() and FIND_LIBRARY() calls
if( NOT WIN32 )
  find_package(PkgConfig)
  pkg_check_modules(PC_QZion qzion>=0.4.0)
endif( NOT WIN32 )

# use this just to create a nice message at FindPackageHandleStandardArgs
if (PC_QZion_FOUND)
  FIND_LIBRARY(QZion_LIBRARY NAMES qzion
    PATHS
    ${PC_QZion_LIBDIR}
    ${PC_QZion_LIBRARY_DIRS}
  )
  SET(QZION_LIBRARIES ${QZion_LIBRARY})
  SET(QZION_INCLUDE_DIRS ${PC_QZion_INCLUDE_DIRS})
else (PC_QZion_FOUND)
  MESSAGE(STATUS "Could not find QZion. Please download it here (http://dev.openbossa.org/trac/qedje).")
endif (PC_QZion_FOUND)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(QZion DEFAULT_MSG QZion_LIBRARY)

# show QZion_LIBRARY variables only in the advanced view
MARK_AS_ADVANCED(QZion_LIBRARY)
