/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef USERWGT_H
#define USERWGT_H

#include <QListWidgetItem>
#include <QObject>

class UserInfo;
class UserStatistics;

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class UserWgt : public QObject, public QListWidgetItem
{
  Q_OBJECT
  private:
    UserInfo* m_info;
    UserStatistics* m_stats;

  public:
    UserWgt(QListWidget* parent = 0);
    ~UserWgt();

    void setInfo(UserInfo* info);
    UserInfo* info() const {return m_info;}

    void setStats(UserStatistics* value){m_stats = value;}
    UserStatistics* stats() const {return m_stats;}
};

#endif
