/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#include "logwgt.h"

#include <QLayout>
#include <QTextCursor>
#include <QScrollBar>

LogWgt::LogWgt(QWidget *parent)
 : QWidget(parent)
{
  QGridLayout* grid = new QGridLayout(this);
  mw_text           = new QTextEdit(this);

  grid->addWidget(mw_text);
  grid->setMargin(2);
  mw_text->setReadOnly(true);
}
//\*****************************************************************************
void LogWgt::addMessage(const QString & msg, const QColor & color)
{
  QTextCursor cur_new, cur_old;
  cur_new = cur_old = mw_text->textCursor();
  cur_new.clearSelection();

  cur_new.setPosition(mw_text->toPlainText().size());
  mw_text->setTextCursor(cur_new);
  mw_text->setTextColor (color);

  mw_text->append(msg);

  cur_new.setPosition(mw_text->toPlainText().size());
  mw_text->setTextCursor(cur_new);

  mw_text->setTextCursor(cur_old);
  mw_text->verticalScrollBar()->setValue(mw_text->verticalScrollBar()->maximum());
}
