# Key is the enum value of each keyword
# values follow the design of GmfKwdFmt array of
# https://github.com/LoicMarechal/libMeshb/blob/master/sources/libmeshb7.c
# For each keyword we assign whether there is a counter associated with it (second column) and
# its format as a string of numbers
#
# i:integer, f:float, d:dimension
medit_codes = {
    0: ("GmfReserved", "", ""),
    1: ("GmfMeshVersionFormatted", "", "i"),
    2: ("GmfReserved", "", ""),
    3: ("GmfDimension", "", "i"),
    4: ("GmfVertices", "i", "dri"),
    5: ("GmfEdges", "i", "iii"),
    6: ("GmfTriangles", "i", "iiii"),
    7: ("GmfQuadrilaterals", "i", "iiiii"),
    8: ("GmfTetrahedra", "i", "iiiii"),
    9: ("GmfPrisms", "i", "iiiiiii"),
    10: ("GmfHexahedra", "i", "iiiiiiiii"),
    11: ("GmfReserved", "", ""),
    12: ("GmfReserved", "", ""),
    13: ("GmfCorners", "i", "i"),
    14: ("GmfRidges", "i", "i"),
    15: ("GmfRequiredVertices", "i", "i"),
    16: ("GmfRequiredEdges", "i", "i"),
    17: ("GmfRequiredTriangles", "i", "i"),
    18: ("GmfRequiredQuadrilaterals", "i", "i"),
    19: ("GmfTangentAtEdgeVertices", "i", "iii"),
    20: ("GmfNormalAtVertices", "i", "ii"),
    21: ("GmfNormalAtTriangleVertices", "i", "iii"),
    22: ("GmfNormalAtQuadrilateralVertices", "i", "iiii"),
    23: ("GmfAngleOfCornerBound", "", "r"),
    24: ("GmfTrianglesP2", "i", "iiiiiii"),
    25: ("GmfEdgesP2", "i", "iiii"),
    26: ("GmfSolAtPyramids", "i", "sr"),
    27: ("GmfQuadrilateralsQ2", "i", "iiiiiiiiii"),
    28: ("GmfISolAtPyramids", "i", "iiiii"),
    29: ("GmfSubDomainFromGeom", "i", "iii"),
    30: ("GmfTetrahedraP2", "i", "iiiiiiiiiii"),
    31: ("GmfFault_NearTri", "i", "i"),
    32: ("GmfFault_Inter", "i", "i"),
    33: ("GmfHexahedraQ2", "i", "iiiiiiiiiiiiiiiiiiiiiiiiiiii"),
    34: ("GmfExtraVerticesAtEdges", "i", "in"),
    35: ("GmfExtraVerticesAtTriangles", "i", "in"),
    36: ("GmfExtraVerticesAtQuadrilaterals", "i", "in"),
    37: ("GmfExtraVerticesAtTetrahedra", "i", "in"),
    38: ("GmfExtraVerticesAtPrisms", "i", "in"),
    39: ("GmfExtraVerticesAtHexahedra", "i", "in"),
    40: ("GmfVerticesOnGeometricVertices", "i", "ii"),
    41: ("GmfVerticesOnGeometricEdges", "i", "iirr"),
    42: ("GmfVerticesOnGeometricTriangles", "i", "iirrr"),
    43: ("GmfVerticesOnGeometricQuadrilaterals", "i", "iirrr"),
    44: ("GmfEdgesOnGeometricEdges", "i", "ii"),
    45: ("GmfFault_FreeEdge", "i", "i"),
    46: ("GmfPolyhedra", "i", "iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii"),
    47: ("GmfPolygons", "", "iiiiiiiii"),
    48: ("GmfFault_Overlap", "i", "i"),
    49: ("GmfPyramids", "i", "iiiiii"),
    50: ("GmfBoundingBox", "", "drdr"),
    51: ("GmfReserved", "", ""),
    52: ("GmfPrivateTable", "i", "i"),
    53: ("GmfFault_BadShape", "i", "i"),
    54: ("GmfEnd", "", ""),
    55: ("GmfTrianglesOnGeometricTriangles", "i", "ii"),
    56: ("GmfTrianglesOnGeometricQuadrilaterals", "i", "ii"),
    57: ("GmfQuadrilateralsOnGeometricTriangles", "i", "ii"),
    58: ("GmfQuadrilateralsOnGeometricQuadrilaterals", "i", "ii"),
    59: ("GmfTangents", "i", "dr"),
    60: ("GmfNormals", "i", "dr"),
    61: ("GmfTangentAtVertices", "i", "ii"),
    62: ("GmfSolAtVertices", "i", "sr"),
    63: ("GmfSolAtEdges", "i", "sr"),
    64: ("GmfSolAtTriangles", "i", "sr"),
    65: ("GmfSolAtQuadrilaterals", "i", "sr"),
    66: ("GmfSolAtTetrahedra", "i", "sr"),
    67: ("GmfSolAtPrisms", "i", "sr"),
    68: ("GmfSolAtHexahedra", "i", "sr"),
    69: ("GmfDSolAtVertices", "i", "sr"),
    70: ("GmfISolAtVertices", "i", "i"),
    71: ("GmfISolAtEdges", "i", "ii"),
    72: ("GmfISolAtTriangles", "i", "iii"),
    73: ("GmfISolAtQuadrilaterals", "i", "iiii"),
    74: ("GmfISolAtTetrahedra", "i", "iiii"),
    75: ("GmfISolAtPrisms", "i", "iiiiii"),
    76: ("GmfISolAtHexahedra", "i", "iiiiiiii"),
    77: ("GmfIterations", "", "i"),
    78: ("GmfTime", "", "r"),
    79: ("GmfFault_SmallTri", "i", "i"),
    80: ("GmfCoarseHexahedra", "i", "i"),
    81: ("GmfComments", "i", "c"),
    82: ("GmfPeriodicVertices", "i", "ii"),
    83: ("GmfPeriodicEdges", "i", "ii"),
    84: ("GmfPeriodicTriangles", "i", "ii"),
    85: ("GmfPeriodicQuadrilaterals", "i", "ii"),
    86: ("GmfPrismsP2", "i", "iiiiiiiiiiiiiiiiiii"),
    87: ("GmfPyramidsP2", "i", "iiiiiiiiiiiiiii"),
    88: ("GmfQuadrilateralsQ3", "i", "iiiiiiiiiiiiiiiii"),
    89: ("GmfQuadrilateralsQ4", "i", "iiiiiiiiiiiiiiiiiiiiiiiiii"),
    90: ("GmfTrianglesP3", "i", "iiiiiiiiiii"),
    91: ("GmfTrianglesP4", "i", "iiiiiiiiiiiiiiii"),
    92: ("GmfEdgesP3", "i", "iiiii"),
    93: ("GmfEdgesP4", "i", "iiiiii"),
    94: ("GmfIRefGroups", "i", "ciii"),
    95: ("GmfDRefGroups", "i", "iii"),
    96: ("GmfTetrahedraP3", "i", "iiiiiiiiiiiiiiiiiiiii"),
    97: ("GmfTetrahedraP4", "i", "iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii"),
    98: (
        "GmfHexahedraQ3",
        "i",
        "iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii",
    ),
    99: (
        "GmfHexahedraQ4",
        "i",
        "iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii",
    ),
    100: ("GmfPyramidsP3", "i", "iiiiiiiiiiiiiiiiiiiiiiiiiiiiiii"),
    101: (
        "GmfPyramidsP4",
        "i",
        "iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii",
    ),
    102: ("GmfPrismsP3", "i", "iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii"),
    103: (
        "GmfPrismsP4",
        "i",
        "iiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiiii",
    ),
    104: ("GmfHOSolAtEdgesP1", "i", "hr"),
    105: ("GmfHOSolAtEdgesP2", "i", "hr"),
    106: ("GmfHOSolAtEdgesP3", "i", "hr"),
    107: ("GmfHOSolAtTrianglesP1", "i", "hr"),
    108: ("GmfHOSolAtTrianglesP2", "i", "hr"),
    109: ("GmfHOSolAtTrianglesP3", "i", "hr"),
    110: ("GmfHOSolAtQuadrilateralsQ1", "i", "hr"),
    111: ("GmfHOSolAtQuadrilateralsQ2", "i", "hr"),
    112: ("GmfHOSolAtQuadrilateralsQ3", "i", "hr"),
    113: ("GmfHOSolAtTetrahedraP1", "i", "hr"),
    114: ("GmfHOSolAtTetrahedraP2", "i", "hr"),
    115: ("GmfHOSolAtTetrahedraP3", "i", "hr"),
    116: ("GmfHOSolAtPyramidsP1", "i", "hr"),
    117: ("GmfHOSolAtPyramidsP2", "i", "hr"),
    118: ("GmfHOSolAtPyramidsP3", "i", "hr"),
    119: ("GmfHOSolAtPrismsP1", "i", "hr"),
    120: ("GmfHOSolAtPrismsP2", "i", "hr"),
    121: ("GmfHOSolAtPrismsP3", "i", "hr"),
    122: ("GmfHOSolAtHexahedraQ1", "i", "hr"),
    123: ("GmfHOSolAtHexahedraQ2", "i", "hr"),
    124: ("GmfHOSolAtHexahedraQ3", "i", "hr"),
    125: ("GmfBezierBasis", "", "i"),
    126: ("GmfByteFlow", "i", "i"),
    127: ("GmfEdgesP2Ordering", "i", "i"),
    128: ("GmfEdgesP3Ordering", "i", "i"),
    129: ("GmfTrianglesP2Ordering", "i", "iii"),
    130: ("GmfTrianglesP3Ordering", "i", "iii"),
    131: ("GmfQuadrilateralsQ2Ordering", "i", "ii"),
    132: ("GmfQuadrilateralsQ3Ordering", "i", "ii"),
    133: ("GmfTetrahedraP2Ordering", "i", "iiii"),
    134: ("GmfTetrahedraP3Ordering", "i", "iiii"),
    135: ("GmfPyramidsP2Ordering", "i", "iii"),
    136: ("GmfPyramidsP3Ordering", "i", "iii"),
    137: ("GmfPrismsP2Ordering", "i", "iiii"),
    138: ("GmfPrismsP3Ordering", "i", "iiii"),
    139: ("GmfHexahedraQ2Ordering", "i", "iii"),
    140: ("GmfHexahedraQ3Ordering", "i", "iii"),
    141: ("GmfEdgesP1Ordering", "i", "i"),
    142: ("GmfEdgesP4Ordering", "i", "i"),
    143: ("GmfTrianglesP1Ordering", "i", "iii"),
    144: ("GmfTrianglesP4Ordering", "i", "iii"),
    145: ("GmfQuadrilateralsQ1Ordering", "i", "ii"),
    146: ("GmfQuadrilateralsQ4Ordering", "i", "ii"),
    147: ("GmfTetrahedraP1Ordering", "i", "iiii"),
    148: ("GmfTetrahedraP4Ordering", "i", "iiii"),
    149: ("GmfPyramidsP1Ordering", "i", "iii"),
    150: ("GmfPyramidsP4Ordering", "i", "iii"),
    151: ("GmfPrismsP1Ordering", "i", "iiii"),
    152: ("GmfPrismsP4Ordering", "i", "iiii"),
    153: ("GmfHexahedraQ1Ordering", "i", "iii"),
    154: ("GmfHexahedraQ4Ordering", "i", "iii"),
    155: ("GmfFloatingPointPrecision", "", "i"),
    156: ("GmfHOSolAtEdgesP4", "i", "hr"),
    157: ("GmfHOSolAtTrianglesP4", "i", "hr"),
    158: ("GmfHOSolAtQuadrilateralsQ4", "i", "hr"),
    159: ("GmfHOSolAtTetrahedraP4", "i", "hr"),
    160: ("GmfHOSolAtPyramidsP4", "i", "hr"),
    161: ("GmfHOSolAtPrismsP4", "i", "hr"),
    162: ("GmfHOSolAtHexahedraQ4", "i", "hr"),
    163: ("GmfHOSolAtEdgesP1NodesPositions", "i", "rr"),
    164: ("GmfHOSolAtEdgesP2NodesPositions", "i", "rr"),
    165: ("GmfHOSolAtEdgesP3NodesPositions", "i", "rr"),
    166: ("GmfHOSolAtEdgesP4NodesPositions", "i", "rr"),
    167: ("GmfHOSolAtTrianglesP1NodesPositions", "i", "rrr"),
    168: ("GmfHOSolAtTrianglesP2NodesPositions", "i", "rrr"),
    169: ("GmfHOSolAtTrianglesP3NodesPositions", "i", "rrr"),
    170: ("GmfHOSolAtTrianglesP4NodesPositions", "i", "rrr"),
    171: ("GmfHOSolAtQuadrilateralsQ1NodesPositions", "i", "rr"),
    172: ("GmfHOSolAtQuadrilateralsQ2NodesPositions", "i", "rr"),
    173: ("GmfHOSolAtQuadrilateralsQ3NodesPositions", "i", "rr"),
    174: ("GmfHOSolAtQuadrilateralsQ4NodesPositions", "i", "rr"),
    175: ("GmfHOSolAtTetrahedraP1NodesPositions", "i", "rrrr"),
    176: ("GmfHOSolAtTetrahedraP2NodesPositions", "i", "rrrr"),
    177: ("GmfHOSolAtTetrahedraP3NodesPositions", "i", "rrrr"),
    178: ("GmfHOSolAtTetrahedraP4NodesPositions", "i", "rrrr"),
    179: ("GmfHOSolAtPyramidsP1NodesPositions", "i", "rrr"),
    180: ("GmfHOSolAtPyramidsP2NodesPositions", "i", "rrr"),
    181: ("GmfHOSolAtPyramidsP3NodesPositions", "i", "rrr"),
    182: ("GmfHOSolAtPyramidsP4NodesPositions", "i", "rrr"),
    183: ("GmfHOSolAtPrismsP1NodesPositions", "i", "rrrr"),
    184: ("GmfHOSolAtPrismsP2NodesPositions", "i", "rrrr"),
    185: ("GmfHOSolAtPrismsP3NodesPositions", "i", "rrrr"),
    186: ("GmfHOSolAtPrismsP4NodesPositions", "i", "rrrr"),
    187: ("GmfHOSolAtHexahedraQ1NodesPositions", "i", "rrr"),
    188: ("GmfHOSolAtHexahedraQ2NodesPositions", "i", "rrr"),
    189: ("GmfHOSolAtHexahedraQ3NodesPositions", "i", "rrr"),
    190: ("GmfHOSolAtHexahedraQ4NodesPositions", "i", "rrr"),
    191: ("GmfEdgesReferenceElement", "", "rr"),
    192: ("GmfTriangleReferenceElement", "", "rrrrrr"),
    193: ("GmfQuadrilateralReferenceElement", "", "rrrrrrrr"),
    194: ("GmfTetrahedronReferenceElement", "", "rrrrrrrrrrrr"),
    195: ("GmfPyramidReferenceElement", "", "rrrrrrrrrrrrrrr"),
    196: ("GmfPrismReferenceElement", "", "rrrrrrrrrrrrrrrrrr"),
    197: ("GmfHexahedronReferenceElement", "", "rrrrrrrrrrrrrrrrrrrrrrrr"),
    198: ("GmfBoundaryLayers", "i", "iii"),
}
