# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.web.aio import WebSiteManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebSiteManagementAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebSiteManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_publishing_user(self, resource_group):
        response = await self.client.get_publishing_user(
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_update_publishing_user(self, resource_group):
        response = await self.client.update_publishing_user(
            user_details={
                "id": "str",
                "kind": "str",
                "name": "str",
                "publishingPassword": "str",
                "publishingPasswordHash": "str",
                "publishingPasswordHashSalt": "str",
                "publishingUserName": "str",
                "scmUri": "str",
                "type": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_source_controls(self, resource_group):
        response = self.client.list_source_controls(
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_source_control(self, resource_group):
        response = await self.client.get_source_control(
            source_control_type="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_update_source_control(self, resource_group):
        response = await self.client.update_source_control(
            source_control_type="str",
            request_message={
                "expirationTime": "2020-02-20 00:00:00",
                "id": "str",
                "kind": "str",
                "name": "str",
                "refreshToken": "str",
                "token": "str",
                "tokenSecret": "str",
                "type": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_billing_meters(self, resource_group):
        response = self.client.list_billing_meters(
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_check_name_availability(self, resource_group):
        response = await self.client.check_name_availability(
            name="str",
            type="str",
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_custom_host_name_sites(self, resource_group):
        response = self.client.list_custom_host_name_sites(
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_subscription_deployment_locations(self, resource_group):
        response = await self.client.get_subscription_deployment_locations(
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_ase_regions(self, resource_group):
        response = self.client.list_ase_regions(
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_geo_regions(self, resource_group):
        response = self.client.list_geo_regions(
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_site_identifiers_assigned_to_host_name(self, resource_group):
        response = self.client.list_site_identifiers_assigned_to_host_name(
            name_identifier={"name": "str"},
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_premier_add_on_offers(self, resource_group):
        response = self.client.list_premier_add_on_offers(
            api_version="2024-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_skus(self, resource_group):
        response = await self.client.list_skus(
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_verify_hosting_environment_vnet(self, resource_group):
        response = await self.client.verify_hosting_environment_vnet(
            parameters={
                "id": "str",
                "kind": "str",
                "name": "str",
                "subnetResourceId": "str",
                "type": "str",
                "vnetName": "str",
                "vnetResourceGroup": "str",
                "vnetSubnetName": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_move(self, resource_group):
        response = await self.client.move(
            resource_group_name=resource_group.name,
            move_resource_envelope={"resources": ["str"], "targetResourceGroup": "str"},
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_validate(self, resource_group):
        response = await self.client.validate(
            resource_group_name=resource_group.name,
            validate_request={
                "location": "str",
                "name": "str",
                "type": "str",
                "appServiceEnvironment": {
                    "virtualNetwork": {"id": "str", "name": "str", "subnet": "str", "type": "str"},
                    "clusterSettings": [{"name": "str", "value": "str"}],
                    "customDnsSuffixConfiguration": {
                        "certificateUrl": "str",
                        "dnsSuffix": "str",
                        "id": "str",
                        "keyVaultReferenceIdentity": "str",
                        "kind": "str",
                        "name": "str",
                        "provisioningDetails": "str",
                        "provisioningState": "str",
                        "type": "str",
                    },
                    "dedicatedHostCount": 0,
                    "dnsSuffix": "str",
                    "frontEndScaleFactor": 0,
                    "hasLinuxWorkers": bool,
                    "internalLoadBalancingMode": "str",
                    "ipsslAddressCount": 0,
                    "maximumNumberOfMachines": 0,
                    "multiRoleCount": 0,
                    "multiSize": "str",
                    "networkingConfiguration": {
                        "allowNewPrivateEndpointConnections": bool,
                        "externalInboundIpAddresses": ["str"],
                        "ftpEnabled": bool,
                        "id": "str",
                        "inboundIpAddressOverride": "str",
                        "internalInboundIpAddresses": ["str"],
                        "kind": "str",
                        "linuxOutboundIpAddresses": ["str"],
                        "name": "str",
                        "remoteDebugEnabled": bool,
                        "type": "str",
                        "windowsOutboundIpAddresses": ["str"],
                    },
                    "provisioningState": "str",
                    "status": "str",
                    "suspended": bool,
                    "upgradeAvailability": "str",
                    "upgradePreference": "None",
                    "userWhitelistedIpRanges": ["str"],
                    "zoneRedundant": bool,
                },
                "capacity": 0,
                "containerImagePlatform": "str",
                "containerImageRepository": "str",
                "containerImageTag": "str",
                "containerRegistryBaseUrl": "str",
                "containerRegistryPassword": "str",
                "containerRegistryUsername": "str",
                "hostingEnvironment": "str",
                "isSpot": bool,
                "isXenon": bool,
                "needLinuxWorkers": bool,
                "serverFarmId": "str",
                "skuName": "str",
            },
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_validate_move(self, resource_group):
        response = await self.client.validate_move(
            resource_group_name=resource_group.name,
            move_resource_envelope={"resources": ["str"], "targetResourceGroup": "str"},
            api_version="2024-04-01",
        )

        # please add some check logic here by yourself
        # ...
