# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CheckNameAvailabilityRequest(_serialization.Model):
    """The check availability request body.

    :ivar name: The name of the resource for which availability needs to be checked.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: The name of the resource for which availability needs to be checked.
        :paramtype name: str
        :keyword type: The resource type.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class CheckNameAvailabilityResponse(_serialization.Model):
    """Response for whether the requested resource name is available or not.

    :ivar name_available: Returns true or false depending on the availability of the name.
    :vartype name_available: bool
    :ivar reason: Reason for why value is not available. This field is returned if nameAvailable is
     false.
    :vartype reason: str
    :ivar message: Gets an error message explaining the 'reason' value with more details. This
     field is returned iif nameAvailable is false.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Returns true or false depending on the availability of the name.
        :paramtype name_available: bool
        :keyword reason: Reason for why value is not available. This field is returned if nameAvailable
         is false.
        :paramtype reason: str
        :keyword message: Gets an error message explaining the 'reason' value with more details. This
         field is returned iif nameAvailable is false.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class Diagnostic(_serialization.Model):
    """Properties returned with in an insight.

    :ivar solution_id: Solution Id.
    :vartype solution_id: str
    :ivar status: Denotes the status of the diagnostic resource. Known values are: "Failed",
     "MissingInputs", "Running", "Succeeded", and "Timeout".
    :vartype status: str or ~azure.mgmt.selfhelp.models.Status
    :ivar insights: The problems (if any) detected by this insight.
    :vartype insights: list[~azure.mgmt.selfhelp.models.Insight]
    :ivar error: Error definition.
    :vartype error: ~azure.mgmt.selfhelp.models.Error
    """

    _attribute_map = {
        "solution_id": {"key": "solutionId", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "insights": {"key": "insights", "type": "[Insight]"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        solution_id: Optional[str] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        insights: Optional[List["_models.Insight"]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id.
        :paramtype solution_id: str
        :keyword status: Denotes the status of the diagnostic resource. Known values are: "Failed",
         "MissingInputs", "Running", "Succeeded", and "Timeout".
        :paramtype status: str or ~azure.mgmt.selfhelp.models.Status
        :keyword insights: The problems (if any) detected by this insight.
        :paramtype insights: list[~azure.mgmt.selfhelp.models.Insight]
        :keyword error: Error definition.
        :paramtype error: ~azure.mgmt.selfhelp.models.Error
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.status = status
        self.insights = insights
        self.error = error


class DiagnosticInvocation(_serialization.Model):
    """Solution Invocation with additional params needed for invocation.

    :ivar solution_id: Solution Id to invoke.
    :vartype solution_id: str
    :ivar additional_parameters: Additional parameters required to invoke the solutionId.
    :vartype additional_parameters: dict[str, str]
    """

    _attribute_map = {
        "solution_id": {"key": "solutionId", "type": "str"},
        "additional_parameters": {"key": "additionalParameters", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        solution_id: Optional[str] = None,
        additional_parameters: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id to invoke.
        :paramtype solution_id: str
        :keyword additional_parameters: Additional parameters required to invoke the solutionId.
        :paramtype additional_parameters: dict[str, str]
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.additional_parameters = additional_parameters


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class DiagnosticResource(ProxyResource):
    """Diagnostic resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar global_parameters: Global parameters that can be passed to all solutionIds.
    :vartype global_parameters: dict[str, str]
    :ivar insights: SolutionIds that are needed to be invoked.
    :vartype insights: list[~azure.mgmt.selfhelp.models.DiagnosticInvocation]
    :ivar accepted_at: Diagnostic Request Accepted time.
    :vartype accepted_at: str
    :ivar provisioning_state: Status of diagnostic provisioning. Known values are: "Succeeded",
     "PartialComplete", "Failed", and "Canceled".
    :vartype provisioning_state: str or ~azure.mgmt.selfhelp.models.ProvisioningState
    :ivar diagnostics: Array of Diagnostics.
    :vartype diagnostics: list[~azure.mgmt.selfhelp.models.Diagnostic]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "accepted_at": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "diagnostics": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "global_parameters": {"key": "properties.globalParameters", "type": "{str}"},
        "insights": {"key": "properties.insights", "type": "[DiagnosticInvocation]"},
        "accepted_at": {"key": "properties.acceptedAt", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "diagnostics": {"key": "properties.diagnostics", "type": "[Diagnostic]"},
    }

    def __init__(
        self,
        *,
        global_parameters: Optional[Dict[str, str]] = None,
        insights: Optional[List["_models.DiagnosticInvocation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword global_parameters: Global parameters that can be passed to all solutionIds.
        :paramtype global_parameters: dict[str, str]
        :keyword insights: SolutionIds that are needed to be invoked.
        :paramtype insights: list[~azure.mgmt.selfhelp.models.DiagnosticInvocation]
        """
        super().__init__(**kwargs)
        self.global_parameters = global_parameters
        self.insights = insights
        self.accepted_at = None
        self.provisioning_state = None
        self.diagnostics = None


class DiscoveryResponse(_serialization.Model):
    """Discovery response.

    :ivar value: The list of solution metadata.
    :vartype value: list[~azure.mgmt.selfhelp.models.SolutionMetadataResource]
    :ivar next_link: The link used to get the next page of solution metadata.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SolutionMetadataResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SolutionMetadataResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of solution metadata.
        :paramtype value: list[~azure.mgmt.selfhelp.models.SolutionMetadataResource]
        :keyword next_link: The link used to get the next page of solution metadata.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Error(_serialization.Model):
    """Error definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Service specific error code which serves as the substatus for the HTTP error code.
    :vartype code: str
    :ivar type: Service specific error type which serves as additional context for the error
     herein.
    :vartype type: str
    :ivar message: Description of the error.
    :vartype message: str
    :ivar details: An array of additional nested error response info objects, as described by this
     contract.
    :vartype details: list[~azure.mgmt.selfhelp.models.Error]
    """

    _validation = {
        "code": {"readonly": True},
        "type": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[Error]"},
    }

    def __init__(self, *, details: Optional[List["_models.Error"]] = None, **kwargs: Any) -> None:
        """
        :keyword details: An array of additional nested error response info objects, as described by
         this contract.
        :paramtype details: list[~azure.mgmt.selfhelp.models.Error]
        """
        super().__init__(**kwargs)
        self.code = None
        self.type = None
        self.message = None
        self.details = details


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.selfhelp.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.selfhelp.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.selfhelp.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.selfhelp.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class Insight(_serialization.Model):
    """Detailed insights(s) obtained via the invocation of an insight diagnostic troubleshooter.

    :ivar id: Article id.
    :vartype id: str
    :ivar title: This insight's title.
    :vartype title: str
    :ivar results: Detailed result content.
    :vartype results: str
    :ivar importance_level: Importance level of the insight. Known values are: "Critical",
     "Warning", and "Information".
    :vartype importance_level: str or ~azure.mgmt.selfhelp.models.ImportanceLevel
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "title": {"key": "title", "type": "str"},
        "results": {"key": "results", "type": "str"},
        "importance_level": {"key": "importanceLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        title: Optional[str] = None,
        results: Optional[str] = None,
        importance_level: Optional[Union[str, "_models.ImportanceLevel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Article id.
        :paramtype id: str
        :keyword title: This insight's title.
        :paramtype title: str
        :keyword results: Detailed result content.
        :paramtype results: str
        :keyword importance_level: Importance level of the insight. Known values are: "Critical",
         "Warning", and "Information".
        :paramtype importance_level: str or ~azure.mgmt.selfhelp.models.ImportanceLevel
        """
        super().__init__(**kwargs)
        self.id = id
        self.title = title
        self.results = results
        self.importance_level = importance_level


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.selfhelp.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.selfhelp.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.selfhelp.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.selfhelp.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.selfhelp.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SolutionMetadataResource(ProxyResource):
    """Solution Metadata resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.selfhelp.models.SystemData
    :ivar solution_id: Solution Id.
    :vartype solution_id: str
    :ivar solution_type: Solution Type.
    :vartype solution_type: str
    :ivar description: A detailed description of solution.
    :vartype description: str
    :ivar required_parameter_sets: Required parameters for invoking this particular solution.
    :vartype required_parameter_sets: list[list[str]]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "solution_id": {"key": "properties.solutionId", "type": "str"},
        "solution_type": {"key": "properties.solutionType", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "required_parameter_sets": {"key": "properties.requiredParameterSets", "type": "[[str]]"},
    }

    def __init__(
        self,
        *,
        solution_id: Optional[str] = None,
        solution_type: Optional[str] = None,
        description: Optional[str] = None,
        required_parameter_sets: Optional[List[List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword solution_id: Solution Id.
        :paramtype solution_id: str
        :keyword solution_type: Solution Type.
        :paramtype solution_type: str
        :keyword description: A detailed description of solution.
        :paramtype description: str
        :keyword required_parameter_sets: Required parameters for invoking this particular solution.
        :paramtype required_parameter_sets: list[list[str]]
        """
        super().__init__(**kwargs)
        self.solution_id = solution_id
        self.solution_type = solution_type
        self.description = description
        self.required_parameter_sets = required_parameter_sets


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.selfhelp.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.selfhelp.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.selfhelp.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.selfhelp.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
