# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ...operations._operations import (
    build_job_router_accept_job_action_request,
    build_job_router_administration_delete_classification_policy_request,
    build_job_router_administration_delete_distribution_policy_request,
    build_job_router_administration_delete_exception_policy_request,
    build_job_router_administration_delete_queue_request,
    build_job_router_administration_get_classification_policy_request,
    build_job_router_administration_get_distribution_policy_request,
    build_job_router_administration_get_exception_policy_request,
    build_job_router_administration_get_queue_request,
    build_job_router_administration_list_classification_policies_request,
    build_job_router_administration_list_distribution_policies_request,
    build_job_router_administration_list_exception_policies_request,
    build_job_router_administration_list_queues_request,
    build_job_router_administration_upsert_classification_policy_request,
    build_job_router_administration_upsert_distribution_policy_request,
    build_job_router_administration_upsert_exception_policy_request,
    build_job_router_administration_upsert_queue_request,
    build_job_router_cancel_job_action_request,
    build_job_router_close_job_action_request,
    build_job_router_complete_job_action_request,
    build_job_router_decline_job_action_request,
    build_job_router_delete_job_request,
    build_job_router_delete_worker_request,
    build_job_router_get_in_queue_position_request,
    build_job_router_get_job_request,
    build_job_router_get_queue_statistics_request,
    build_job_router_get_worker_request,
    build_job_router_list_jobs_request,
    build_job_router_list_workers_request,
    build_job_router_reclassify_job_action_request,
    build_job_router_unassign_job_action_request,
    build_job_router_upsert_job_request,
    build_job_router_upsert_worker_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class JobRouterAdministrationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.jobrouter.aio.AzureCommunicationJobRouterService`'s
        :attr:`job_router_administration` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def upsert_classification_policy(
        self,
        id: str,
        patch: _models.ClassificationPolicy,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.ClassificationPolicy:
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param id: Id of the classification policy. Required.
        :type id: str
        :param patch: Model of classification policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: ~azure.communication.jobrouter.models.ClassificationPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: ClassificationPolicy
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def upsert_classification_policy(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.ClassificationPolicy:
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param id: Id of the classification policy. Required.
        :type id: str
        :param patch: Model of classification policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: ClassificationPolicy
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def upsert_classification_policy(
        self, id: str, patch: Union[_models.ClassificationPolicy, IO], **kwargs: Any
    ) -> _models.ClassificationPolicy:
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param id: Id of the classification policy. Required.
        :type id: str
        :param patch: Model of classification policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a ClassificationPolicy type or a IO
         type. Required.
        :type patch: ~azure.communication.jobrouter.models.ClassificationPolicy or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: ClassificationPolicy
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ClassificationPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = self._serialize.body(patch, "ClassificationPolicy")

        request = build_job_router_administration_upsert_classification_policy_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ClassificationPolicy", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ClassificationPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_classification_policy(self, id: str, **kwargs: Any) -> _models.ClassificationPolicy:
        """Retrieves an existing classification policy by Id.

        Retrieves an existing classification policy by Id.

        :param id: Id of the classification policy. Required.
        :type id: str
        :return: ClassificationPolicy
        :rtype: ~azure.communication.jobrouter.models.ClassificationPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ClassificationPolicy] = kwargs.pop("cls", None)

        request = build_job_router_administration_get_classification_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ClassificationPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def delete_classification_policy(  # pylint: disable=inconsistent-return-statements
        self, id: str, **kwargs: Any
    ) -> None:
        """Delete a classification policy by Id.

        Delete a classification policy by Id.

        :param id: Id of the classification policy. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_administration_delete_classification_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_classification_policies(self, **kwargs: Any) -> AsyncIterable["_models.ClassificationPolicyItem"]:
        """Retrieves existing classification policies.

        Retrieves existing classification policies.

        :return: An iterator like instance of ClassificationPolicyItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.communication.jobrouter.models.ClassificationPolicyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.ClassificationPolicyCollection] = kwargs.pop(  # pylint: disable=protected-access
            "cls", None
        )

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_administration_list_classification_policies_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.ClassificationPolicyCollection, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def upsert_distribution_policy(
        self,
        id: str,
        patch: _models.DistributionPolicy,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.DistributionPolicy:
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :param patch: Model of distribution policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: ~azure.communication.jobrouter.models.DistributionPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: DistributionPolicy
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def upsert_distribution_policy(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.DistributionPolicy:
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :param patch: Model of distribution policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: DistributionPolicy
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def upsert_distribution_policy(
        self, id: str, patch: Union[_models.DistributionPolicy, IO], **kwargs: Any
    ) -> _models.DistributionPolicy:
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :param patch: Model of distribution policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a DistributionPolicy type or a IO
         type. Required.
        :type patch: ~azure.communication.jobrouter.models.DistributionPolicy or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: DistributionPolicy
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.DistributionPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = self._serialize.body(patch, "DistributionPolicy")

        request = build_job_router_administration_upsert_distribution_policy_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("DistributionPolicy", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("DistributionPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_distribution_policy(self, id: str, **kwargs: Any) -> _models.DistributionPolicy:
        """Retrieves an existing distribution policy by Id.

        Retrieves an existing distribution policy by Id.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :return: DistributionPolicy
        :rtype: ~azure.communication.jobrouter.models.DistributionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.DistributionPolicy] = kwargs.pop("cls", None)

        request = build_job_router_administration_get_distribution_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("DistributionPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def delete_distribution_policy(  # pylint: disable=inconsistent-return-statements
        self, id: str, **kwargs: Any
    ) -> None:
        """Delete a distribution policy by Id.

        Delete a distribution policy by Id.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_administration_delete_distribution_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_distribution_policies(self, **kwargs: Any) -> AsyncIterable["_models.DistributionPolicyItem"]:
        """Retrieves existing distribution policies.

        Retrieves existing distribution policies.

        :return: An iterator like instance of DistributionPolicyItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.communication.jobrouter.models.DistributionPolicyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.DistributionPolicyCollection] = kwargs.pop(  # pylint: disable=protected-access
            "cls", None
        )

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_administration_list_distribution_policies_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.DistributionPolicyCollection, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def upsert_exception_policy(
        self,
        id: str,
        patch: _models.ExceptionPolicy,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.ExceptionPolicy:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param id: Id of the exception policy. Required.
        :type id: str
        :param patch: Model of exception policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: ~azure.communication.jobrouter.models.ExceptionPolicy
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: ExceptionPolicy
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def upsert_exception_policy(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.ExceptionPolicy:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param id: Id of the exception policy. Required.
        :type id: str
        :param patch: Model of exception policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: ExceptionPolicy
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def upsert_exception_policy(
        self, id: str, patch: Union[_models.ExceptionPolicy, IO], **kwargs: Any
    ) -> _models.ExceptionPolicy:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param id: Id of the exception policy. Required.
        :type id: str
        :param patch: Model of exception policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a ExceptionPolicy type or a IO type.
         Required.
        :type patch: ~azure.communication.jobrouter.models.ExceptionPolicy or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: ExceptionPolicy
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.ExceptionPolicy] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = self._serialize.body(patch, "ExceptionPolicy")

        request = build_job_router_administration_upsert_exception_policy_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("ExceptionPolicy", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("ExceptionPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_exception_policy(self, id: str, **kwargs: Any) -> _models.ExceptionPolicy:
        """Retrieves an existing exception policy by Id.

        Retrieves an existing exception policy by Id.

        :param id: Id of the exception policy to retrieve. Required.
        :type id: str
        :return: ExceptionPolicy
        :rtype: ~azure.communication.jobrouter.models.ExceptionPolicy
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.ExceptionPolicy] = kwargs.pop("cls", None)

        request = build_job_router_administration_get_exception_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("ExceptionPolicy", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def delete_exception_policy(  # pylint: disable=inconsistent-return-statements
        self, id: str, **kwargs: Any
    ) -> None:
        """Deletes a exception policy by Id.

        Deletes a exception policy by Id.

        :param id: Id of the exception policy to delete. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_administration_delete_exception_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_exception_policies(self, **kwargs: Any) -> AsyncIterable["_models.ExceptionPolicyItem"]:
        """Retrieves existing exception policies.

        Retrieves existing exception policies.

        :return: An iterator like instance of ExceptionPolicyItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.communication.jobrouter.models.ExceptionPolicyItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.ExceptionPolicyCollection] = kwargs.pop(  # pylint: disable=protected-access
            "cls", None
        )

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_administration_list_exception_policies_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.ExceptionPolicyCollection, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def upsert_queue(
        self, id: str, patch: _models.RouterQueue, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.RouterQueue:
        """Creates or updates a queue.

        Creates or updates a queue.

        :param id: Id of the queue. Required.
        :type id: str
        :param patch: Model of queue properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: ~azure.communication.jobrouter.models.RouterQueue
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: RouterQueue
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def upsert_queue(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.RouterQueue:
        """Creates or updates a queue.

        Creates or updates a queue.

        :param id: Id of the queue. Required.
        :type id: str
        :param patch: Model of queue properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: RouterQueue
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def upsert_queue(self, id: str, patch: Union[_models.RouterQueue, IO], **kwargs: Any) -> _models.RouterQueue:
        """Creates or updates a queue.

        Creates or updates a queue.

        :param id: Id of the queue. Required.
        :type id: str
        :param patch: Model of queue properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a RouterQueue type or a IO type.
         Required.
        :type patch: ~azure.communication.jobrouter.models.RouterQueue or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: RouterQueue
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouterQueue] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = self._serialize.body(patch, "RouterQueue")

        request = build_job_router_administration_upsert_queue_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RouterQueue", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RouterQueue", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_queue(self, id: str, **kwargs: Any) -> _models.RouterQueue:
        """Retrieves an existing queue by Id.

        Retrieves an existing queue by Id.

        :param id: Id of the queue to retrieve. Required.
        :type id: str
        :return: RouterQueue
        :rtype: ~azure.communication.jobrouter.models.RouterQueue
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterQueue] = kwargs.pop("cls", None)

        request = build_job_router_administration_get_queue_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouterQueue", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def delete_queue(self, id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a queue by Id.

        Deletes a queue by Id.

        :param id: Id of the queue to delete. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_administration_delete_queue_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_queues(self, **kwargs: Any) -> AsyncIterable["_models.RouterQueueItem"]:
        """Retrieves existing queues.

        Retrieves existing queues.

        :return: An iterator like instance of RouterQueueItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.communication.jobrouter.models.RouterQueueItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.RouterQueueCollection] = kwargs.pop(  # pylint: disable=protected-access
            "cls", None
        )

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_administration_list_queues_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.RouterQueueCollection, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class JobRouterOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.jobrouter.aio.AzureCommunicationJobRouterService`'s
        :attr:`job_router` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def upsert_job(
        self, id: str, patch: _models.RouterJob, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.RouterJob:
        """Creates or updates a router job.

        Creates or updates a router job.

        :param id: Id of the job. Required.
        :type id: str
        :param patch: Model of job properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: ~azure.communication.jobrouter.models.RouterJob
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: RouterJob
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def upsert_job(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.RouterJob:
        """Creates or updates a router job.

        Creates or updates a router job.

        :param id: Id of the job. Required.
        :type id: str
        :param patch: Model of job properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: RouterJob
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def upsert_job(self, id: str, patch: Union[_models.RouterJob, IO], **kwargs: Any) -> _models.RouterJob:
        """Creates or updates a router job.

        Creates or updates a router job.

        :param id: Id of the job. Required.
        :type id: str
        :param patch: Model of job properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a RouterJob type or a IO type.
         Required.
        :type patch: ~azure.communication.jobrouter.models.RouterJob or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: RouterJob
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouterJob] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = self._serialize.body(patch, "RouterJob")

        request = build_job_router_upsert_job_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RouterJob", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RouterJob", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_job(self, id: str, **kwargs: Any) -> _models.RouterJob:
        """Retrieves an existing job by Id.

        Retrieves an existing job by Id.

        :param id: Id of the job to retrieve. Required.
        :type id: str
        :return: RouterJob
        :rtype: ~azure.communication.jobrouter.models.RouterJob
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterJob] = kwargs.pop("cls", None)

        request = build_job_router_get_job_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouterJob", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def delete_job(self, id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a job and all of its traces.

        Deletes a job and all of its traces.

        :param id: Id of the job. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_delete_job_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def reclassify_job_action(
        self, id: str, reclassify_job_request: Optional[JSON] = None, **kwargs: Any
    ) -> JSON:
        """Reclassify a job.

        Reclassify a job.

        :param id: Id of the job. Required.
        :type id: str
        :param reclassify_job_request: Request object for reclassifying a job. Default value is None.
        :type reclassify_job_request: JSON
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        if reclassify_job_request is not None:
            _json = self._serialize.body(reclassify_job_request, "object")
        else:
            _json = None

        request = build_job_router_reclassify_job_action_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    async def cancel_job_action(
        self,
        id: str,
        cancel_job_request: Optional[_models.CancelJobRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        :param id: Id of the job. Required.
        :type id: str
        :param cancel_job_request: Request model for cancelling job. Default value is None.
        :type cancel_job_request: ~azure.communication.jobrouter.models.CancelJobRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def cancel_job_action(
        self, id: str, cancel_job_request: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        :param id: Id of the job. Required.
        :type id: str
        :param cancel_job_request: Request model for cancelling job. Default value is None.
        :type cancel_job_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def cancel_job_action(
        self, id: str, cancel_job_request: Optional[Union[_models.CancelJobRequest, IO]] = None, **kwargs: Any
    ) -> JSON:
        """Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        :param id: Id of the job. Required.
        :type id: str
        :param cancel_job_request: Request model for cancelling job. Is either a CancelJobRequest type
         or a IO type. Default value is None.
        :type cancel_job_request: ~azure.communication.jobrouter.models.CancelJobRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(cancel_job_request, (IOBase, bytes)):
            _content = cancel_job_request
        else:
            if cancel_job_request is not None:
                _json = self._serialize.body(cancel_job_request, "CancelJobRequest")
            else:
                _json = None

        request = build_job_router_cancel_job_action_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    async def complete_job_action(
        self,
        id: str,
        complete_job_request: _models.CompleteJobRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Completes an assigned job.

        Completes an assigned job.

        :param id: Id of the job. Required.
        :type id: str
        :param complete_job_request: Request model for completing job. Required.
        :type complete_job_request: ~azure.communication.jobrouter.models.CompleteJobRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def complete_job_action(
        self, id: str, complete_job_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Completes an assigned job.

        Completes an assigned job.

        :param id: Id of the job. Required.
        :type id: str
        :param complete_job_request: Request model for completing job. Required.
        :type complete_job_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def complete_job_action(
        self, id: str, complete_job_request: Union[_models.CompleteJobRequest, IO], **kwargs: Any
    ) -> JSON:
        """Completes an assigned job.

        Completes an assigned job.

        :param id: Id of the job. Required.
        :type id: str
        :param complete_job_request: Request model for completing job. Is either a CompleteJobRequest
         type or a IO type. Required.
        :type complete_job_request: ~azure.communication.jobrouter.models.CompleteJobRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(complete_job_request, (IOBase, bytes)):
            _content = complete_job_request
        else:
            _json = self._serialize.body(complete_job_request, "CompleteJobRequest")

        request = build_job_router_complete_job_action_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    async def close_job_action(
        self,
        id: str,
        close_job_request: _models.CloseJobRequest,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Closes a completed job.

        Closes a completed job.

        :param id: Id of the job. Required.
        :type id: str
        :param close_job_request: Request model for closing job. Required.
        :type close_job_request: ~azure.communication.jobrouter.models.CloseJobRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def close_job_action(
        self, id: str, close_job_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Closes a completed job.

        Closes a completed job.

        :param id: Id of the job. Required.
        :type id: str
        :param close_job_request: Request model for closing job. Required.
        :type close_job_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def close_job_action(
        self, id: str, close_job_request: Union[_models.CloseJobRequest, IO], **kwargs: Any
    ) -> JSON:
        """Closes a completed job.

        Closes a completed job.

        :param id: Id of the job. Required.
        :type id: str
        :param close_job_request: Request model for closing job. Is either a CloseJobRequest type or a
         IO type. Required.
        :type close_job_request: ~azure.communication.jobrouter.models.CloseJobRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(close_job_request, (IOBase, bytes)):
            _content = close_job_request
        else:
            _json = self._serialize.body(close_job_request, "CloseJobRequest")

        request = build_job_router_close_job_action_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("object", pipeline_response)

        if response.status_code == 202:
            deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_jobs(
        self,
        *,
        status: Union[str, _models.RouterJobStatusSelector] = "all",
        queue_id: Optional[str] = None,
        channel_id: Optional[str] = None,
        classification_policy_id: Optional[str] = None,
        scheduled_before: Optional[datetime.datetime] = None,
        scheduled_after: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RouterJobItem"]:
        """Retrieves list of jobs based on filter parameters.

        Retrieves list of jobs based on filter parameters.

        :keyword status: If specified, filter jobs by status. Known values are: "all",
         "pendingClassification", "queued", "assigned", "completed", "closed", "cancelled",
         "classificationFailed", "created", "pendingSchedule", "scheduled", "scheduleFailed",
         "waitingForActivation", and "active". Default value is "all".
        :paramtype status: str or ~azure.communication.jobrouter.models.RouterJobStatusSelector
        :keyword queue_id: If specified, filter jobs by queue. Default value is None.
        :paramtype queue_id: str
        :keyword channel_id: If specified, filter jobs by channel. Default value is None.
        :paramtype channel_id: str
        :keyword classification_policy_id: If specified, filter jobs by classificationPolicy. Default
         value is None.
        :paramtype classification_policy_id: str
        :keyword scheduled_before: If specified, filter on jobs that was scheduled before or at given
         timestamp. Range: (-Inf, scheduledBefore]. Default value is None.
        :paramtype scheduled_before: ~datetime.datetime
        :keyword scheduled_after: If specified, filter on jobs that was scheduled at or after given
         value. Range: [scheduledAfter, +Inf). Default value is None.
        :paramtype scheduled_after: ~datetime.datetime
        :return: An iterator like instance of RouterJobItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.communication.jobrouter.models.RouterJobItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.RouterJobCollection] = kwargs.pop("cls", None)  # pylint: disable=protected-access

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_list_jobs_request(
                    status=status,
                    queue_id=queue_id,
                    channel_id=channel_id,
                    classification_policy_id=classification_policy_id,
                    scheduled_before=scheduled_before,
                    scheduled_after=scheduled_after,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.RouterJobCollection, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_in_queue_position(self, id: str, **kwargs: Any) -> _models.RouterJobPositionDetails:
        """Gets a job's position details.

        Gets a job's position details.

        :param id: Id of the job. Required.
        :type id: str
        :return: RouterJobPositionDetails
        :rtype: ~azure.communication.jobrouter.models.RouterJobPositionDetails
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterJobPositionDetails] = kwargs.pop("cls", None)

        request = build_job_router_get_in_queue_position_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouterJobPositionDetails", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    async def unassign_job_action(
        self,
        id: str,
        assignment_id: str,
        unassign_job_request: Optional[_models.UnassignJobRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UnassignJobResult:
        """Un-assign a job.

        Un-assign a job.

        :param id: Id of the job to un-assign. Required.
        :type id: str
        :param assignment_id: Id of the assignment to un-assign. Required.
        :type assignment_id: str
        :param unassign_job_request: Request body for unassign route. Default value is None.
        :type unassign_job_request: ~azure.communication.jobrouter.models.UnassignJobRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UnassignJobResult
        :rtype: ~azure.communication.jobrouter.models.UnassignJobResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def unassign_job_action(
        self,
        id: str,
        assignment_id: str,
        unassign_job_request: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.UnassignJobResult:
        """Un-assign a job.

        Un-assign a job.

        :param id: Id of the job to un-assign. Required.
        :type id: str
        :param assignment_id: Id of the assignment to un-assign. Required.
        :type assignment_id: str
        :param unassign_job_request: Request body for unassign route. Default value is None.
        :type unassign_job_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: UnassignJobResult
        :rtype: ~azure.communication.jobrouter.models.UnassignJobResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def unassign_job_action(
        self,
        id: str,
        assignment_id: str,
        unassign_job_request: Optional[Union[_models.UnassignJobRequest, IO]] = None,
        **kwargs: Any
    ) -> _models.UnassignJobResult:
        """Un-assign a job.

        Un-assign a job.

        :param id: Id of the job to un-assign. Required.
        :type id: str
        :param assignment_id: Id of the assignment to un-assign. Required.
        :type assignment_id: str
        :param unassign_job_request: Request body for unassign route. Is either a UnassignJobRequest
         type or a IO type. Default value is None.
        :type unassign_job_request: ~azure.communication.jobrouter.models.UnassignJobRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: UnassignJobResult
        :rtype: ~azure.communication.jobrouter.models.UnassignJobResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.UnassignJobResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(unassign_job_request, (IOBase, bytes)):
            _content = unassign_job_request
        else:
            if unassign_job_request is not None:
                _json = self._serialize.body(unassign_job_request, "UnassignJobRequest")
            else:
                _json = None

        request = build_job_router_unassign_job_action_request(
            id=id,
            assignment_id=assignment_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("UnassignJobResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def accept_job_action(self, worker_id: str, offer_id: str, **kwargs: Any) -> _models.AcceptJobOfferResult:
        """Accepts an offer to work on a job and returns a 409/Conflict if another agent accepted the job
        already.

        Accepts an offer to work on a job and returns a 409/Conflict if another agent accepted the job
        already.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param offer_id: Id of the offer. Required.
        :type offer_id: str
        :return: AcceptJobOfferResult
        :rtype: ~azure.communication.jobrouter.models.AcceptJobOfferResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.AcceptJobOfferResult] = kwargs.pop("cls", None)

        request = build_job_router_accept_job_action_request(
            worker_id=worker_id,
            offer_id=offer_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("AcceptJobOfferResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    async def decline_job_action(
        self,
        worker_id: str,
        offer_id: str,
        decline_job_offer_request: Optional[_models.DeclineJobOfferRequest] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Declines an offer to work on a job.

        Declines an offer to work on a job.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param offer_id: Id of the offer. Required.
        :type offer_id: str
        :param decline_job_offer_request: Request model for declining offer. Default value is None.
        :type decline_job_offer_request: ~azure.communication.jobrouter.models.DeclineJobOfferRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def decline_job_action(
        self,
        worker_id: str,
        offer_id: str,
        decline_job_offer_request: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Declines an offer to work on a job.

        Declines an offer to work on a job.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param offer_id: Id of the offer. Required.
        :type offer_id: str
        :param decline_job_offer_request: Request model for declining offer. Default value is None.
        :type decline_job_offer_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def decline_job_action(
        self,
        worker_id: str,
        offer_id: str,
        decline_job_offer_request: Optional[Union[_models.DeclineJobOfferRequest, IO]] = None,
        **kwargs: Any
    ) -> JSON:
        """Declines an offer to work on a job.

        Declines an offer to work on a job.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param offer_id: Id of the offer. Required.
        :type offer_id: str
        :param decline_job_offer_request: Request model for declining offer. Is either a
         DeclineJobOfferRequest type or a IO type. Default value is None.
        :type decline_job_offer_request: ~azure.communication.jobrouter.models.DeclineJobOfferRequest
         or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(decline_job_offer_request, (IOBase, bytes)):
            _content = decline_job_offer_request
        else:
            if decline_job_offer_request is not None:
                _json = self._serialize.body(decline_job_offer_request, "DeclineJobOfferRequest")
            else:
                _json = None

        request = build_job_router_decline_job_action_request(
            worker_id=worker_id,
            offer_id=offer_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("object", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def get_queue_statistics(self, id: str, **kwargs: Any) -> _models.RouterQueueStatistics:
        """Retrieves a queue's statistics.

        Retrieves a queue's statistics.

        :param id: Id of the queue to retrieve statistics. Required.
        :type id: str
        :return: RouterQueueStatistics
        :rtype: ~azure.communication.jobrouter.models.RouterQueueStatistics
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterQueueStatistics] = kwargs.pop("cls", None)

        request = build_job_router_get_queue_statistics_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouterQueueStatistics", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @overload
    async def upsert_worker(
        self,
        worker_id: str,
        patch: _models.RouterWorker,
        *,
        content_type: str = "application/merge-patch+json",
        **kwargs: Any
    ) -> _models.RouterWorker:
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param patch: Model of worker properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: ~azure.communication.jobrouter.models.RouterWorker
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: RouterWorker
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def upsert_worker(
        self, worker_id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> _models.RouterWorker:
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param patch: Model of worker properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: RouterWorker
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def upsert_worker(
        self, worker_id: str, patch: Union[_models.RouterWorker, IO], **kwargs: Any
    ) -> _models.RouterWorker:
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param patch: Model of worker properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a RouterWorker type or a IO type.
         Required.
        :type patch: ~azure.communication.jobrouter.models.RouterWorker or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: RouterWorker
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.RouterWorker] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = self._serialize.body(patch, "RouterWorker")

        request = build_job_router_upsert_worker_request(
            worker_id=worker_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize("RouterWorker", pipeline_response)

        if response.status_code == 201:
            deserialized = self._deserialize("RouterWorker", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def get_worker(self, worker_id: str, **kwargs: Any) -> _models.RouterWorker:
        """Retrieves an existing worker by Id.

        Retrieves an existing worker by Id.

        :param worker_id: Id of the worker to retrieve. Required.
        :type worker_id: str
        :return: RouterWorker
        :rtype: ~azure.communication.jobrouter.models.RouterWorker
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.RouterWorker] = kwargs.pop("cls", None)

        request = build_job_router_get_worker_request(
            worker_id=worker_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize("RouterWorker", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace_async
    async def delete_worker(  # pylint: disable=inconsistent-return-statements
        self, worker_id: str, **kwargs: Any
    ) -> None:
        """Deletes a worker and all of its traces.

        Deletes a worker and all of its traces.

        :param worker_id: Id of the worker to delete. Required.
        :type worker_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_delete_worker_request(
            worker_id=worker_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_workers(
        self,
        *,
        state: Union[str, _models.RouterWorkerStateSelector] = "all",
        channel_id: Optional[str] = None,
        queue_id: Optional[str] = None,
        has_capacity: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterable["_models.RouterWorkerItem"]:
        """Retrieves existing workers.

        Retrieves existing workers.

        :keyword state: If specified, select workers by worker status. Known values are: "active",
         "draining", "inactive", and "all". Default value is "all".
        :paramtype state: str or ~azure.communication.jobrouter.models.RouterWorkerStateSelector
        :keyword channel_id: If specified, select workers who have a channel configuration with this
         channel. Default value is None.
        :paramtype channel_id: str
        :keyword queue_id: If specified, select workers who are assigned to this queue. Default value
         is None.
        :paramtype queue_id: str
        :keyword has_capacity: If set to true, select only workers who have capacity for the channel
         specified by ``channelId`` or for any channel
                     if ``channelId`` not specified. If set to false, then will return all workers
         including workers without any capacity for jobs. Defaults to false. Default value is None.
        :paramtype has_capacity: bool
        :return: An iterator like instance of RouterWorkerItem
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.communication.jobrouter.models.RouterWorkerItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models._models.RouterWorkerCollection] = kwargs.pop(  # pylint: disable=protected-access
            "cls", None
        )

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_list_workers_request(
                    state=state,
                    channel_id=channel_id,
                    queue_id=queue_id,
                    has_capacity=has_capacity,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize(
                _models._models.RouterWorkerCollection, pipeline_response  # pylint: disable=protected-access
            )
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
