#A* -------------------------------------------------------------------
#B* This file contains source code for the PyMOL computer program
#C* copyright 1998-2000 by Warren Lyford Delano of DeLano Scientific. 
#D* -------------------------------------------------------------------
#E* It is unlawful to modify or remove this copyright notice.
#F* -------------------------------------------------------------------
#G* Please see the accompanying LICENSE file for further information. 
#H* -------------------------------------------------------------------
#I* Additional authors of this source file include:
#-* 
#-* 
#-*
#Z* -------------------------------------------------------------------

normal = {
('ALA'  , '1HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0603 } ,
('ALA'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0603 } ,
('ALA'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0603 } ,
('ALA'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('ALA'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0337 } ,
('ALA'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1825 } ,
('ALA'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('ALA'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0823 } ,
('ALA'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('ALA'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('CYM'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.2440 } ,
('CYM'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.2440 } ,
('CYM'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6160 } ,
('CYM'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0350 } ,
('CYM'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.7360 } ,
('CYM'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2520 } ,
('CYM'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0480 } ,
('CYM'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4630 } ,
('CYM'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5040 } ,
('CYM'  , 'SG'   ) : { 'type' : 'SH'   , 'charge' : -0.7360 } ,
('CYS'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.1112 } ,
('CYS'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.1112 } ,
('CYS'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('CYS'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0213 } ,
('CYS'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1231 } ,
('CYS'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('CYS'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1124 } ,
('CYS'  , 'HG'   ) : { 'type' : 'HS'   , 'charge' :  0.1933 } ,
('CYS'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('CYS'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('CYS'  , 'SG'   ) : { 'type' : 'SH'   , 'charge' : -0.3119 } ,
('CYX'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0910 } ,
('CYX'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0910 } ,
('CYX'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('CYX'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0429 } ,
('CYX'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0790 } ,
('CYX'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('CYX'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0766 } ,
('CYX'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('CYX'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('CYX'  , 'SG'   ) : { 'type' : 'S'    , 'charge' : -0.1081 } ,
('ASP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0122 } ,
('ASP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0122 } ,
('ASP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5366 } ,
('ASP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0381 } ,
('ASP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0303 } ,
('ASP'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.7994 } ,
('ASP'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2936 } ,
('ASP'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0880 } ,
('ASP'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.5163 } ,
('ASP'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5819 } ,
('ASP'  , 'OD1'  ) : { 'type' : 'O2'   , 'charge' : -0.8014 } ,
('ASP'  , 'OD2'  ) : { 'type' : 'O2'   , 'charge' : -0.8014 } ,
('ASH'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0488 } ,
('ASH'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0488 } ,
('ASH'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('ASH'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0341 } ,
('ASH'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0316 } ,
('ASH'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.6462 } ,
('ASH'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('ASH'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0864 } ,
('ASH'  , 'HD2'  ) : { 'type' : 'HO'   , 'charge' :  0.4747 } ,
('ASH'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('ASH'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('ASH'  , 'OD1'  ) : { 'type' : 'O'    , 'charge' : -0.5554 } ,
('ASH'  , 'OD2'  ) : { 'type' : 'OH'   , 'charge' : -0.6376 } ,
('GLU'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0173 } ,
('GLU'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0425 } ,
('GLU'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0173 } ,
('GLU'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0425 } ,
('GLU'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5366 } ,
('GLU'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0397 } ,
('GLU'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0560 } ,
('GLU'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.8054 } ,
('GLU'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0136 } ,
('GLU'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2936 } ,
('GLU'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1105 } ,
('GLU'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.5163 } ,
('GLU'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5819 } ,
('GLU'  , 'OE1'  ) : { 'type' : 'O2'   , 'charge' : -0.8188 } ,
('GLU'  , 'OE2'  ) : { 'type' : 'O2'   , 'charge' : -0.8188 } ,
('GLP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0256 } ,
('GLP'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0430 } ,
('GLP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0256 } ,
('GLP'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0430 } ,
('GLP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('GLP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0145 } ,
('GLP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0071 } ,
('GLP'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.6801 } ,
('GLP'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' : -0.0174 } ,
('GLP'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('GLP'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0779 } ,
('GLP'  , 'HE2'  ) : { 'type' : 'HO'   , 'charge' :  0.4641 } ,
('GLP'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('GLP'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('GLP'  , 'OE1'  ) : { 'type' : 'O'    , 'charge' : -0.5838 } ,
('GLP'  , 'OE2'  ) : { 'type' : 'OH'   , 'charge' : -0.6511 } ,
('PHE'  , '1HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1330 } ,
('PHE'  , '1HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1430 } ,
('PHE'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0295 } ,
('PHE'  , '2HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1330 } ,
('PHE'  , '2HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1430 } ,
('PHE'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0295 } ,
('PHE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('PHE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0024 } ,
('PHE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0343 } ,
('PHE'  , 'CD1'  ) : { 'type' : 'CA'   , 'charge' : -0.1256 } ,
('PHE'  , 'CD2'  ) : { 'type' : 'CA'   , 'charge' : -0.1256 } ,
('PHE'  , 'CE1'  ) : { 'type' : 'CA'   , 'charge' : -0.1704 } ,
('PHE'  , 'CE2'  ) : { 'type' : 'CA'   , 'charge' : -0.1704 } ,
('PHE'  , 'CG'   ) : { 'type' : 'CA'   , 'charge' :  0.0118 } ,
('PHE'  , 'CZ'   ) : { 'type' : 'CA'   , 'charge' : -0.1072 } ,
('PHE'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('PHE'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0978 } ,
('PHE'  , 'HZ'   ) : { 'type' : 'HA'   , 'charge' :  0.1297 } ,
('PHE'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('PHE'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('GLY'  , '3HA'  ) : { 'type' : 'H1'   , 'charge' :  0.0698 } ,
('GLY'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('GLY'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0252 } ,
('GLY'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('GLY'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0698 } ,
('GLY'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('GLY'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('HIP'  , '1HD'  ) : { 'type' : 'H'    , 'charge' :  0.3866 } ,
('HIP'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.2681 } ,
('HIP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0810 } ,
('HIP'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.2317 } ,
('HIP'  , '2HE'  ) : { 'type' : 'H'    , 'charge' :  0.3911 } ,
('HIP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0810 } ,
('HIP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7341 } ,
('HIP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1354 } ,
('HIP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0414 } ,
('HIP'  , 'CD2'  ) : { 'type' : 'CW'   , 'charge' : -0.1141 } ,
('HIP'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' : -0.0170 } ,
('HIP'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' : -0.0012 } ,
('HIP'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2747 } ,
('HIP'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1212 } ,
('HIP'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3479 } ,
('HIP'  , 'ND1'  ) : { 'type' : 'NA'   , 'charge' : -0.1513 } ,
('HIP'  , 'NE2'  ) : { 'type' : 'NA'   , 'charge' : -0.1718 } ,
('HIP'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5894 } ,
('HIE'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.1435 } ,
('HIE'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0367 } ,
('HIE'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.1862 } ,
('HIE'  , '2HE'  ) : { 'type' : 'H'    , 'charge' :  0.3339 } ,
('HIE'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0367 } ,
('HIE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('HIE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0581 } ,
('HIE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0074 } ,
('HIE'  , 'CD2'  ) : { 'type' : 'CW'   , 'charge' : -0.2207 } ,
('HIE'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' :  0.1635 } ,
('HIE'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' :  0.1868 } ,
('HIE'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('HIE'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1360 } ,
('HIE'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('HIE'  , 'ND1'  ) : { 'type' : 'NB'   , 'charge' : -0.5432 } ,
('HIE'  , 'NE2'  ) : { 'type' : 'NA'   , 'charge' : -0.2795 } ,
('HIE'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('HID'  , '1HD'  ) : { 'type' : 'H'    , 'charge' :  0.3649 } ,
('HID'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.1392 } ,
('HID'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0402 } ,
('HID'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.1147 } ,
('HID'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0402 } ,
('HID'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('HID'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0188 } ,
('HID'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0462 } ,
('HID'  , 'CD2'  ) : { 'type' : 'CV'   , 'charge' :  0.1292 } ,
('HID'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' :  0.2057 } ,
('HID'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' : -0.0266 } ,
('HID'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('HID'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0881 } ,
('HID'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('HID'  , 'ND1'  ) : { 'type' : 'NA'   , 'charge' : -0.3811 } ,
('HID'  , 'NE2'  ) : { 'type' : 'NB'   , 'charge' : -0.5727 } ,
('HID'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('ILE'  , '1HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0186 } ,
('ILE'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0882 } ,
('ILE'  , '2HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0186 } ,
('ILE'  , '2HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0236 } ,
('ILE'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0882 } ,
('ILE'  , '3HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0186 } ,
('ILE'  , '3HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0236 } ,
('ILE'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0882 } ,
('ILE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('ILE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0597 } ,
('ILE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.1303 } ,
('ILE'  , 'CD1'  ) : { 'type' : 'CT'   , 'charge' : -0.0660 } ,
('ILE'  , 'CG1'  ) : { 'type' : 'CT'   , 'charge' : -0.0430 } ,
('ILE'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.3204 } ,
('ILE'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('ILE'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0869 } ,
('ILE'  , 'HB'   ) : { 'type' : 'HC'   , 'charge' :  0.0187 } ,
('ILE'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('ILE'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('LYS'  , '1HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3400 } ,
('LYS'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0362 } ,
('LYS'  , '2HD'  ) : { 'type' : 'HC'   , 'charge' :  0.0621 } ,
('LYS'  , '2HE'  ) : { 'type' : 'HP'   , 'charge' :  0.1135 } ,
('LYS'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0103 } ,
('LYS'  , '2HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3400 } ,
('LYS'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0362 } ,
('LYS'  , '3HD'  ) : { 'type' : 'HC'   , 'charge' :  0.0621 } ,
('LYS'  , '3HE'  ) : { 'type' : 'HP'   , 'charge' :  0.1135 } ,
('LYS'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0103 } ,
('LYS'  , '3HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3400 } ,
('LYS'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7341 } ,
('LYS'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2400 } ,
('LYS'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0094 } ,
('LYS'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' : -0.0479 } ,
('LYS'  , 'CE'   ) : { 'type' : 'CT'   , 'charge' : -0.0143 } ,
('LYS'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0187 } ,
('LYS'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2747 } ,
('LYS'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1426 } ,
('LYS'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3479 } ,
('LYS'  , 'NZ'   ) : { 'type' : 'N3'   , 'charge' : -0.3854 } ,
('LYS'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5894 } ,
('LEU'  , '1HD1' ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('LEU'  , '1HD2' ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('LEU'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0457 } ,
('LEU'  , '2HD1' ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('LEU'  , '2HD2' ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('LEU'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0457 } ,
('LEU'  , '3HD1' ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('LEU'  , '3HD2' ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('LEU'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('LEU'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0518 } ,
('LEU'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1102 } ,
('LEU'  , 'CD1'  ) : { 'type' : 'CT'   , 'charge' : -0.4121 } ,
('LEU'  , 'CD2'  ) : { 'type' : 'CT'   , 'charge' : -0.4121 } ,
('LEU'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.3531 } ,
('LEU'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('LEU'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0922 } ,
('LEU'  , 'HG'   ) : { 'type' : 'HC'   , 'charge' : -0.0361 } ,
('LEU'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('LEU'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('MET'  , '1HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0684 } ,
('MET'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0241 } ,
('MET'  , '2HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0684 } ,
('MET'  , '2HG'  ) : { 'type' : 'H1'   , 'charge' :  0.0440 } ,
('MET'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0241 } ,
('MET'  , '3HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0684 } ,
('MET'  , '3HG'  ) : { 'type' : 'H1'   , 'charge' :  0.0440 } ,
('MET'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('MET'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0237 } ,
('MET'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0342 } ,
('MET'  , 'CE'   ) : { 'type' : 'CT'   , 'charge' : -0.0536 } ,
('MET'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0018 } ,
('MET'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('MET'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0880 } ,
('MET'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('MET'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('MET'  , 'SD'   ) : { 'type' : 'S'    , 'charge' : -0.2737 } ,
('ASN'  , '1HD2' ) : { 'type' : 'H'    , 'charge' :  0.4196 } ,
('ASN'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0797 } ,
('ASN'  , '2HD2' ) : { 'type' : 'H'    , 'charge' :  0.4196 } ,
('ASN'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0797 } ,
('ASN'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('ASN'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0143 } ,
('ASN'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.2041 } ,
('ASN'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.7130 } ,
('ASN'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('ASN'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1048 } ,
('ASN'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('ASN'  , 'ND2'  ) : { 'type' : 'N'    , 'charge' : -0.9191 } ,
('ASN'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('ASN'  , 'OD1'  ) : { 'type' : 'O'    , 'charge' : -0.5931 } ,
('PRO'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0253 } ,
('PRO'  , '2HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0391 } ,
('PRO'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0213 } ,
('PRO'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0253 } ,
('PRO'  , '3HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0391 } ,
('PRO'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0213 } ,
('PRO'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5896 } ,
('PRO'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0266 } ,
('PRO'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0070 } ,
('PRO'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' :  0.0192 } ,
('PRO'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0189 } ,
('PRO'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0641 } ,
('PRO'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.2548 } ,
('PRO'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5748 } ,
('GLN'  , '1HE2' ) : { 'type' : 'H'    , 'charge' :  0.4251 } ,
('GLN'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0171 } ,
('GLN'  , '2HE2' ) : { 'type' : 'H'    , 'charge' :  0.4251 } ,
('GLN'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0352 } ,
('GLN'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0171 } ,
('GLN'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0352 } ,
('GLN'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('GLN'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0031 } ,
('GLN'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0036 } ,
('GLN'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.6951 } ,
('GLN'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' : -0.0645 } ,
('GLN'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('GLN'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0850 } ,
('GLN'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('GLN'  , 'NE2'  ) : { 'type' : 'N'    , 'charge' : -0.9407 } ,
('GLN'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('GLN'  , 'OE1'  ) : { 'type' : 'O'    , 'charge' : -0.6086 } ,
('ARG'  , '1HH1' ) : { 'type' : 'H'    , 'charge' :  0.4478 } ,
('ARG'  , '1HH2' ) : { 'type' : 'H'    , 'charge' :  0.4478 } ,
('ARG'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0327 } ,
('ARG'  , '2HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0687 } ,
('ARG'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0285 } ,
('ARG'  , '2HH1' ) : { 'type' : 'H'    , 'charge' :  0.4478 } ,
('ARG'  , '2HH2' ) : { 'type' : 'H'    , 'charge' :  0.4478 } ,
('ARG'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0327 } ,
('ARG'  , '3HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0687 } ,
('ARG'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0285 } ,
('ARG'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7341 } ,
('ARG'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2637 } ,
('ARG'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0007 } ,
('ARG'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' :  0.0486 } ,
('ARG'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0390 } ,
('ARG'  , 'CZ'   ) : { 'type' : 'CA'   , 'charge' :  0.8076 } ,
('ARG'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2747 } ,
('ARG'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1560 } ,
('ARG'  , 'HE'   ) : { 'type' : 'H'    , 'charge' :  0.3456 } ,
('ARG'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3479 } ,
('ARG'  , 'NE'   ) : { 'type' : 'N2'   , 'charge' : -0.5295 } ,
('ARG'  , 'NH1'  ) : { 'type' : 'N2'   , 'charge' : -0.8627 } ,
('ARG'  , 'NH2'  ) : { 'type' : 'N2'   , 'charge' : -0.8627 } ,
('ARG'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5894 } ,
('SER'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0352 } ,
('SER'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0352 } ,
('SER'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('SER'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0249 } ,
('SER'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.2117 } ,
('SER'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('SER'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0843 } ,
('SER'  , 'HG'   ) : { 'type' : 'HO'   , 'charge' :  0.4275 } ,
('SER'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('SER'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('SER'  , 'OG'   ) : { 'type' : 'OH'   , 'charge' : -0.6546 } ,
('THR'  , '1HG'  ) : { 'type' : 'HO'   , 'charge' :  0.4102 } ,
('THR'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0642 } ,
('THR'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0642 } ,
('THR'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0642 } ,
('THR'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('THR'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0389 } ,
('THR'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.3654 } ,
('THR'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.2438 } ,
('THR'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('THR'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1007 } ,
('THR'  , 'HB'   ) : { 'type' : 'H1'   , 'charge' :  0.0043 } ,
('THR'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('THR'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('THR'  , 'OG1'  ) : { 'type' : 'OH'   , 'charge' : -0.6761 } ,
('VAL'  , '1HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0791 } ,
('VAL'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0791 } ,
('VAL'  , '2HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0791 } ,
('VAL'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0791 } ,
('VAL'  , '3HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0791 } ,
('VAL'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0791 } ,
('VAL'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('VAL'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0875 } ,
('VAL'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.2985 } ,
('VAL'  , 'CG1'  ) : { 'type' : 'CT'   , 'charge' : -0.3192 } ,
('VAL'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.3192 } ,
('VAL'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('VAL'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0969 } ,
('VAL'  , 'HB'   ) : { 'type' : 'HC'   , 'charge' : -0.0297 } ,
('VAL'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('VAL'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('TRP'  , '1HD'  ) : { 'type' : 'H4'   , 'charge' :  0.2062 } ,
('TRP'  , '1HE'  ) : { 'type' : 'H'    , 'charge' :  0.3412 } ,
('TRP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0339 } ,
('TRP'  , '2HH'  ) : { 'type' : 'HA'   , 'charge' :  0.1417 } ,
('TRP'  , '2HZ'  ) : { 'type' : 'HA'   , 'charge' :  0.1572 } ,
('TRP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0339 } ,
('TRP'  , '3HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1700 } ,
('TRP'  , '3HZ'  ) : { 'type' : 'HA'   , 'charge' :  0.1447 } ,
('TRP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('TRP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0275 } ,
('TRP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0050 } ,
('TRP'  , 'CD1'  ) : { 'type' : 'CW'   , 'charge' : -0.1638 } ,
('TRP'  , 'CD2'  ) : { 'type' : 'CB'   , 'charge' :  0.1243 } ,
('TRP'  , 'CE2'  ) : { 'type' : 'CN'   , 'charge' :  0.1380 } ,
('TRP'  , 'CE3'  ) : { 'type' : 'CA'   , 'charge' : -0.2387 } ,
('TRP'  , 'CG'   ) : { 'type' : 'C*'   , 'charge' : -0.1415 } ,
('TRP'  , 'CH2'  ) : { 'type' : 'CA'   , 'charge' : -0.1134 } ,
('TRP'  , 'CZ2'  ) : { 'type' : 'CA'   , 'charge' : -0.2601 } ,
('TRP'  , 'CZ3'  ) : { 'type' : 'CA'   , 'charge' : -0.1972 } ,
('TRP'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('TRP'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1123 } ,
('TRP'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('TRP'  , 'NE1'  ) : { 'type' : 'NA'   , 'charge' : -0.3418 } ,
('TRP'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('TYR'  , '1HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1699 } ,
('TYR'  , '1HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1656 } ,
('TYR'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0295 } ,
('TYR'  , '2HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1699 } ,
('TYR'  , '2HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1656 } ,
('TYR'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0295 } ,
('TYR'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5973 } ,
('TYR'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0014 } ,
('TYR'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0152 } ,
('TYR'  , 'CD1'  ) : { 'type' : 'CA'   , 'charge' : -0.1906 } ,
('TYR'  , 'CD2'  ) : { 'type' : 'CA'   , 'charge' : -0.1906 } ,
('TYR'  , 'CE1'  ) : { 'type' : 'CA'   , 'charge' : -0.2341 } ,
('TYR'  , 'CE2'  ) : { 'type' : 'CA'   , 'charge' : -0.2341 } ,
('TYR'  , 'CG'   ) : { 'type' : 'CA'   , 'charge' : -0.0011 } ,
('TYR'  , 'CZ'   ) : { 'type' : 'C'    , 'charge' :  0.3226 } ,
('TYR'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('TYR'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0876 } ,
('TYR'  , 'HH'   ) : { 'type' : 'HO'   , 'charge' :  0.3992 } ,
('TYR'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('TYR'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
('TYR'  , 'OH'   ) : { 'type' : 'OH'   , 'charge' : -0.5579 } ,
('NME'  , '1HH3' ) : { 'type' : 'H1'   , 'charge' :  0.0976 } ,
('NME'  , '2HH3' ) : { 'type' : 'H1'   , 'charge' :  0.0976 } ,
('NME'  , '3HH3' ) : { 'type' : 'H1'   , 'charge' :  0.0976 } ,
('NME'  , 'CH3'  ) : { 'type' : 'CT'   , 'charge' : -0.1490 } ,
('NME'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2719 } ,
('NME'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.4157 } ,
('ACE'  , '1HH3' ) : { 'type' : 'HC'   , 'charge' :  0.1123 } ,
('ACE'  , '2HH3' ) : { 'type' : 'HC'   , 'charge' :  0.1123 } ,
('ACE'  , '3HH3' ) : { 'type' : 'HC'   , 'charge' :  0.1123 } ,
('ACE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5972 } ,
('ACE'  , 'CH3'  ) : { 'type' : 'CT'   , 'charge' : -0.3662 } ,
('ACE'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5679 } ,
}
n_terminal = {
('ALA'  , '1HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0300 } ,
('ALA'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1997 } ,
('ALA'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0300 } ,
('ALA'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1997 } ,
('ALA'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0300 } ,
('ALA'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1997 } ,
('ALA'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6163 } ,
('ALA'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0962 } ,
('ALA'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0597 } ,
('ALA'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.0889 } ,
('ALA'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1414 } ,
('ALA'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5722 } ,
('CYS'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2023 } ,
('CYS'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.1188 } ,
('CYS'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2023 } ,
('CYS'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.1188 } ,
('CYS'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2023 } ,
('CYS'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('CYS'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0927 } ,
('CYS'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1195 } ,
('CYS'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1411 } ,
('CYS'  , 'HG'   ) : { 'type' : 'HS'   , 'charge' :  0.1975 } ,
('CYS'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1325 } ,
('CYS'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('CYS'  , 'SG'   ) : { 'type' : 'SH'   , 'charge' : -0.3298 } ,
('CYX'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1815 } ,
('CYX'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0680 } ,
('CYX'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1815 } ,
('CYX'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0680 } ,
('CYX'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1815 } ,
('CYX'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('CYX'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.1055 } ,
('CYX'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0277 } ,
('CYX'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.0922 } ,
('CYX'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.2069 } ,
('CYX'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('CYX'  , 'SG'   ) : { 'type' : 'S'    , 'charge' : -0.0984 } ,
('ASP'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2200 } ,
('ASP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0169 } ,
('ASP'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2200 } ,
('ASP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0169 } ,
('ASP'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2200 } ,
('ASP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5621 } ,
('ASP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0292 } ,
('ASP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0235 } ,
('ASP'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.8194 } ,
('ASP'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1141 } ,
('ASP'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.0782 } ,
('ASP'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5889 } ,
('ASP'  , 'OD1'  ) : { 'type' : 'O2'   , 'charge' : -0.8084 } ,
('ASP'  , 'OD2'  ) : { 'type' : 'O2'   , 'charge' : -0.8084 } ,
('ASH'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2200 } ,
('ASH'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0169 } ,
('ASH'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2200 } ,
('ASH'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0169 } ,
('ASH'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2200 } ,
('ASH'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5621 } ,
('ASH'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0292 } ,
('ASH'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0235 } ,
('ASH'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.8194 } ,
('ASH'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1141 } ,
('ASH'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.0782 } ,
('ASH'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5889 } ,
('ASH'  , 'OD1'  ) : { 'type' : 'O'    , 'charge' : -0.8084 } ,
('ASH'  , 'OD2'  ) : { 'type' : 'OH'   , 'charge' : -0.8084 } ,
('GLU'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2391 } ,
('GLU'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0232 } ,
('GLU'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0315 } ,
('GLU'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2391 } ,
('GLU'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0232 } ,
('GLU'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0315 } ,
('GLU'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2391 } ,
('GLU'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5621 } ,
('GLU'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0588 } ,
('GLU'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0909 } ,
('GLU'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.8087 } ,
('GLU'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' : -0.0236 } ,
('GLU'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1202 } ,
('GLU'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.0017 } ,
('GLU'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5889 } ,
('GLU'  , 'OE1'  ) : { 'type' : 'O2'   , 'charge' : -0.8189 } ,
('GLU'  , 'OE2'  ) : { 'type' : 'O2'   , 'charge' : -0.8189 } ,
('GLP'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2391 } ,
('GLP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0232 } ,
('GLP'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0315 } ,
('GLP'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2391 } ,
('GLP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0232 } ,
('GLP'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0315 } ,
('GLP'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2391 } ,
('GLP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5621 } ,
('GLP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0588 } ,
('GLP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0909 } ,
('GLP'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.8087 } ,
('GLP'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' : -0.0236 } ,
('GLP'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1202 } ,
('GLP'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.0017 } ,
('GLP'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5889 } ,
('GLP'  , 'OE1'  ) : { 'type' : 'O'    , 'charge' : -0.8189 } ,
('GLP'  , 'OE2'  ) : { 'type' : 'OH'   , 'charge' : -0.8189 } ,
('PHE'  , '1HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1374 } ,
('PHE'  , '1HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1433 } ,
('PHE'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1921 } ,
('PHE'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0104 } ,
('PHE'  , '2HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1374 } ,
('PHE'  , '2HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1433 } ,
('PHE'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1921 } ,
('PHE'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0104 } ,
('PHE'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1921 } ,
('PHE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('PHE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0733 } ,
('PHE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0330 } ,
('PHE'  , 'CD1'  ) : { 'type' : 'CA'   , 'charge' : -0.1392 } ,
('PHE'  , 'CD2'  ) : { 'type' : 'CA'   , 'charge' : -0.1391 } ,
('PHE'  , 'CE1'  ) : { 'type' : 'CA'   , 'charge' : -0.1602 } ,
('PHE'  , 'CE2'  ) : { 'type' : 'CA'   , 'charge' : -0.1603 } ,
('PHE'  , 'CG'   ) : { 'type' : 'CA'   , 'charge' :  0.0031 } ,
('PHE'  , 'CZ'   ) : { 'type' : 'CA'   , 'charge' : -0.1208 } ,
('PHE'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1041 } ,
('PHE'  , 'HZ'   ) : { 'type' : 'HA'   , 'charge' :  0.1329 } ,
('PHE'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1737 } ,
('PHE'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('GLY'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1642 } ,
('GLY'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1642 } ,
('GLY'  , '3HA'  ) : { 'type' : 'H1'   , 'charge' :  0.0895 } ,
('GLY'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1642 } ,
('GLY'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6163 } ,
('GLY'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0100 } ,
('GLY'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.0895 } ,
('GLY'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.2943 } ,
('GLY'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5722 } ,
('HIP'  , '1HD'  ) : { 'type' : 'H'    , 'charge' :  0.3821 } ,
('HIP'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.2645 } ,
('HIP'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1704 } ,
('HIP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0531 } ,
('HIP'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.2495 } ,
('HIP'  , '2HE'  ) : { 'type' : 'H'    , 'charge' :  0.3921 } ,
('HIP'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1704 } ,
('HIP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0531 } ,
('HIP'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1704 } ,
('HIP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7214 } ,
('HIP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0581 } ,
('HIP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0484 } ,
('HIP'  , 'CD2'  ) : { 'type' : 'CW'   , 'charge' : -0.1433 } ,
('HIP'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' : -0.0011 } ,
('HIP'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' : -0.0236 } ,
('HIP'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1047 } ,
('HIP'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.2560 } ,
('HIP'  , 'ND1'  ) : { 'type' : 'NA'   , 'charge' : -0.1510 } ,
('HIP'  , 'NE2'  ) : { 'type' : 'NA'   , 'charge' : -0.1739 } ,
('HIP'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.6013 } ,
('HIE'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.1397 } ,
('HIE'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2016 } ,
('HIE'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0223 } ,
('HIE'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.1963 } ,
('HIE'  , '2HE'  ) : { 'type' : 'H'    , 'charge' :  0.3324 } ,
('HIE'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2016 } ,
('HIE'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0223 } ,
('HIE'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2016 } ,
('HIE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('HIE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0236 } ,
('HIE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0489 } ,
('HIE'  , 'CD2'  ) : { 'type' : 'CW'   , 'charge' : -0.2349 } ,
('HIE'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' :  0.1804 } ,
('HIE'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' :  0.1740 } ,
('HIE'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1380 } ,
('HIE'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1472 } ,
('HIE'  , 'ND1'  ) : { 'type' : 'NB'   , 'charge' : -0.5579 } ,
('HIE'  , 'NE2'  ) : { 'type' : 'NA'   , 'charge' : -0.2781 } ,
('HIE'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('HID'  , '1HD'  ) : { 'type' : 'H'    , 'charge' :  0.3632 } ,
('HID'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.1385 } ,
('HID'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1963 } ,
('HID'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0209 } ,
('HID'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.1299 } ,
('HID'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1963 } ,
('HID'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0209 } ,
('HID'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1963 } ,
('HID'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('HID'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0964 } ,
('HID'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0259 } ,
('HID'  , 'CD2'  ) : { 'type' : 'CV'   , 'charge' :  0.1046 } ,
('HID'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' :  0.2127 } ,
('HID'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' : -0.0399 } ,
('HID'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.0958 } ,
('HID'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1542 } ,
('HID'  , 'ND1'  ) : { 'type' : 'NA'   , 'charge' : -0.3819 } ,
('HID'  , 'NE2'  ) : { 'type' : 'NB'   , 'charge' : -0.5711 } ,
('HID'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('ILE'  , '1HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0226 } ,
('ILE'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0947 } ,
('ILE'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2329 } ,
('ILE'  , '2HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0226 } ,
('ILE'  , '2HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0201 } ,
('ILE'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0947 } ,
('ILE'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2329 } ,
('ILE'  , '3HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0226 } ,
('ILE'  , '3HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0201 } ,
('ILE'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0947 } ,
('ILE'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2329 } ,
('ILE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('ILE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0257 } ,
('ILE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.1885 } ,
('ILE'  , 'CD1'  ) : { 'type' : 'CT'   , 'charge' : -0.0908 } ,
('ILE'  , 'CG1'  ) : { 'type' : 'CT'   , 'charge' : -0.0387 } ,
('ILE'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.3720 } ,
('ILE'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1031 } ,
('ILE'  , 'HB'   ) : { 'type' : 'HC'   , 'charge' :  0.0213 } ,
('ILE'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.0311 } ,
('ILE'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('LYS'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2165 } ,
('LYS'  , '1HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3382 } ,
('LYS'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0283 } ,
('LYS'  , '2HD'  ) : { 'type' : 'HC'   , 'charge' :  0.0633 } ,
('LYS'  , '2HE'  ) : { 'type' : 'HP'   , 'charge' :  0.1171 } ,
('LYS'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0121 } ,
('LYS'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2165 } ,
('LYS'  , '2HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3382 } ,
('LYS'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0283 } ,
('LYS'  , '3HD'  ) : { 'type' : 'HC'   , 'charge' :  0.0633 } ,
('LYS'  , '3HE'  ) : { 'type' : 'HP'   , 'charge' :  0.1171 } ,
('LYS'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0121 } ,
('LYS'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2165 } ,
('LYS'  , '3HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3382 } ,
('LYS'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7214 } ,
('LYS'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0015 } ,
('LYS'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0212 } ,
('LYS'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' : -0.0608 } ,
('LYS'  , 'CE'   ) : { 'type' : 'CT'   , 'charge' : -0.0181 } ,
('LYS'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' : -0.0048 } ,
('LYS'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1180 } ,
('LYS'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.0966 } ,
('LYS'  , 'NZ'   ) : { 'type' : 'N3'   , 'charge' : -0.3764 } ,
('LYS'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.6013 } ,
('LEU'  , '1HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0980 } ,
('LEU'  , '1HD2' ) : { 'type' : 'HC'   , 'charge' :  0.0980 } ,
('LEU'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2148 } ,
('LEU'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0256 } ,
('LEU'  , '2HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0980 } ,
('LEU'  , '2HD2' ) : { 'type' : 'HC'   , 'charge' :  0.0980 } ,
('LEU'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2148 } ,
('LEU'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0256 } ,
('LEU'  , '3HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0980 } ,
('LEU'  , '3HD2' ) : { 'type' : 'HC'   , 'charge' :  0.0980 } ,
('LEU'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2148 } ,
('LEU'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('LEU'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0104 } ,
('LEU'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0244 } ,
('LEU'  , 'CD1'  ) : { 'type' : 'CT'   , 'charge' : -0.4106 } ,
('LEU'  , 'CD2'  ) : { 'type' : 'CT'   , 'charge' : -0.4104 } ,
('LEU'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.3421 } ,
('LEU'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1053 } ,
('LEU'  , 'HG'   ) : { 'type' : 'HC'   , 'charge' : -0.0380 } ,
('LEU'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1010 } ,
('LEU'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('MET'  , '1HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0597 } ,
('MET'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1984 } ,
('MET'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0125 } ,
('MET'  , '2HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0597 } ,
('MET'  , '2HG'  ) : { 'type' : 'H1'   , 'charge' :  0.0292 } ,
('MET'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1984 } ,
('MET'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0125 } ,
('MET'  , '3HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0597 } ,
('MET'  , '3HG'  ) : { 'type' : 'H1'   , 'charge' :  0.0292 } ,
('MET'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1984 } ,
('MET'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('MET'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0221 } ,
('MET'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0865 } ,
('MET'  , 'CE'   ) : { 'type' : 'CT'   , 'charge' : -0.0341 } ,
('MET'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0334 } ,
('MET'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1116 } ,
('MET'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1592 } ,
('MET'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('MET'  , 'SD'   ) : { 'type' : 'S'    , 'charge' : -0.2774 } ,
('ASN'  , '1HD2' ) : { 'type' : 'H'    , 'charge' :  0.4097 } ,
('ASN'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1921 } ,
('ASN'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0515 } ,
('ASN'  , '2HD2' ) : { 'type' : 'H'    , 'charge' :  0.4097 } ,
('ASN'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1921 } ,
('ASN'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0515 } ,
('ASN'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1921 } ,
('ASN'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6163 } ,
('ASN'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0368 } ,
('ASN'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0283 } ,
('ASN'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.5833 } ,
('ASN'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1231 } ,
('ASN'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1801 } ,
('ASN'  , 'ND2'  ) : { 'type' : 'N'    , 'charge' : -0.8634 } ,
('ASN'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5722 } ,
('ASN'  , 'OD1'  ) : { 'type' : 'O'    , 'charge' : -0.5744 } ,
('PRO'  , '2H'   ) : { 'type' : 'H'    , 'charge' :  0.3120 } ,
('PRO'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('PRO'  , '2HD'  ) : { 'type' : 'H1'   , 'charge' :  0.1000 } ,
('PRO'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('PRO'  , '3H'   ) : { 'type' : 'H'    , 'charge' :  0.3120 } ,
('PRO'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('PRO'  , '3HD'  ) : { 'type' : 'H1'   , 'charge' :  0.1000 } ,
('PRO'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.1000 } ,
('PRO'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.5260 } ,
('PRO'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.1000 } ,
('PRO'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1150 } ,
('PRO'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' : -0.0120 } ,
('PRO'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' : -0.1210 } ,
('PRO'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1000 } ,
('PRO'  , 'N'    ) : { 'type' : 'N3'   , 'charge' : -0.2020 } ,
('PRO'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5000 } ,
('GLN'  , '1HE2' ) : { 'type' : 'H'    , 'charge' :  0.4429 } ,
('GLN'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1996 } ,
('GLN'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0050 } ,
('GLN'  , '2HE2' ) : { 'type' : 'H'    , 'charge' :  0.4429 } ,
('GLN'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0331 } ,
('GLN'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1996 } ,
('GLN'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0050 } ,
('GLN'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0331 } ,
('GLN'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1996 } ,
('GLN'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('GLN'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0536 } ,
('GLN'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0651 } ,
('GLN'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.7354 } ,
('GLN'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' : -0.0903 } ,
('GLN'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1015 } ,
('GLN'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1493 } ,
('GLN'  , 'NE2'  ) : { 'type' : 'N'    , 'charge' : -1.0031 } ,
('GLN'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('GLN'  , 'OE1'  ) : { 'type' : 'O'    , 'charge' : -0.6133 } ,
('ARG'  , '1HH1' ) : { 'type' : 'H'    , 'charge' :  0.4494 } ,
('ARG'  , '1HH2' ) : { 'type' : 'H'    , 'charge' :  0.4494 } ,
('ARG'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2083 } ,
('ARG'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0226 } ,
('ARG'  , '2HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0527 } ,
('ARG'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0309 } ,
('ARG'  , '2HH1' ) : { 'type' : 'H'    , 'charge' :  0.4494 } ,
('ARG'  , '2HH2' ) : { 'type' : 'H'    , 'charge' :  0.4494 } ,
('ARG'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2083 } ,
('ARG'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0226 } ,
('ARG'  , '3HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0527 } ,
('ARG'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0309 } ,
('ARG'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2083 } ,
('ARG'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7214 } ,
('ARG'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0223 } ,
('ARG'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0118 } ,
('ARG'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' :  0.0935 } ,
('ARG'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0236 } ,
('ARG'  , 'CZ'   ) : { 'type' : 'CA'   , 'charge' :  0.8281 } ,
('ARG'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1242 } ,
('ARG'  , 'HE'   ) : { 'type' : 'H'    , 'charge' :  0.3592 } ,
('ARG'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1305 } ,
('ARG'  , 'NE'   ) : { 'type' : 'N2'   , 'charge' : -0.5650 } ,
('ARG'  , 'NH1'  ) : { 'type' : 'N2'   , 'charge' : -0.8693 } ,
('ARG'  , 'NH2'  ) : { 'type' : 'N2'   , 'charge' : -0.8693 } ,
('ARG'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.6013 } ,
('SER'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1898 } ,
('SER'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0273 } ,
('SER'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1898 } ,
('SER'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0273 } ,
('SER'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1898 } ,
('SER'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6163 } ,
('SER'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0567 } ,
('SER'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.2596 } ,
('SER'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.0782 } ,
('SER'  , 'HG'   ) : { 'type' : 'HO'   , 'charge' :  0.4239 } ,
('SER'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1849 } ,
('SER'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5722 } ,
('SER'  , 'OG'   ) : { 'type' : 'OH'   , 'charge' : -0.6714 } ,
('THR'  , '1HG'  ) : { 'type' : 'HO'   , 'charge' :  0.4070 } ,
('THR'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0627 } ,
('THR'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1934 } ,
('THR'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0627 } ,
('THR'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1934 } ,
('THR'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0627 } ,
('THR'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1934 } ,
('THR'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6163 } ,
('THR'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0034 } ,
('THR'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.4514 } ,
('THR'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.2554 } ,
('THR'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1087 } ,
('THR'  , 'HB'   ) : { 'type' : 'H1'   , 'charge' : -0.0323 } ,
('THR'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1812 } ,
('THR'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5722 } ,
('THR'  , 'OG1'  ) : { 'type' : 'OH'   , 'charge' : -0.6764 } ,
('VAL'  , '1HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0735 } ,
('VAL'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0735 } ,
('VAL'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.2272 } ,
('VAL'  , '2HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0735 } ,
('VAL'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0735 } ,
('VAL'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.2272 } ,
('VAL'  , '3HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0735 } ,
('VAL'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0735 } ,
('VAL'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.2272 } ,
('VAL'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6163 } ,
('VAL'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.0054 } ,
('VAL'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.3196 } ,
('VAL'  , 'CG1'  ) : { 'type' : 'CT'   , 'charge' : -0.3129 } ,
('VAL'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.3129 } ,
('VAL'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1093 } ,
('VAL'  , 'HB'   ) : { 'type' : 'HC'   , 'charge' : -0.0221 } ,
('VAL'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.0577 } ,
('VAL'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5722 } ,
('TRP'  , '1HD'  ) : { 'type' : 'H4'   , 'charge' :  0.2195 } ,
('TRP'  , '1HE'  ) : { 'type' : 'H'    , 'charge' :  0.3412 } ,
('TRP'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1888 } ,
('TRP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0222 } ,
('TRP'  , '2HH'  ) : { 'type' : 'HA'   , 'charge' :  0.1411 } ,
('TRP'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1888 } ,
('TRP'  , '2HZ'  ) : { 'type' : 'HA'   , 'charge' :  0.1589 } ,
('TRP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0222 } ,
('TRP'  , '3HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1646 } ,
('TRP'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1888 } ,
('TRP'  , '3HZ'  ) : { 'type' : 'HA'   , 'charge' :  0.1458 } ,
('TRP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('TRP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0421 } ,
('TRP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0543 } ,
('TRP'  , 'CD1'  ) : { 'type' : 'CW'   , 'charge' : -0.1788 } ,
('TRP'  , 'CD2'  ) : { 'type' : 'CB'   , 'charge' :  0.1132 } ,
('TRP'  , 'CE2'  ) : { 'type' : 'CN'   , 'charge' :  0.1575 } ,
('TRP'  , 'CE3'  ) : { 'type' : 'CA'   , 'charge' : -0.2265 } ,
('TRP'  , 'CG'   ) : { 'type' : 'C*'   , 'charge' : -0.1654 } ,
('TRP'  , 'CH2'  ) : { 'type' : 'CA'   , 'charge' : -0.1080 } ,
('TRP'  , 'CZ2'  ) : { 'type' : 'CA'   , 'charge' : -0.2710 } ,
('TRP'  , 'CZ3'  ) : { 'type' : 'CA'   , 'charge' : -0.2034 } ,
('TRP'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.1162 } ,
('TRP'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1913 } ,
('TRP'  , 'NE1'  ) : { 'type' : 'NA'   , 'charge' : -0.3444 } ,
('TRP'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('TYR'  , '1HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1720 } ,
('TYR'  , '1HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1650 } ,
('TYR'  , '1HT'  ) : { 'type' : 'H'    , 'charge' :  0.1873 } ,
('TYR'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0102 } ,
('TYR'  , '2HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1720 } ,
('TYR'  , '2HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1650 } ,
('TYR'  , '2HT'  ) : { 'type' : 'H'    , 'charge' :  0.1873 } ,
('TYR'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0102 } ,
('TYR'  , '3HT'  ) : { 'type' : 'H'    , 'charge' :  0.1873 } ,
('TYR'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6123 } ,
('TYR'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' :  0.0570 } ,
('TYR'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0659 } ,
('TYR'  , 'CD1'  ) : { 'type' : 'CA'   , 'charge' : -0.2002 } ,
('TYR'  , 'CD2'  ) : { 'type' : 'CA'   , 'charge' : -0.2002 } ,
('TYR'  , 'CE1'  ) : { 'type' : 'CA'   , 'charge' : -0.2239 } ,
('TYR'  , 'CE2'  ) : { 'type' : 'CA'   , 'charge' : -0.2239 } ,
('TYR'  , 'CG'   ) : { 'type' : 'CA'   , 'charge' : -0.0205 } ,
('TYR'  , 'CZ'   ) : { 'type' : 'C'    , 'charge' :  0.3139 } ,
('TYR'  , 'HA'   ) : { 'type' : 'HP'   , 'charge' :  0.0983 } ,
('TYR'  , 'HH'   ) : { 'type' : 'HO'   , 'charge' :  0.4001 } ,
('TYR'  , 'N'    ) : { 'type' : 'N3'   , 'charge' :  0.1940 } ,
('TYR'  , 'O'    ) : { 'type' : 'O'    , 'charge' : -0.5713 } ,
('TYR'  , 'OH'   ) : { 'type' : 'OH'   , 'charge' : -0.5578 } ,
}
c_terminal = {
('ALA'  , '1HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0764 } ,
('ALA'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0764 } ,
('ALA'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0764 } ,
('ALA'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7731 } ,
('ALA'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1747 } ,
('ALA'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.2093 } ,
('ALA'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('ALA'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1067 } ,
('ALA'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('ALA'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8055 } ,
('ALA'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8055 } ,
('CYS'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.1437 } ,
('CYS'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.1437 } ,
('CYS'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7497 } ,
('CYS'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1635 } ,
('CYS'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1996 } ,
('CYS'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('CYS'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1396 } ,
('CYS'  , 'HG'   ) : { 'type' : 'HS'   , 'charge' :  0.2068 } ,
('CYS'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('CYS'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.7981 } ,
('CYS'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.7981 } ,
('CYS'  , 'SG'   ) : { 'type' : 'SH'   , 'charge' : -0.3102 } ,
('CYX'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.1228 } ,
('CYX'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.1228 } ,
('CYX'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7618 } ,
('CYX'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1318 } ,
('CYX'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1943 } ,
('CYX'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('CYX'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0938 } ,
('CYX'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('CYX'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8041 } ,
('CYX'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8041 } ,
('CYX'  , 'SG'   ) : { 'type' : 'S'    , 'charge' : -0.0529 } ,
('ASP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0212 } ,
('ASP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0212 } ,
('ASP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7256 } ,
('ASP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1817 } ,
('ASP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0677 } ,
('ASP'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.8851 } ,
('ASP'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.3055 } ,
('ASP'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1046 } ,
('ASP'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.5192 } ,
('ASP'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.7887 } ,
('ASP'  , 'OD1'  ) : { 'type' : 'O2'   , 'charge' : -0.8162 } ,
('ASP'  , 'OD2'  ) : { 'type' : 'O2'   , 'charge' : -0.8162 } ,
('ASP'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.7887 } ,
('ASH'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0212 } ,
('ASH'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0212 } ,
('ASH'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7256 } ,
('ASH'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1817 } ,
('ASH'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0677 } ,
('ASH'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.8851 } ,
('ASH'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.3055 } ,
('ASH'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1046 } ,
('ASH'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.5192 } ,
('ASH'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.7887 } ,
('ASH'  , 'OD1'  ) : { 'type' : 'O'    , 'charge' : -0.8162 } ,
('ASH'  , 'OD2'  ) : { 'type' : 'OH'   , 'charge' : -0.8162 } ,
('ASH'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.7887 } ,
('GLU'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0078 } ,
('GLU'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0548 } ,
('GLU'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0078 } ,
('GLU'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0548 } ,
('GLU'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7420 } ,
('GLU'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2059 } ,
('GLU'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0071 } ,
('GLU'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.8183 } ,
('GLU'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0675 } ,
('GLU'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.3055 } ,
('GLU'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1399 } ,
('GLU'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.5192 } ,
('GLU'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.7930 } ,
('GLU'  , 'OE1'  ) : { 'type' : 'O2'   , 'charge' : -0.8220 } ,
('GLU'  , 'OE2'  ) : { 'type' : 'O2'   , 'charge' : -0.8220 } ,
('GLU'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.7930 } ,
('GLP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0078 } ,
('GLP'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0548 } ,
('GLP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' : -0.0078 } ,
('GLP'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' : -0.0548 } ,
('GLP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7420 } ,
('GLP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2059 } ,
('GLP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0071 } ,
('GLP'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.8183 } ,
('GLP'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0675 } ,
('GLP'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.3055 } ,
('GLP'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1399 } ,
('GLP'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.5192 } ,
('GLP'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.7930 } ,
('GLP'  , 'OE1'  ) : { 'type' : 'O'    , 'charge' : -0.8220 } ,
('GLP'  , 'OE2'  ) : { 'type' : 'OH'   , 'charge' : -0.8220 } ,
('GLP'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.7930 } ,
('PHE'  , '1HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1408 } ,
('PHE'  , '1HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1461 } ,
('PHE'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0443 } ,
('PHE'  , '2HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1408 } ,
('PHE'  , '2HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1461 } ,
('PHE'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0443 } ,
('PHE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7660 } ,
('PHE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1825 } ,
('PHE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0959 } ,
('PHE'  , 'CD1'  ) : { 'type' : 'CA'   , 'charge' : -0.1300 } ,
('PHE'  , 'CD2'  ) : { 'type' : 'CA'   , 'charge' : -0.1300 } ,
('PHE'  , 'CE1'  ) : { 'type' : 'CA'   , 'charge' : -0.1847 } ,
('PHE'  , 'CE2'  ) : { 'type' : 'CA'   , 'charge' : -0.1847 } ,
('PHE'  , 'CG'   ) : { 'type' : 'CA'   , 'charge' :  0.0552 } ,
('PHE'  , 'CZ'   ) : { 'type' : 'CA'   , 'charge' : -0.0944 } ,
('PHE'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('PHE'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1098 } ,
('PHE'  , 'HZ'   ) : { 'type' : 'HA'   , 'charge' :  0.1280 } ,
('PHE'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('PHE'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8026 } ,
('PHE'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8026 } ,
('GLY'  , '3HA'  ) : { 'type' : 'H1'   , 'charge' :  0.1056 } ,
('GLY'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7231 } ,
('GLY'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2493 } ,
('GLY'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('GLY'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1056 } ,
('GLY'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('GLY'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.7855 } ,
('GLY'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.7855 } ,
('HIP'  , '1HD'  ) : { 'type' : 'H'    , 'charge' :  0.3883 } ,
('HIP'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.2694 } ,
('HIP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0868 } ,
('HIP'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.2336 } ,
('HIP'  , '2HE'  ) : { 'type' : 'H'    , 'charge' :  0.3913 } ,
('HIP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0868 } ,
('HIP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8032 } ,
('HIP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1445 } ,
('HIP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0800 } ,
('HIP'  , 'CD2'  ) : { 'type' : 'CW'   , 'charge' : -0.1256 } ,
('HIP'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' : -0.0251 } ,
('HIP'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' :  0.0298 } ,
('HIP'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2764 } ,
('HIP'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1115 } ,
('HIP'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3481 } ,
('HIP'  , 'ND1'  ) : { 'type' : 'NA'   , 'charge' : -0.1501 } ,
('HIP'  , 'NE2'  ) : { 'type' : 'NA'   , 'charge' : -0.1683 } ,
('HIP'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8177 } ,
('HIP'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8177 } ,
('HIE'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.1448 } ,
('HIE'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0620 } ,
('HIE'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.1957 } ,
('HIE'  , '2HE'  ) : { 'type' : 'H'    , 'charge' :  0.3319 } ,
('HIE'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0620 } ,
('HIE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7916 } ,
('HIE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2699 } ,
('HIE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1068 } ,
('HIE'  , 'CD2'  ) : { 'type' : 'CW'   , 'charge' : -0.2588 } ,
('HIE'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' :  0.1558 } ,
('HIE'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' :  0.2724 } ,
('HIE'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('HIE'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1650 } ,
('HIE'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('HIE'  , 'ND1'  ) : { 'type' : 'NB'   , 'charge' : -0.5517 } ,
('HIE'  , 'NE2'  ) : { 'type' : 'NA'   , 'charge' : -0.2670 } ,
('HIE'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8065 } ,
('HIE'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8065 } ,
('HID'  , '1HD'  ) : { 'type' : 'H'    , 'charge' :  0.3755 } ,
('HID'  , '1HE'  ) : { 'type' : 'H5'   , 'charge' :  0.1418 } ,
('HID'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0565 } ,
('HID'  , '2HD'  ) : { 'type' : 'H4'   , 'charge' :  0.1241 } ,
('HID'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0565 } ,
('HID'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7615 } ,
('HID'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1739 } ,
('HID'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.1046 } ,
('HID'  , 'CD2'  ) : { 'type' : 'CV'   , 'charge' :  0.1001 } ,
('HID'  , 'CE1'  ) : { 'type' : 'CR'   , 'charge' :  0.1925 } ,
('HID'  , 'CG'   ) : { 'type' : 'CC'   , 'charge' :  0.0293 } ,
('HID'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('HID'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1100 } ,
('HID'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('HID'  , 'ND1'  ) : { 'type' : 'NA'   , 'charge' : -0.3892 } ,
('HID'  , 'NE2'  ) : { 'type' : 'NB'   , 'charge' : -0.5629 } ,
('HID'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8016 } ,
('HID'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8016 } ,
('ILE'  , '1HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0196 } ,
('ILE'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.1021 } ,
('ILE'  , '2HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0196 } ,
('ILE'  , '2HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0321 } ,
('ILE'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.1021 } ,
('ILE'  , '3HD1' ) : { 'type' : 'HC'   , 'charge' :  0.0196 } ,
('ILE'  , '3HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0321 } ,
('ILE'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.1021 } ,
('ILE'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8343 } ,
('ILE'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.3100 } ,
('ILE'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.0363 } ,
('ILE'  , 'CD1'  ) : { 'type' : 'CT'   , 'charge' : -0.0699 } ,
('ILE'  , 'CG1'  ) : { 'type' : 'CT'   , 'charge' : -0.0323 } ,
('ILE'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.3498 } ,
('ILE'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('ILE'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1375 } ,
('ILE'  , 'HB'   ) : { 'type' : 'HC'   , 'charge' :  0.0766 } ,
('ILE'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('ILE'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8190 } ,
('ILE'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8190 } ,
('LYS'  , '1HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3374 } ,
('LYS'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0482 } ,
('LYS'  , '2HD'  ) : { 'type' : 'HC'   , 'charge' :  0.0611 } ,
('LYS'  , '2HE'  ) : { 'type' : 'HP'   , 'charge' :  0.1121 } ,
('LYS'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0134 } ,
('LYS'  , '2HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3374 } ,
('LYS'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0482 } ,
('LYS'  , '3HD'  ) : { 'type' : 'HC'   , 'charge' :  0.0611 } ,
('LYS'  , '3HE'  ) : { 'type' : 'HP'   , 'charge' :  0.1121 } ,
('LYS'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0134 } ,
('LYS'  , '3HZ'  ) : { 'type' : 'H'    , 'charge' :  0.3374 } ,
('LYS'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8488 } ,
('LYS'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2903 } ,
('LYS'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0538 } ,
('LYS'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' : -0.0392 } ,
('LYS'  , 'CE'   ) : { 'type' : 'CT'   , 'charge' : -0.0176 } ,
('LYS'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0227 } ,
('LYS'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2764 } ,
('LYS'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1438 } ,
('LYS'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3481 } ,
('LYS'  , 'NZ'   ) : { 'type' : 'N3'   , 'charge' : -0.3741 } ,
('LYS'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8252 } ,
('LYS'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8252 } ,
('LEU'  , '1HD1' ) : { 'type' : 'HC'   , 'charge' :  0.1038 } ,
('LEU'  , '1HD2' ) : { 'type' : 'HC'   , 'charge' :  0.1038 } ,
('LEU'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0974 } ,
('LEU'  , '2HD1' ) : { 'type' : 'HC'   , 'charge' :  0.1038 } ,
('LEU'  , '2HD2' ) : { 'type' : 'HC'   , 'charge' :  0.1038 } ,
('LEU'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0974 } ,
('LEU'  , '3HD1' ) : { 'type' : 'HC'   , 'charge' :  0.1038 } ,
('LEU'  , '3HD2' ) : { 'type' : 'HC'   , 'charge' :  0.1038 } ,
('LEU'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8326 } ,
('LEU'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2847 } ,
('LEU'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.2469 } ,
('LEU'  , 'CD1'  ) : { 'type' : 'CT'   , 'charge' : -0.4163 } ,
('LEU'  , 'CD2'  ) : { 'type' : 'CT'   , 'charge' : -0.4163 } ,
('LEU'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.3706 } ,
('LEU'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('LEU'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1346 } ,
('LEU'  , 'HG'   ) : { 'type' : 'HC'   , 'charge' : -0.0374 } ,
('LEU'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('LEU'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8199 } ,
('LEU'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8199 } ,
('MET'  , '1HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0625 } ,
('MET'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0480 } ,
('MET'  , '2HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0625 } ,
('MET'  , '2HG'  ) : { 'type' : 'H1'   , 'charge' :  0.0317 } ,
('MET'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0480 } ,
('MET'  , '3HE'  ) : { 'type' : 'H1'   , 'charge' :  0.0625 } ,
('MET'  , '3HG'  ) : { 'type' : 'H1'   , 'charge' :  0.0317 } ,
('MET'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8013 } ,
('MET'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2597 } ,
('MET'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0236 } ,
('MET'  , 'CE'   ) : { 'type' : 'CT'   , 'charge' : -0.0376 } ,
('MET'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0492 } ,
('MET'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('MET'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1277 } ,
('MET'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('MET'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8105 } ,
('MET'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8105 } ,
('MET'  , 'SD'   ) : { 'type' : 'S'    , 'charge' : -0.2692 } ,
('ASN'  , '1HD2' ) : { 'type' : 'H'    , 'charge' :  0.4150 } ,
('ASN'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.1023 } ,
('ASN'  , '2HD2' ) : { 'type' : 'H'    , 'charge' :  0.4150 } ,
('ASN'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.1023 } ,
('ASN'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8050 } ,
('ASN'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2080 } ,
('ASN'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.2299 } ,
('ASN'  , 'CG'   ) : { 'type' : 'C'    , 'charge' :  0.7153 } ,
('ASN'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('ASN'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1358 } ,
('ASN'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('ASN'  , 'ND2'  ) : { 'type' : 'N'    , 'charge' : -0.9084 } ,
('ASN'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8147 } ,
('ASN'  , 'OD1'  ) : { 'type' : 'O'    , 'charge' : -0.6010 } ,
('ASN'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8147 } ,
('PRO'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0381 } ,
('PRO'  , '2HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0331 } ,
('PRO'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0172 } ,
('PRO'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0381 } ,
('PRO'  , '3HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0331 } ,
('PRO'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0172 } ,
('PRO'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.6631 } ,
('PRO'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.1336 } ,
('PRO'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0543 } ,
('PRO'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' :  0.0434 } ,
('PRO'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0466 } ,
('PRO'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.0776 } ,
('PRO'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.2802 } ,
('PRO'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.7697 } ,
('PRO'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.7697 } ,
('GLN'  , '1HE2' ) : { 'type' : 'H'    , 'charge' :  0.4304 } ,
('GLN'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0452 } ,
('GLN'  , '2HE2' ) : { 'type' : 'H'    , 'charge' :  0.4304 } ,
('GLN'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0203 } ,
('GLN'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0452 } ,
('GLN'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0203 } ,
('GLN'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7775 } ,
('GLN'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2248 } ,
('GLN'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0664 } ,
('GLN'  , 'CD'   ) : { 'type' : 'C'    , 'charge' :  0.7093 } ,
('GLN'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' : -0.0210 } ,
('GLN'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('GLN'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1232 } ,
('GLN'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('GLN'  , 'NE2'  ) : { 'type' : 'N'    , 'charge' : -0.9574 } ,
('GLN'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8042 } ,
('GLN'  , 'OE1'  ) : { 'type' : 'O'    , 'charge' : -0.6098 } ,
('GLN'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8042 } ,
('ARG'  , '1HH1' ) : { 'type' : 'H'    , 'charge' :  0.4493 } ,
('ARG'  , '1HH2' ) : { 'type' : 'H'    , 'charge' :  0.4493 } ,
('ARG'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0371 } ,
('ARG'  , '2HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0468 } ,
('ARG'  , '2HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0185 } ,
('ARG'  , '2HH1' ) : { 'type' : 'H'    , 'charge' :  0.4493 } ,
('ARG'  , '2HH2' ) : { 'type' : 'H'    , 'charge' :  0.4493 } ,
('ARG'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0371 } ,
('ARG'  , '3HD'  ) : { 'type' : 'H1'   , 'charge' :  0.0468 } ,
('ARG'  , '3HG'  ) : { 'type' : 'HC'   , 'charge' :  0.0185 } ,
('ARG'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8557 } ,
('ARG'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.3068 } ,
('ARG'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0374 } ,
('ARG'  , 'CD'   ) : { 'type' : 'CT'   , 'charge' :  0.1114 } ,
('ARG'  , 'CG'   ) : { 'type' : 'CT'   , 'charge' :  0.0744 } ,
('ARG'  , 'CZ'   ) : { 'type' : 'CA'   , 'charge' :  0.8368 } ,
('ARG'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2764 } ,
('ARG'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1447 } ,
('ARG'  , 'HE'   ) : { 'type' : 'H'    , 'charge' :  0.3479 } ,
('ARG'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3481 } ,
('ARG'  , 'NE'   ) : { 'type' : 'N2'   , 'charge' : -0.5564 } ,
('ARG'  , 'NH1'  ) : { 'type' : 'N2'   , 'charge' : -0.8737 } ,
('ARG'  , 'NH2'  ) : { 'type' : 'N2'   , 'charge' : -0.8737 } ,
('ARG'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8266 } ,
('ARG'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8266 } ,
('SER'  , '2HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0813 } ,
('SER'  , '3HB'  ) : { 'type' : 'H1'   , 'charge' :  0.0813 } ,
('SER'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8113 } ,
('SER'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2722 } ,
('SER'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.1123 } ,
('SER'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('SER'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1304 } ,
('SER'  , 'HG'   ) : { 'type' : 'HO'   , 'charge' :  0.4474 } ,
('SER'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('SER'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8132 } ,
('SER'  , 'OG'   ) : { 'type' : 'OH'   , 'charge' : -0.6514 } ,
('SER'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8132 } ,
('THR'  , '1HG'  ) : { 'type' : 'HO'   , 'charge' :  0.4119 } ,
('THR'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0586 } ,
('THR'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0586 } ,
('THR'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0586 } ,
('THR'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7810 } ,
('THR'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2420 } ,
('THR'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.3025 } ,
('THR'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.1853 } ,
('THR'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('THR'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1207 } ,
('THR'  , 'HB'   ) : { 'type' : 'H1'   , 'charge' :  0.0078 } ,
('THR'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('THR'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8044 } ,
('THR'  , 'OG1'  ) : { 'type' : 'OH'   , 'charge' : -0.6496 } ,
('THR'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8044 } ,
('VAL'  , '1HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0836 } ,
('VAL'  , '1HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0836 } ,
('VAL'  , '2HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0836 } ,
('VAL'  , '2HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0836 } ,
('VAL'  , '3HG1' ) : { 'type' : 'HC'   , 'charge' :  0.0836 } ,
('VAL'  , '3HG2' ) : { 'type' : 'HC'   , 'charge' :  0.0836 } ,
('VAL'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.8350 } ,
('VAL'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.3438 } ,
('VAL'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' :  0.1940 } ,
('VAL'  , 'CG1'  ) : { 'type' : 'CT'   , 'charge' : -0.3064 } ,
('VAL'  , 'CG2'  ) : { 'type' : 'CT'   , 'charge' : -0.3064 } ,
('VAL'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('VAL'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1438 } ,
('VAL'  , 'HB'   ) : { 'type' : 'HC'   , 'charge' :  0.0308 } ,
('VAL'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('VAL'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8173 } ,
('VAL'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8173 } ,
('TRP'  , '1HD'  ) : { 'type' : 'H4'   , 'charge' :  0.2043 } ,
('TRP'  , '1HE'  ) : { 'type' : 'H'    , 'charge' :  0.3413 } ,
('TRP'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0497 } ,
('TRP'  , '2HH'  ) : { 'type' : 'HA'   , 'charge' :  0.1401 } ,
('TRP'  , '2HZ'  ) : { 'type' : 'HA'   , 'charge' :  0.1567 } ,
('TRP'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0497 } ,
('TRP'  , '3HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1491 } ,
('TRP'  , '3HZ'  ) : { 'type' : 'HA'   , 'charge' :  0.1507 } ,
('TRP'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7658 } ,
('TRP'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2084 } ,
('TRP'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0742 } ,
('TRP'  , 'CD1'  ) : { 'type' : 'CW'   , 'charge' : -0.1808 } ,
('TRP'  , 'CD2'  ) : { 'type' : 'CB'   , 'charge' :  0.1078 } ,
('TRP'  , 'CE2'  ) : { 'type' : 'CN'   , 'charge' :  0.1222 } ,
('TRP'  , 'CE3'  ) : { 'type' : 'CA'   , 'charge' : -0.1837 } ,
('TRP'  , 'CG'   ) : { 'type' : 'C*'   , 'charge' : -0.0796 } ,
('TRP'  , 'CH2'  ) : { 'type' : 'CA'   , 'charge' : -0.1020 } ,
('TRP'  , 'CZ2'  ) : { 'type' : 'CA'   , 'charge' : -0.2594 } ,
('TRP'  , 'CZ3'  ) : { 'type' : 'CA'   , 'charge' : -0.2287 } ,
('TRP'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('TRP'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1272 } ,
('TRP'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('TRP'  , 'NE1'  ) : { 'type' : 'NA'   , 'charge' : -0.3316 } ,
('TRP'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8011 } ,
('TRP'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8011 } ,
('TYR'  , '1HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1780 } ,
('TYR'  , '1HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1673 } ,
('TYR'  , '2HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0490 } ,
('TYR'  , '2HD'  ) : { 'type' : 'HA'   , 'charge' :  0.1780 } ,
('TYR'  , '2HE'  ) : { 'type' : 'HA'   , 'charge' :  0.1673 } ,
('TYR'  , '3HB'  ) : { 'type' : 'HC'   , 'charge' :  0.0490 } ,
('TYR'  , 'C'    ) : { 'type' : 'C'    , 'charge' :  0.7817 } ,
('TYR'  , 'CA'   ) : { 'type' : 'CT'   , 'charge' : -0.2015 } ,
('TYR'  , 'CB'   ) : { 'type' : 'CT'   , 'charge' : -0.0752 } ,
('TYR'  , 'CD1'  ) : { 'type' : 'CA'   , 'charge' : -0.1922 } ,
('TYR'  , 'CD2'  ) : { 'type' : 'CA'   , 'charge' : -0.1922 } ,
('TYR'  , 'CE1'  ) : { 'type' : 'CA'   , 'charge' : -0.2458 } ,
('TYR'  , 'CE2'  ) : { 'type' : 'CA'   , 'charge' : -0.2458 } ,
('TYR'  , 'CG'   ) : { 'type' : 'CA'   , 'charge' :  0.0243 } ,
('TYR'  , 'CZ'   ) : { 'type' : 'C'    , 'charge' :  0.3395 } ,
('TYR'  , 'H'    ) : { 'type' : 'H'    , 'charge' :  0.2681 } ,
('TYR'  , 'HA'   ) : { 'type' : 'H1'   , 'charge' :  0.1092 } ,
('TYR'  , 'HH'   ) : { 'type' : 'HO'   , 'charge' :  0.4017 } ,
('TYR'  , 'N'    ) : { 'type' : 'N'    , 'charge' : -0.3821 } ,
('TYR'  , 'O'    ) : { 'type' : 'O2'   , 'charge' : -0.8070 } ,
('TYR'  , 'OH'   ) : { 'type' : 'OH'   , 'charge' : -0.5643 } ,
('TYR'  , 'OXT'  ) : { 'type' : 'O2'   , 'charge' : -0.8070 } ,
}
