#!/usr/bin/python
#  Copyright (C) 2004  Henning Jacobs <henning@srcco.de>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  $Id: RadioSelectDialog.py 82 2004-07-11 13:01:44Z henning $

from Tkinter import *
import Pmw

class RadioSelectDialog(Pmw.Dialog):

    # exporttargets e.g.: [("csv","Comma Separated Values"),("latex","LaTeX)] 
    def __init__(self, master, exporttargets,
                 title="", headline="", class_=None):
        Pmw.Dialog.__init__(self, master=master, title=title,
            buttons=('Ok','Cancel'), defaultbutton='Ok') 
        
        lbl = Label(self.interior(), text=headline)
        lbl.grid(padx=2, pady=2)

        self.targetvar = StringVar()
        self.targetvar.set(exporttargets[0][0])

        for target in exporttargets:
            lbl = Radiobutton(self.interior(), text=target[1],
                    value = target[0], variable = self.targetvar)
            lbl.grid(sticky=W, padx=2, pady=2)
            
    def getvalue(self):
        return self.targetvar.get()
        

if __name__ == "__main__":
    # Unit Test:
    tk = Tk()
    exporttargets = [("csv","Comma Separated Values"),
            ("dat","Future Data Format")]
    dlg = RadioSelectDialog(tk, exporttargets, title="Test", headline="Export To:")
    print dlg.activate()
    tk.destroy()
