# -*- coding: utf-8 -*-

#  Copyright © 2013  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


def po_isempty(pofilename, verbose=True):
    try:
        import polib
    except ImportError:
        if verbose:
            print('polib not found, assuming the file %s contains translations' % pofilename)
        return False
    for entry in polib.pofile(pofilename):
        if entry.translated() and entry.msgid != entry.msgstr:
            return False
    return True
    

