/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import weka.core.Tag;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.Messages;
import weka.gui.beans.SerializedModelSaver;

public class SerializedModelSaverCustomizer
extends JPanel
implements Customizer,
CustomizerCloseRequester {
    private static final long serialVersionUID = -4874208115942078471L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private SerializedModelSaver m_smSaver;
    private PropertySheetPanel m_SaverEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private JFrame m_parentFrame;
    private JTextField m_prefixText;
    private JComboBox m_fileFormatBox;
    private JCheckBox m_relativeFilePath;

    public SerializedModelSaverCustomizer() {
        try {
            this.m_SaverEditor.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    SerializedModelSaverCustomizer.this.repaint();
                    if (SerializedModelSaverCustomizer.this.m_smSaver != null) {
                        Messages.getInstance();
                        System.err.println(Messages.getString("SerializedModelSaverCustomizer_Error_Text"));
                    }
                }
            });
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(1);
        this.m_fileChooser.setFileSelectionMode(1);
        Messages.getInstance();
        this.m_fileChooser.setApproveButtonText(Messages.getString("SerializedModelSaverCustomizer_FileChooser_SetApproveButtonText_Text"));
        this.m_fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    try {
                        SerializedModelSaverCustomizer.this.m_smSaver.setPrefix(SerializedModelSaverCustomizer.this.m_prefixText.getText());
                        SerializedModelSaverCustomizer.this.m_smSaver.setDirectory(SerializedModelSaverCustomizer.this.m_fileChooser.getSelectedFile());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (SerializedModelSaverCustomizer.this.m_parentFrame != null) {
                    SerializedModelSaverCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
    }

    public void setParentFrame(JFrame parent) {
        this.m_parentFrame = parent;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_SaverEditor, "Center");
        this.validate();
        this.repaint();
    }

    public void setUpFile() {
        this.removeAll();
        this.m_fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory();
            }

            public String getDescription() {
                Messages.getInstance();
                return Messages.getString("SerializedModelSaverCustomizer_SetUpFile_GetDescription_Text");
            }
        });
        this.m_fileChooser.setAcceptAllFileFilterUsed(false);
        try {
            if (!this.m_smSaver.getDirectory().getPath().equals("")) {
                File tmp = this.m_smSaver.getDirectory();
                tmp = new File(tmp.getAbsolutePath());
                this.m_fileChooser.setCurrentDirectory(tmp);
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        try {
            this.m_prefixText = new JTextField(this.m_smSaver.getPrefix(), 25);
            Messages.getInstance();
            JLabel prefixLab = new JLabel(Messages.getString("SerializedModelSaverCustomizer_SetUpFile_PrefixLab_JLabel_Text"), 2);
            JPanel prefixP = new JPanel();
            prefixP.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            prefixP.setLayout(new BorderLayout());
            prefixP.add((Component)prefixLab, "West");
            prefixP.add((Component)this.m_prefixText, "Center");
            innerPanel.add((Component)prefixP, "South");
            JPanel ffP = new JPanel();
            ffP.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ffP.setLayout(new BorderLayout());
            Messages.getInstance();
            ffP.add((Component)new JLabel(Messages.getString("SerializedModelSaverCustomizer_SetUpFile_FfP_JLabel_Text")), "West");
            this.setUpFileFormatComboBox();
            ffP.add((Component)this.m_fileFormatBox, "Center");
            innerPanel.add((Component)ffP, "Center");
        }
        catch (Exception ex) {
            // empty catch block
        }
        JPanel about = this.m_SaverEditor.getAboutPanel();
        if (about != null) {
            innerPanel.add((Component)about, "North");
        }
        this.add((Component)innerPanel, "North");
        this.add((Component)this.m_fileChooser, "Center");
        Messages.getInstance();
        this.m_relativeFilePath = new JCheckBox(Messages.getString("SerializedModelSaverCustomizer_SetUpFile_RelativeFilePath_JCheckBox_Text"));
        this.m_relativeFilePath.setSelected(this.m_smSaver.getUseRelativePath());
        this.m_relativeFilePath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SerializedModelSaverCustomizer.this.m_smSaver.setUseRelativePath(SerializedModelSaverCustomizer.this.m_relativeFilePath.isSelected());
            }
        });
        JPanel holderPanel = new JPanel();
        holderPanel.setLayout(new FlowLayout());
        holderPanel.add(this.m_relativeFilePath);
        this.add((Component)holderPanel, "South");
    }

    public void setObject(Object object) {
        this.m_smSaver = (SerializedModelSaver)object;
        this.m_SaverEditor.setTarget(this.m_smSaver);
        this.setUpFile();
    }

    private void setUpFileFormatComboBox() {
        this.m_fileFormatBox = new JComboBox();
        for (int i = 0; i < SerializedModelSaver.s_fileFormatsAvailable.size(); ++i) {
            Tag temp = SerializedModelSaver.s_fileFormatsAvailable.get(i);
            this.m_fileFormatBox.addItem(temp);
        }
        Tag result = this.m_smSaver.validateFileFormat(this.m_smSaver.getFileFormat());
        if (result == null) {
            this.m_fileFormatBox.setSelectedIndex(0);
        } else {
            this.m_fileFormatBox.setSelectedItem(result);
        }
        this.m_fileFormatBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Tag selected = (Tag)SerializedModelSaverCustomizer.this.m_fileFormatBox.getSelectedItem();
                if (selected != null) {
                    SerializedModelSaverCustomizer.this.m_smSaver.setFileFormat(selected);
                }
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    static {
        GenericObjectEditor.registerEditors();
    }
}

