/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of powerd.
 *
 * powerd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * powerd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __LOG_H__
#define __LOG_H__

#include <syslog.h>

#ifdef __cplusplus
extern "C" {
#endif

#define POWERD_LOG_ERROR    LOG_ERR
#define POWERD_LOG_WARN     LOG_WARNING
#define POWERD_LOG_INFO     LOG_INFO
#define POWERD_LOG_DEBUG    LOG_DEBUG

#define powerd_error(f, a...)   powerd_log(POWERD_LOG_ERROR, f, ##a)
#define powerd_warn(f, a...)    powerd_log(POWERD_LOG_WARN, f, ##a)
#define powerd_info(f, a...)    powerd_log(POWERD_LOG_INFO, f, ##a)
#define powerd_debug(f, a...)   powerd_log(POWERD_LOG_DEBUG, f, ##a)

void powerd_log(int level, const char *fmt, ...)
        __attribute__ ((format (printf, 2, 3)));
void powerd_log_init(void);

#define powerd_warn_if_fail(expr) \
  do { \
    if (!(expr)) \
        powerd_warn("%s", #expr); \
  } while (0)

#define powerd_return_if_fail(expr) \
  do { \
    if (!(expr)) { \
        powerd_warn("%s: assertion '%s' failed", __func__,  #expr); \
        return; \
    } \
  } while (0)

#define powerd_return_val_if_fail(expr,val) \
  do { \
    if (!(expr)) { \
        powerd_warn("%s: assertion '%s' failed", __func__,  #expr); \
        return val; \
    } \
  } while (0)


#ifdef __cplusplus
}
#endif

#endif /* __LOG_H__ */
